/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.fabric.storage.diskdrive;

import com.refinedmods.refinedstorage.common.storage.diskdrive.DiskDriveBlock;
import com.refinedmods.refinedstorage.common.support.direction.BiDirection;
import com.refinedmods.refinedstorage.fabric.storage.AbstractDiskContainerBakedModel;
import com.refinedmods.refinedstorage.fabric.support.render.QuadRotators;
import com.refinedmods.refinedstorage.fabric.support.render.QuadTranslator;
import java.util.Map;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1087;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_5819;

class DiskDriveBakedModel
extends AbstractDiskContainerBakedModel {
    private final QuadRotators quadRotators;

    DiskDriveBakedModel(class_1087 baseModel, Map<class_1792, class_1087> diskModels, class_1087 inactiveLedModel, QuadRotators quadRotators) {
        super(diskModels, inactiveLedModel, DiskDriveBakedModel.getDiskTranslations());
        this.wrapped = baseModel;
        this.quadRotators = quadRotators;
    }

    private static QuadTranslator[] getDiskTranslations() {
        QuadTranslator[] translations = new QuadTranslator[8];
        int i = 0;
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 2; ++x) {
                translations[i++] = new QuadTranslator(x == 0 ? -0.125f : -0.5625f, -((float)y * 3.0f / 16.0f) - 0.125f, 0.0f);
            }
        }
        return translations;
    }

    @Override
    public void emitItemQuads(class_1799 stack, Supplier<class_5819> randomSupplier, RenderContext context) {
        this.wrapped.emitItemQuads(stack, randomSupplier, context);
        super.emitItemQuads(stack, randomSupplier, context);
    }

    @Override
    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
        class_2248 class_22482 = state.method_26204();
        if (!(class_22482 instanceof DiskDriveBlock)) {
            return;
        }
        DiskDriveBlock diskDriveBlock = (DiskDriveBlock)class_22482;
        BiDirection direction = (BiDirection)((Object)diskDriveBlock.getDirection(state));
        if (direction == null) {
            return;
        }
        context.pushTransform((RenderContext.QuadTransform)this.quadRotators.forDirection(direction));
        this.wrapped.emitBlockQuads(blockView, state, pos, randomSupplier, context);
        super.emitBlockQuads(blockView, state, pos, randomSupplier, context);
        context.popTransform();
    }
}

