/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.fabric.storage.externalstorage;

import com.google.common.collect.Iterators;
import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.core.NullableType;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.external.ExternalStorageProvider;
import com.refinedmods.refinedstorage.fabric.storage.FabricStorageExtractableStorage;
import com.refinedmods.refinedstorage.fabric.storage.FabricStorageInsertableStorage;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3218;

class FabricStorageExternalStorageProvider<P>
implements ExternalStorageProvider {
    private final BlockApiCache<Storage<P>, class_2350> cache;
    private final Function<P, ResourceKey> fromPlatformMapper;
    private final FabricStorageExtractableStorage<P> extractTarget;
    private final FabricStorageInsertableStorage<P> insertTarget;
    private final class_2350 direction;

    FabricStorageExternalStorageProvider(BlockApiLookup<Storage<P>, class_2350> lookup, Function<P, ResourceKey> fromPlatformMapper, Function<ResourceKey, @NullableType P> toPlatformMapper, class_3218 serverLevel, class_2338 pos, class_2350 direction) {
        this.cache = BlockApiCache.create(lookup, (class_3218)serverLevel, (class_2338)pos);
        this.fromPlatformMapper = fromPlatformMapper;
        this.extractTarget = new FabricStorageExtractableStorage<P>(lookup, toPlatformMapper, serverLevel, pos, direction);
        this.insertTarget = new FabricStorageInsertableStorage<P>(lookup, toPlatformMapper, serverLevel, pos, direction);
        this.direction = direction;
    }

    @Override
    public long extract(ResourceKey resource, long amount, Action action, Actor actor) {
        return this.extractTarget.extract(resource, amount, action, actor);
    }

    @Override
    public long insert(ResourceKey resource, long amount, Action action, Actor actor) {
        return this.insertTarget.insert(resource, amount, action, actor);
    }

    @Override
    public Iterator<ResourceAmount> iterator() {
        Storage storage = (Storage)this.cache.find((Object)this.direction);
        if (storage == null) {
            return Collections.emptyListIterator();
        }
        Iterator iterator = storage.iterator();
        return Iterators.transform((Iterator)Iterators.filter((Iterator)iterator, storageView -> !storageView.isResourceBlank() && storageView.getAmount() > 0L), storageView -> new ResourceAmount(this.fromPlatformMapper.apply(storageView.getResource()), storageView.getAmount()));
    }
}

