/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.fabric.storage.portablegrid;

import com.refinedmods.refinedstorage.api.storage.StorageState;
import com.refinedmods.refinedstorage.common.storage.Disk;
import com.refinedmods.refinedstorage.common.storage.portablegrid.PortableGridBlock;
import com.refinedmods.refinedstorage.common.storage.portablegrid.PortableGridBlockItem;
import com.refinedmods.refinedstorage.common.storage.portablegrid.PortableGridBlockItemRenderInfo;
import com.refinedmods.refinedstorage.common.support.direction.BiDirection;
import com.refinedmods.refinedstorage.common.util.ClientPlatformUtil;
import com.refinedmods.refinedstorage.fabric.storage.portablegrid.DiskLeds;
import com.refinedmods.refinedstorage.fabric.support.render.QuadRotators;
import com.refinedmods.refinedstorage.fabric.support.render.QuadTranslator;
import java.util.Map;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.model.ForwardingBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1087;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_5819;

public class PortableGridBakedModel
extends ForwardingBakedModel {
    private static final QuadTranslator MOVE_TO_DISK_LOCATION = new QuadTranslator(0.0f, -0.75f, 0.5625f);
    private static final QuadTranslator MOVE_TO_DISK_LED_LOCATION = new QuadTranslator(0.0f, -0.75f, 0.5625f);
    private final class_1087 activeModel;
    private final class_1087 inactiveModel;
    private final Map<class_1792, class_1087> diskModels;
    private final QuadRotators quadRotators;
    private final DiskLeds diskLeds;

    PortableGridBakedModel(class_1087 activeModel, class_1087 inactiveModel, Map<class_1792, class_1087> diskModels, QuadRotators quadRotators, DiskLeds diskLeds) {
        this.wrapped = inactiveModel;
        this.activeModel = activeModel;
        this.inactiveModel = inactiveModel;
        this.diskModels = diskModels;
        this.quadRotators = quadRotators;
        this.diskLeds = diskLeds;
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    public void emitItemQuads(class_1799 stack, Supplier<class_5819> randomSupplier, RenderContext context) {
        class_1937 level = ClientPlatformUtil.getClientLevel();
        if (level == null) {
            return;
        }
        PortableGridBlockItemRenderInfo renderInfo = PortableGridBlockItem.getRenderInfo(stack, level);
        (renderInfo.active() ? this.activeModel : this.inactiveModel).emitItemQuads(stack, randomSupplier, context);
        if (renderInfo.disk().state() != StorageState.NONE) {
            class_1087 diskModel = this.diskModels.get(renderInfo.disk().item());
            if (diskModel == null) {
                return;
            }
            context.pushTransform((RenderContext.QuadTransform)MOVE_TO_DISK_LOCATION);
            context.pushTransform((RenderContext.QuadTransform)this.quadRotators.forDirection(BiDirection.WEST));
            diskModel.emitItemQuads(stack, randomSupplier, context);
            context.popTransform();
            context.popTransform();
            context.pushTransform((RenderContext.QuadTransform)MOVE_TO_DISK_LED_LOCATION);
            context.pushTransform((RenderContext.QuadTransform)this.quadRotators.forDirection(BiDirection.WEST));
            this.diskLeds.forState(renderInfo.disk().state()).emitItemQuads(stack, randomSupplier, context);
            context.popTransform();
            context.popTransform();
        }
    }

    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
        boolean active;
        class_2248 class_22482 = state.method_26204();
        if (!(class_22482 instanceof PortableGridBlock)) {
            return;
        }
        PortableGridBlock portableGridBlock = (PortableGridBlock)class_22482;
        BiDirection direction = (BiDirection)((Object)portableGridBlock.getDirection(state));
        if (direction == null) {
            return;
        }
        context.pushTransform((RenderContext.QuadTransform)this.quadRotators.forDirection(direction));
        Object renderAttachment = blockView.getBlockEntityRenderData(pos);
        if (renderAttachment instanceof Disk) {
            Disk disk = (Disk)renderAttachment;
            this.emitDiskQuads(blockView, state, pos, randomSupplier, context, disk);
        }
        ((active = ((Boolean)state.method_11654((class_2769)PortableGridBlock.ACTIVE)).booleanValue()) ? this.activeModel : this.inactiveModel).emitBlockQuads(blockView, state, pos, randomSupplier, context);
        context.popTransform();
    }

    private void emitDiskQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context, Disk disk) {
        class_1087 diskModel = this.diskModels.get(disk.item());
        if (diskModel == null) {
            return;
        }
        context.pushTransform((RenderContext.QuadTransform)MOVE_TO_DISK_LOCATION);
        context.pushTransform((RenderContext.QuadTransform)this.quadRotators.forDirection(BiDirection.WEST));
        diskModel.emitBlockQuads(blockView, state, pos, randomSupplier, context);
        context.popTransform();
        context.popTransform();
    }
}

