/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.fabric.support.energy;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.energy.EnergyStorage;
import com.refinedmods.refinedstorage.common.support.energy.ItemBlockEnergyStorage;
import com.refinedmods.refinedstorage.common.support.energy.ItemEnergyStorage;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1799;

public class EnergyStorageAdapter
extends SnapshotParticipant<Long>
implements team.reborn.energy.api.EnergyStorage {
    private final EnergyStorage energyStorage;
    @Nullable
    private final ContainerItemContext containerItemContext;

    public EnergyStorageAdapter(EnergyStorage energyStorage, @Nullable ContainerItemContext containerItemContext) {
        this.energyStorage = energyStorage;
        this.containerItemContext = containerItemContext;
    }

    public EnergyStorageAdapter(EnergyStorage energyStorage) {
        this(energyStorage, null);
    }

    public EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    private void tryExchangeStack(TransactionContext transaction) {
        if (this.containerItemContext == null) {
            return;
        }
        class_1799 stack = this.extractStack();
        if (stack == null) {
            return;
        }
        this.containerItemContext.exchange(ItemVariant.of((class_1799)stack), 1L, transaction);
    }

    @Nullable
    private class_1799 extractStack() {
        EnergyStorage energyStorage = this.energyStorage;
        if (energyStorage instanceof ItemBlockEnergyStorage) {
            ItemBlockEnergyStorage itemBlockEnergyStorage = (ItemBlockEnergyStorage)energyStorage;
            return itemBlockEnergyStorage.getStack();
        }
        energyStorage = this.energyStorage;
        if (energyStorage instanceof ItemEnergyStorage) {
            ItemEnergyStorage itemEnergyStorage = (ItemEnergyStorage)energyStorage;
            return itemEnergyStorage.getStack();
        }
        return null;
    }

    public long insert(long maxAmount, TransactionContext transaction) {
        long insertedSimulated = this.energyStorage.receive(maxAmount, Action.SIMULATE);
        if (insertedSimulated > 0L) {
            this.updateSnapshots(transaction);
        }
        long inserted = this.energyStorage.receive(maxAmount, Action.EXECUTE);
        this.tryExchangeStack(transaction);
        return inserted;
    }

    public long extract(long maxAmount, TransactionContext transaction) {
        long extractedSimulated = this.energyStorage.extract(maxAmount, Action.SIMULATE);
        if (extractedSimulated > 0L) {
            this.updateSnapshots(transaction);
        }
        long extracted = this.energyStorage.extract(maxAmount, Action.EXECUTE);
        this.tryExchangeStack(transaction);
        return extracted;
    }

    public long getAmount() {
        return this.energyStorage.getStored();
    }

    public long getCapacity() {
        return this.energyStorage.getCapacity();
    }

    protected Long createSnapshot() {
        return this.energyStorage.getStored();
    }

    protected void readSnapshot(Long snapshot) {
        this.energyStorage.extract(Long.MAX_VALUE, Action.EXECUTE);
        this.energyStorage.receive(snapshot, Action.EXECUTE);
    }
}

