/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.fabric.support.render;

import com.refinedmods.refinedstorage.common.support.direction.BiDirection;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class QuadRotator
implements RenderContext.QuadTransform {
    private final BiDirection direction;

    public QuadRotator(BiDirection biDirection) {
        this.direction = biDirection;
    }

    public boolean transform(MutableQuadView quad) {
        Vector3f tmp = new Vector3f();
        for (int i = 0; i < 4; ++i) {
            quad.copyPos(i, tmp);
            tmp.add(-0.5f, -0.5f, -0.5f);
            tmp.rotate((Quaternionfc)this.direction.getQuaternion());
            tmp.add(0.5f, 0.5f, 0.5f);
            quad.pos(i, tmp);
            if (!quad.hasNormal(i)) continue;
            quad.copyNormal(i, tmp);
            tmp.rotate((Quaternionfc)this.direction.getQuaternion());
            quad.normal(i, tmp);
        }
        Matrix4f mat = new Matrix4f().rotationXYZ(this.direction.getVec().x() * ((float)Math.PI / 180), this.direction.getVec().y() * ((float)Math.PI / 180), this.direction.getVec().z() * ((float)Math.PI / 180));
        class_2350 nominalFace = quad.nominalFace();
        class_2350 cullFace = quad.cullFace();
        if (cullFace != null) {
            quad.cullFace(this.rotate(cullFace, mat));
        }
        if (nominalFace != null) {
            quad.nominalFace(this.rotate(nominalFace, mat));
        }
        return true;
    }

    private class_2350 rotate(class_2350 facing, Matrix4f mat) {
        class_2382 dir = facing.method_10163();
        Vector4f vec = new Vector4f((float)dir.method_10263(), (float)dir.method_10264(), (float)dir.method_10260(), 1.0f);
        mat.transform(vec);
        return class_2350.method_10147((float)vec.x(), (float)vec.y(), (float)vec.z());
    }
}

