/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.fabric.support.resource;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import com.refinedmods.refinedstorage.fabric.support.resource.VariantUtil;
import java.util.ArrayList;
import java.util.Iterator;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;

public class ResourceContainerFluidStorageAdapter
extends SnapshotParticipant<ResourceContainer>
implements Storage<FluidVariant> {
    private final ResourceContainer resourceContainer;

    public ResourceContainerFluidStorageAdapter(ResourceContainer resourceContainer) {
        this.resourceContainer = resourceContainer;
    }

    public long insert(FluidVariant fluidVariant, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative((TransferVariant)fluidVariant, (long)maxAmount);
        FluidResource fluidResource = VariantUtil.ofFluidVariant(fluidVariant);
        long insertedSimulated = this.resourceContainer.insert(fluidResource, maxAmount, Action.SIMULATE);
        if (insertedSimulated > 0L) {
            this.updateSnapshots(transaction);
        }
        return this.resourceContainer.insert(fluidResource, maxAmount, Action.EXECUTE);
    }

    public long extract(FluidVariant fluidVariant, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative((TransferVariant)fluidVariant, (long)maxAmount);
        FluidResource fluidResource = VariantUtil.ofFluidVariant(fluidVariant);
        long extractedSimulated = this.resourceContainer.extract(fluidResource, maxAmount, Action.SIMULATE);
        if (extractedSimulated > 0L) {
            this.updateSnapshots(transaction);
        }
        return this.resourceContainer.extract(fluidResource, maxAmount, Action.EXECUTE);
    }

    public Iterator<StorageView<FluidVariant>> iterator() {
        ArrayList<StorageViewImpl> list = new ArrayList<StorageViewImpl>();
        for (int i = 0; i < this.resourceContainer.size(); ++i) {
            list.add(new StorageViewImpl(i));
        }
        return list.iterator();
    }

    protected ResourceContainer createSnapshot() {
        return this.resourceContainer.copy();
    }

    protected void readSnapshot(ResourceContainer snapshot) {
        for (int i = 0; i < snapshot.size(); ++i) {
            ResourceAmount snapshotSlot = snapshot.get(i);
            if (snapshotSlot == null) {
                this.resourceContainer.remove(i);
                continue;
            }
            this.resourceContainer.set(i, snapshotSlot);
        }
    }

    private class StorageViewImpl
    implements StorageView<FluidVariant> {
        private final int index;

        private StorageViewImpl(int index) {
            this.index = index;
        }

        public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
            FluidResource fluidResource;
            ResourceKey resourceKey;
            ResourceAmount resourceAmount = ResourceContainerFluidStorageAdapter.this.resourceContainer.get(this.index);
            if (resourceAmount == null || !((resourceKey = resourceAmount.resource()) instanceof FluidResource) || !resource.equals((Object)VariantUtil.toFluidVariant(fluidResource = (FluidResource)resourceKey))) {
                return 0L;
            }
            long extracted = Math.min(maxAmount, resourceAmount.amount());
            if (extracted > 0L) {
                ResourceContainerFluidStorageAdapter.this.updateSnapshots(transaction);
            }
            ResourceContainerFluidStorageAdapter.this.resourceContainer.shrink(this.index, extracted);
            return extracted;
        }

        public boolean isResourceBlank() {
            return ResourceContainerFluidStorageAdapter.this.resourceContainer.isEmpty(this.index);
        }

        public FluidVariant getResource() {
            PlatformResourceKey resource = ResourceContainerFluidStorageAdapter.this.resourceContainer.getResource(this.index);
            if (!(resource instanceof FluidResource)) {
                return FluidVariant.blank();
            }
            FluidResource fluidResource = (FluidResource)resource;
            return VariantUtil.toFluidVariant(fluidResource);
        }

        public long getAmount() {
            return ResourceContainerFluidStorageAdapter.this.resourceContainer.getAmount(this.index);
        }

        public long getCapacity() {
            PlatformResourceKey resource = ResourceContainerFluidStorageAdapter.this.resourceContainer.getResource(this.index);
            if (resource == null) {
                return 0L;
            }
            return ResourceContainerFluidStorageAdapter.this.resourceContainer.getMaxAmount(resource);
        }
    }
}

