/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.catloaf.common.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import me.khajiitos.catloaf.common.CatLoaf;
import me.khajiitos.catloaf.common.config.CatLoafConfigValues;

public class CatLoafConfig {
    private static final File file = new File("config/cat_loaf.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    @Entry
    public static final CatLoafConfigValues.IntValue loafChance = new CatLoafConfigValues.IntValue(50).withMin(0).withMax(100);
    @Entry
    public static final CatLoafConfigValues.BooleanValue overrideChanceWithBread = new CatLoafConfigValues.BooleanValue(true);
    @Entry
    public static final CatLoafConfigValues.BooleanValue hideTailWhenLoafing = new CatLoafConfigValues.BooleanValue(true);

    public static void init() {
        if (!file.exists()) {
            CatLoafConfig.save();
        } else {
            CatLoafConfig.load();
        }
    }

    public static void save() {
        if (!file.getParentFile().isDirectory() && !file.getParentFile().mkdirs()) {
            CatLoaf.LOGGER.error("Failed to create the config directory");
            return;
        }
        try (FileWriter fileWriter = new FileWriter(file);){
            JsonObject jsonObject = new JsonObject();
            for (Field field : CatLoafConfig.class.getDeclaredFields()) {
                Object object;
                if (!field.isAnnotationPresent(Entry.class) || !((object = field.get(null)) instanceof CatLoafConfigValues.Value)) continue;
                CatLoafConfigValues.Value configValue = (CatLoafConfigValues.Value)object;
                jsonObject.add(field.getName(), configValue.write());
            }
            GSON.toJson((JsonElement)jsonObject, (Appendable)fileWriter);
        }
        catch (IOException e) {
            CatLoaf.LOGGER.error("Failed to save the Cat Loaf config", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            CatLoaf.LOGGER.error("Error while saving the Cat Loaf config", (Throwable)e);
        }
    }

    public static void load() {
        if (!file.exists()) {
            return;
        }
        try (FileReader fileReader = new FileReader(file);){
            JsonObject jsonObject = (JsonObject)GSON.fromJson((Reader)fileReader, JsonObject.class);
            for (Field field : CatLoafConfig.class.getDeclaredFields()) {
                Object object;
                String fieldName;
                if (!field.isAnnotationPresent(Entry.class) || !jsonObject.has(fieldName = field.getName()) || !((object = field.get(null)) instanceof CatLoafConfigValues.Value)) continue;
                CatLoafConfigValues.Value configValue = (CatLoafConfigValues.Value)object;
                JsonElement jsonElement = jsonObject.get(fieldName);
                configValue.setUnchecked(configValue.read(jsonElement));
            }
        }
        catch (IOException e) {
            CatLoaf.LOGGER.error("Failed to read the Cat Loaf config", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            CatLoaf.LOGGER.error("Error while reading the Cat Loaf config", (Throwable)e);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface Entry {
    }
}

