/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.coroutil.util;

import com.corosus.coroutil.util.CULog;
import com.corosus.modconfig.IConfigCategory;
import com.corosus.modconfig.ModConfigData;

public class MultiLoaderUtil {
    private static final MultiLoaderUtil instance = new MultiLoaderUtil();
    private boolean checkForge = true;
    private boolean isForge = false;
    private boolean checkNeoForge = true;
    private boolean isNeoForge = false;
    private boolean checkFabric = true;
    private boolean isFabric = false;

    private MultiLoaderUtil() {
    }

    public static synchronized MultiLoaderUtil instance() {
        return instance;
    }

    public synchronized boolean isForge() {
        if (this.checkForge) {
            try {
                this.checkForge = false;
                boolean bl = this.isForge = Class.forName("com.corosus.coroutil.loader.forge.ConfigModForge") != null;
                if (this.isForge) {
                    CULog.log("forge loader environment detected");
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (this.isForge && this.isFabric()) {
            CULog.err("ERROR: DETECTED FABRIC AND FORGE BOTH PRESENT, THIS MIGHT BREAK THIS LOGIC, should only happen when using build_dev.gradle");
        }
        return this.isForge;
    }

    public synchronized boolean isNeoForge() {
        if (this.checkNeoForge) {
            try {
                this.checkNeoForge = false;
                boolean bl = this.isNeoForge = Class.forName("com.corosus.coroutil.loader.neoforge.ConfigModNeoForge") != null;
                if (this.isNeoForge) {
                    CULog.log("neo forge loader environment detected");
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (this.isNeoForge && this.isFabric()) {
            CULog.err("ERROR: DETECTED FABRIC AND FORGE BOTH PRESENT, THIS MIGHT BREAK THIS LOGIC, should only happen when using build_dev.gradle");
        }
        return this.isNeoForge;
    }

    public synchronized boolean isFabric() {
        if (this.checkFabric) {
            try {
                this.checkFabric = false;
                boolean bl = this.isFabric = Class.forName("com.corosus.coroutil.loader.fabric.ConfigModFabric") != null;
                if (this.isFabric) {
                    CULog.log("fabric loader environment detected");
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return this.isFabric;
    }

    public synchronized ModConfigData makeLoaderSpecificConfigData(String savePath, String parStr, Class parClass, IConfigCategory parConfig) {
        if (this.isFabric()) {
            return this.constructLoaderSpecificConfigData("com.corosus.coroutil.loader.fabric.ModConfigDataFabric", savePath, parStr, parClass, parConfig);
        }
        if (this.isForge()) {
            return this.constructLoaderSpecificConfigData("com.corosus.coroutil.loader.forge.ModConfigDataForge", savePath, parStr, parClass, parConfig);
        }
        if (this.isNeoForge()) {
            return this.constructLoaderSpecificConfigData("com.corosus.coroutil.loader.neoforge.ModConfigDataNeoForge", savePath, parStr, parClass, parConfig);
        }
        return null;
    }

    private ModConfigData constructLoaderSpecificConfigData(String clazz, String savePath, String parStr, Class parClass, IConfigCategory parConfig) {
        try {
            Class<?> classToLoad = Class.forName(clazz);
            Class[] cArg = new Class[]{String.class, String.class, Class.class, IConfigCategory.class};
            return (ModConfigData)classToLoad.getDeclaredConstructor(cArg).newInstance(savePath, parStr, parClass, parConfig);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

