/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.refurbished.block.FurnitureHorizontalEntityBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.ToiletBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.fluid.FluidContainer;
import com.mrcrayfish.furniture.refurbished.entity.Seat;
import com.mrcrayfish.furniture.refurbished.platform.Services;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import com.mrcrayfish.furniture.refurbished.util.VoxelShapeHelper;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_9062;
import org.jetbrains.annotations.Nullable;

public abstract class ToiletBlock
extends FurnitureHorizontalEntityBlock {
    public ToiletBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)DIRECTION, (Comparable)class_2350.field_11043));
    }

    @Override
    protected Map<class_2680, class_265> generateShapes(ImmutableList<class_2680> states) {
        class_265 seatShape = class_2248.method_9541((double)0.0, (double)4.0, (double)2.0, (double)16.0, (double)10.0, (double)14.0);
        class_265 tankShape = class_2248.method_9541((double)11.0, (double)10.0, (double)2.0, (double)16.0, (double)17.0, (double)14.0);
        class_265 lidShape = class_2248.method_9541((double)10.0, (double)17.0, (double)2.0, (double)16.0, (double)19.0, (double)14.0);
        class_265 supportShape = class_2248.method_9541((double)3.0, (double)0.0, (double)4.0, (double)16.0, (double)4.0, (double)12.0);
        class_265 combinedShape = VoxelShapeHelper.combine(List.of(seatShape, tankShape, lidShape, supportShape));
        return ImmutableMap.copyOf(states.stream().collect(Collectors.toMap(state -> state, state -> VoxelShapeHelper.rotateHorizontally(combinedShape, (class_2350)state.method_11654((class_2769)DIRECTION)))));
    }

    public class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 result) {
        class_243 hit;
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof ToiletBlockEntity) {
            ToiletBlockEntity toilet = (ToiletBlockEntity)class_25862;
            return toilet.interact(player, hand, result);
        }
        if (!level.method_8608() && (hit = result.method_17784().method_1020(class_243.method_24954((class_2382)pos))).method_10214() <= 0.625 && Seat.sit(player, pos, Utils.pixels(10.0), ((class_2350)state.method_11654((class_2769)DIRECTION)).method_10153())) {
            return class_9062.field_47728;
        }
        return class_9062.field_47731;
    }

    public void method_9588(class_2680 state, class_3218 level, class_2338 pos, class_5819 randomSource) {
        ToiletBlockEntity toilet;
        FluidContainer container;
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof ToiletBlockEntity && (container = (toilet = (ToiletBlockEntity)class_25862).getFluidContainer()) != null) {
            this.handleEvent(level, pos, container);
        }
    }

    private void handleEvent(class_3218 level, class_2338 pos, FluidContainer container) {
        class_3414 event = Services.FLUID.getBucketEmptySound((class_3611)class_3612.field_15910);
        if (class_3612.field_15910.method_15780(container.getStoredFluid()) && event != null) {
            class_243 center = class_243.method_24953((class_2382)pos);
            level.method_14199((class_2394)class_2398.field_11202, center.field_1352, center.field_1351, center.field_1350, 10, 0.0, 0.0, 0.0, 0.0);
            level.method_8396(null, pos, event, class_3419.field_15245, 1.0f, 1.0f);
        } else if (class_3612.field_15908.method_15780(container.getStoredFluid())) {
            class_243 center = class_243.method_24953((class_2382)pos);
            level.method_14199((class_2394)class_2398.field_11251, center.field_1352, center.field_1351, center.field_1350, 5, 0.0, 0.0, 0.0, 0.0);
            level.method_8396(null, pos, class_3417.field_14821, class_3419.field_15245, 1.0f, 1.0f);
        }
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new ToiletBlockEntity(pos, state);
    }
}

