/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.cache.texture;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1084;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3270;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_4573;
import net.minecraft.class_4668;
import net.minecraft.class_757;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.GeckoLibServices;
import software.bernie.geckolib.cache.texture.AnimatableTexture;
import software.bernie.geckolib.cache.texture.GeoAbstractTexture;
import software.bernie.geckolib.resource.GeoGlowingTextureMeta;

public class AutoGlowingTexture
extends GeoAbstractTexture {
    private static final class_4668.class_5942 SHADER_STATE = new class_4668.class_5942(class_757::method_42595);
    private static final class_4668.class_4685 TRANSPARENCY_STATE = new class_4668.class_4685("translucent_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    private static final class_4668.class_4686 WRITE_MASK = new class_4668.class_4686(true, true);
    private static final BiFunction<class_2960, Boolean, class_1921> GLOWING_RENDER_TYPE = class_156.method_34865((texture, isGlowing) -> {
        class_4668.class_4683 textureState = new class_4668.class_4683(texture, false, false);
        return class_1921.method_24049((String)"geo_glowing_layer", (class_293)class_290.field_1580, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)false, (boolean)true, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34578(SHADER_STATE).method_34577((class_4668.class_5939)textureState).method_23615(TRANSPARENCY_STATE).method_23611(new class_4668.class_4679(true)).method_23616(WRITE_MASK).method_23617(isGlowing.booleanValue()));
    });
    @Deprecated(forRemoval=true)
    private static final Function<class_2960, class_1921> RENDER_TYPE_FUNCTION = class_156.method_34866(texture -> GLOWING_RENDER_TYPE.apply((class_2960)texture, false));
    private static final String APPENDIX = "_glowmask";
    public static boolean PRINT_DEBUG_IMAGES = false;
    protected final class_2960 textureBase;
    protected final class_2960 glowLayer;

    public AutoGlowingTexture(class_2960 originalLocation, class_2960 location) {
        this.textureBase = originalLocation;
        this.glowLayer = location;
    }

    public static class_2960 getEmissiveResource(class_2960 baseResource) {
        class_2960 path = AutoGlowingTexture.appendToPath(baseResource, APPENDIX);
        AutoGlowingTexture.generateTexture(path, textureManager -> textureManager.method_4616(path, (class_1044)new AutoGlowingTexture(baseResource, path)));
        return path;
    }

    @Override
    @Nullable
    protected class_4573 loadTexture(class_3300 resourceManager, class_310 mc) throws IOException {
        AnimatableTexture animatableTexture;
        boolean animated;
        class_1011 class_10112;
        class_1044 originalTexture;
        try {
            originalTexture = (class_1044)mc.method_5385(() -> mc.method_1531().method_4619(this.textureBase)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException("Failed to load original texture: " + String.valueOf(this.textureBase), e);
        }
        class_3298 textureBaseResource = (class_3298)resourceManager.method_14486(this.textureBase).get();
        if (originalTexture instanceof class_1043) {
            class_1043 dynamicTexture = (class_1043)originalTexture;
            class_10112 = dynamicTexture.method_4525();
        } else {
            class_10112 = class_1011.method_4309((InputStream)textureBaseResource.method_14482());
        }
        class_1011 baseImage = class_10112;
        class_1011 glowImage = null;
        Optional textureBaseMeta = textureBaseResource.method_14481().method_43041((class_3270)class_1084.field_5344);
        boolean blur = textureBaseMeta.isPresent() && ((class_1084)textureBaseMeta.get()).method_4696();
        boolean clamp = textureBaseMeta.isPresent() && ((class_1084)textureBaseMeta.get()).method_4697();
        try {
            Optional glowLayerResource = resourceManager.method_14486(this.glowLayer);
            GeoGlowingTextureMeta glowLayerMeta = null;
            if (glowLayerResource.isPresent()) {
                glowImage = class_1011.method_4309((InputStream)((class_3298)glowLayerResource.get()).method_14482());
                glowLayerMeta = GeoGlowingTextureMeta.fromExistingImage(glowImage);
            } else {
                Optional meta = textureBaseResource.method_14481().method_43041(GeoGlowingTextureMeta.DESERIALIZER);
                if (meta.isPresent()) {
                    glowLayerMeta = (GeoGlowingTextureMeta)meta.get();
                    glowImage = new class_1011(baseImage.method_4307(), baseImage.method_4323(), true);
                }
            }
            if (glowLayerMeta != null) {
                glowLayerMeta.createImageMask(baseImage, glowImage);
                if (PRINT_DEBUG_IMAGES && GeckoLibServices.PLATFORM.isDevelopmentEnvironment()) {
                    this.printDebugImageToDisk(this.textureBase, baseImage);
                    this.printDebugImageToDisk(this.glowLayer, glowImage);
                }
            }
        }
        catch (IOException e) {
            GeckoLibConstants.LOGGER.warn("Resource failed to open for glowlayer meta: {}", (Object)this.glowLayer, (Object)e);
        }
        class_1011 mask = glowImage;
        if (mask == null) {
            return null;
        }
        if ((mask.method_4307() != baseImage.method_4307() || mask.method_4323() != baseImage.method_4323()) && resourceManager.method_14486(this.glowLayer).isPresent()) {
            String formatText = String.format("Glow image for texture %s has diferent dimensions than base image: %s", this.glowLayer, this.textureBase);
            throw new IOException(formatText);
        }
        boolean bl = animated = originalTexture instanceof AnimatableTexture && (animatableTexture = (AnimatableTexture)originalTexture).isAnimated();
        if (animated) {
            ((AnimatableTexture)originalTexture).animationContents.animatedTexture.setGlowMaskTexture(this, baseImage, mask);
        }
        return () -> {
            if (!animated) {
                AutoGlowingTexture.uploadSimple(this.method_4624(), mask, blur, clamp);
            }
            if (originalTexture instanceof class_1043) {
                class_1043 dynamicTexture = (class_1043)originalTexture;
                dynamicTexture.method_4524();
            } else {
                AutoGlowingTexture.uploadSimple(originalTexture.method_4624(), baseImage, blur, clamp);
            }
        };
    }

    public static class_1921 getRenderType(class_2960 texture) {
        return GLOWING_RENDER_TYPE.apply(AutoGlowingTexture.getEmissiveResource(texture), false);
    }

    public static class_1921 getOutlineRenderType(class_2960 texture) {
        return GLOWING_RENDER_TYPE.apply(AutoGlowingTexture.getEmissiveResource(texture), true);
    }
}

