/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.network;

import com.google.common.collect.Lists;
import dev.emi.emi.network.EmiNetwork;
import dev.emi.emi.network.EmiPacket;
import dev.emi.emi.runtime.EmiLog;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import org.jetbrains.annotations.Nullable;

public class FillRecipeC2SPacket
implements EmiPacket {
    private final int syncId;
    private final int action;
    private final List<Integer> slots;
    private final List<Integer> crafting;
    private final int output;
    private final List<class_1799> stacks;

    public FillRecipeC2SPacket(class_1703 handler, int action, List<class_1735> slots, List<class_1735> crafting, @Nullable class_1735 output, List<class_1799> stacks) {
        this.syncId = handler.field_7763;
        this.action = action;
        this.slots = slots.stream().map(s -> s == null ? -1 : s.field_7874).toList();
        this.crafting = crafting.stream().map(s -> s == null ? -1 : s.field_7874).toList();
        this.output = output == null ? -1 : output.field_7874;
        this.stacks = stacks;
    }

    public FillRecipeC2SPacket(class_9129 buf) {
        this.syncId = buf.readInt();
        this.action = buf.readByte();
        this.slots = FillRecipeC2SPacket.parseCompressedSlots((class_2540)buf);
        this.crafting = Lists.newArrayList();
        int craftingSize = buf.method_10816();
        for (int i = 0; i < craftingSize; ++i) {
            int s = buf.method_10816();
            this.crafting.add(s);
        }
        this.output = buf.readBoolean() ? buf.method_10816() : -1;
        int size = buf.method_10816();
        this.stacks = Lists.newArrayList();
        for (int i = 0; i < size; ++i) {
            this.stacks.add((class_1799)class_1799.field_49268.decode((Object)buf));
        }
    }

    @Override
    public void write(class_9129 buf) {
        buf.method_53002(this.syncId);
        buf.method_52997(this.action);
        FillRecipeC2SPacket.writeCompressedSlots(this.slots, (class_2540)buf);
        buf.method_10804(this.crafting.size());
        for (Integer s : this.crafting) {
            buf.method_10804(s.intValue());
        }
        if (this.output != -1) {
            buf.method_52964(true);
            buf.method_10804(this.output);
        } else {
            buf.method_52964(false);
        }
        buf.method_10804(this.stacks.size());
        for (class_1799 stack : this.stacks) {
            class_1799.field_49268.encode((Object)buf, (Object)stack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(class_1657 player) {
        if (this.slots == null || this.crafting == null) {
            EmiLog.error("Client requested fill but passed input and crafting slot information was invalid, aborting");
            return;
        }
        class_1703 handler = player.field_7512;
        if (handler == null || handler.field_7763 != this.syncId) {
            EmiLog.warn("Client requested fill but screen handler has changed, aborting");
            return;
        }
        ArrayList slots = Lists.newArrayList();
        ArrayList crafting = Lists.newArrayList();
        class_1735 output = null;
        for (int i : this.slots) {
            if (i < 0 || i >= handler.field_7761.size()) {
                EmiLog.error("Client requested fill but passed input slots don't exist, aborting");
                return;
            }
            slots.add((class_1735)handler.field_7761.get(i));
        }
        for (int i : this.crafting) {
            if (i >= 0 && i < handler.field_7761.size()) {
                crafting.add((class_1735)handler.field_7761.get(i));
                continue;
            }
            crafting.add(null);
        }
        if (this.output != -1 && this.output >= 0 && this.output < handler.field_7761.size()) {
            output = (class_1735)handler.field_7761.get(this.output);
        }
        if (crafting.size() >= this.stacks.size()) {
            int i;
            ArrayList rubble = Lists.newArrayList();
            for (i = 0; i < crafting.size(); ++i) {
                class_1735 s = (class_1735)crafting.get(i);
                if (s == null || !s.method_7674(player) || s.method_7677().method_7960()) continue;
                class_1799 taken = s.method_7677();
                rubble.add(taken.method_7972());
                s.method_53512(class_1799.field_8037);
                s.method_7667(player, taken);
            }
            try {
                for (i = 0; i < this.stacks.size(); ++i) {
                    class_1799 stack = this.stacks.get(i);
                    if (stack.method_7960()) continue;
                    int gotten = FillRecipeC2SPacket.grabMatching(player, slots, rubble, crafting, stack);
                    if (gotten != stack.method_7947()) {
                        if (gotten > 0) {
                            stack.method_7939(gotten);
                            player.method_31548().method_7398(stack);
                        }
                        return;
                    }
                    class_1735 s = (class_1735)crafting.get(i);
                    if (s != null && s.method_7680(stack) && stack.method_7947() <= s.method_7675() && stack.method_7947() <= stack.method_7914()) {
                        s.method_53512(stack);
                        continue;
                    }
                    player.method_31548().method_7398(stack);
                }
                if (output != null) {
                    if (this.action == 1) {
                        handler.method_7593(output.method_34266(), 0, class_1713.field_7790, player);
                    } else if (this.action == 2) {
                        handler.method_7593(output.method_34266(), 0, class_1713.field_7794, player);
                    }
                }
            }
            finally {
                for (class_1799 stack : rubble) {
                    player.method_31548().method_7398(stack);
                }
            }
        }
    }

    private static List<Integer> parseCompressedSlots(class_2540 buf) {
        ArrayList list = Lists.newArrayList();
        int amount = buf.method_10816();
        for (int i = 0; i < amount; ++i) {
            int low = buf.method_10816();
            int high = buf.method_10816();
            if (low < 0) {
                return null;
            }
            for (int j = low; j <= high; ++j) {
                list.add(j);
            }
        }
        return list;
    }

    private static void writeCompressedSlots(List<Integer> list, class_2540 buf) {
        ArrayList postWrite = Lists.newArrayList();
        int groups = 0;
        int i = 0;
        while (i < list.size()) {
            ++groups;
            int start = i;
            int startValue = list.get(start);
            while (i < list.size() && i - start == list.get(i) - startValue) {
                ++i;
            }
            int end = i - 1;
            postWrite.add(b -> {
                b.method_10804(startValue);
                b.method_10804(((Integer)list.get(end)).intValue());
            });
        }
        buf.method_10804(groups);
        for (Consumer consumer : postWrite) {
            consumer.accept(buf);
        }
    }

    private static int grabMatching(class_1657 player, List<class_1735> slots, List<class_1799> rubble, List<class_1735> crafting, class_1799 stack) {
        int amount = stack.method_7947();
        int grabbed = 0;
        for (int i = 0; i < rubble.size(); ++i) {
            if (grabbed >= amount) {
                return grabbed;
            }
            class_1799 r = rubble.get(i);
            if (!class_1799.method_31577((class_1799)stack, (class_1799)r)) continue;
            int wanted = amount - grabbed;
            if (r.method_7947() <= wanted) {
                grabbed += r.method_7947();
                rubble.remove(i);
                --i;
                continue;
            }
            grabbed = amount;
            r.method_7939(r.method_7947() - wanted);
        }
        for (class_1735 s : slots) {
            class_1799 st;
            if (grabbed >= amount) {
                return grabbed;
            }
            if (crafting.contains(s) || !s.method_7674(player) || !class_1799.method_31577((class_1799)stack, (class_1799)(st = s.method_7677()))) continue;
            int wanted = amount - grabbed;
            class_1799 taken = st.method_7972();
            if (st.method_7947() <= wanted) {
                grabbed += st.method_7947();
                s.method_53512(class_1799.field_8037);
            } else {
                grabbed = amount;
                st.method_7939(st.method_7947() - wanted);
            }
            s.method_7667(player, taken);
        }
        return grabbed;
    }

    public class_8710.class_9154<FillRecipeC2SPacket> method_56479() {
        return EmiNetwork.FILL_RECIPE;
    }
}

