/*
 * Decompiled with CFR 0.152.
 */
package reborncore.client;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1703;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_638;
import net.minecraft.class_7225;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reborncore.RebornCore;
import reborncore.client.ClientChunkManager;
import reborncore.client.ItemStackRenderManager;
import reborncore.common.blockentity.FluidConfiguration;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.blockentity.SlotConfiguration;
import reborncore.common.network.clientbound.ChunkSyncPayload;
import reborncore.common.network.clientbound.CustomDescriptionPayload;
import reborncore.common.network.clientbound.FluidConfigSyncPayload;
import reborncore.common.network.clientbound.QueueItemStacksPayload;
import reborncore.common.network.clientbound.ScreenHandlerUpdatePayload;
import reborncore.common.network.clientbound.SlotSyncPayload;
import reborncore.common.screen.BuiltScreenHandler;

@Environment(value=EnvType.CLIENT)
public class ClientBoundPacketHandlers {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientBoundPacketHandlers.class);

    public static void init() {
        ClientPlayNetworking.registerGlobalReceiver(CustomDescriptionPayload.ID, (payload, context) -> {
            class_2586 blockentity;
            class_638 world = class_310.method_1551().field_1687;
            if (world.method_22340(payload.pos()) && (blockentity = world.method_8321(payload.pos())) != null && payload.nbt() != null) {
                blockentity.method_58690(payload.nbt(), (class_7225.class_7874)world.method_30349());
            }
        });
        ClientPlayNetworking.registerGlobalReceiver(FluidConfigSyncPayload.ID, (payload, context) -> {
            FluidConfiguration fluidConfiguration = payload.fluidConfiguration();
            if (!class_310.method_1551().field_1687.method_22340(payload.pos())) {
                return;
            }
            MachineBaseBlockEntity machineBase = (MachineBaseBlockEntity)class_310.method_1551().field_1687.method_8321(payload.pos());
            if (machineBase == null || machineBase.fluidConfiguration == null || fluidConfiguration == null) {
                RebornCore.LOGGER.error("Failed to sync fluid config data to " + String.valueOf(payload.pos()));
                return;
            }
            fluidConfiguration.getAllSides().forEach(fluidConfig -> machineBase.fluidConfiguration.updateFluidConfig((FluidConfiguration.FluidConfig)fluidConfig));
            machineBase.fluidConfiguration.setInput(fluidConfiguration.autoInput());
            machineBase.fluidConfiguration.setOutput(fluidConfiguration.autoOutput());
        });
        ClientPlayNetworking.registerGlobalReceiver(SlotSyncPayload.ID, (payload, context) -> {
            SlotConfiguration slotConfig = payload.slotConfig();
            if (!class_310.method_1551().field_1687.method_22340(payload.pos())) {
                return;
            }
            MachineBaseBlockEntity machineBase = (MachineBaseBlockEntity)class_310.method_1551().field_1687.method_8321(payload.pos());
            if (machineBase == null || machineBase.getSlotConfiguration() == null || slotConfig == null || slotConfig.getSlotDetails() == null) {
                RebornCore.LOGGER.error("Failed to sync slot data to " + String.valueOf(payload.pos()));
                return;
            }
            class_310.method_1551().execute(() -> slotConfig.getSlotDetails().forEach(slotConfigHolder -> machineBase.getSlotConfiguration().updateSlotDetails((SlotConfiguration.SlotConfigHolder)slotConfigHolder)));
        });
        ClientPlayNetworking.registerGlobalReceiver(ScreenHandlerUpdatePayload.ID, (payload, context) -> {
            class_465 handledScreen;
            class_1703 screenHandler;
            class_437 gui = class_310.method_1551().field_1755;
            if (gui instanceof class_465 && (screenHandler = (handledScreen = (class_465)gui).method_17577()) instanceof BuiltScreenHandler) {
                BuiltScreenHandler builtScreenHandler = (BuiltScreenHandler)screenHandler;
                builtScreenHandler.applyScreenHandlerData(payload.data());
            }
        });
        ClientPlayNetworking.registerGlobalReceiver(ChunkSyncPayload.ID, (payload, context) -> ClientChunkManager.setLoadedChunks(payload.chunks()));
        ClientPlayNetworking.registerGlobalReceiver(QueueItemStacksPayload.ID, (payload, context) -> ItemStackRenderManager.RENDER_QUEUE.addAll(payload.stacks()));
    }
}

