/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.blockentity;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.util.NBTSerializable;

public class FluidConfiguration
implements NBTSerializable {
    private static final class_9139<ByteBuf, Map<class_2350, FluidConfig>> SIDE_MAP_PACKET_CODEC = class_9135.method_56377(HashMap::new, (class_9139)class_2350.field_48450, FluidConfig.PACKET_CODEC);
    public static final class_9139<ByteBuf, FluidConfiguration> PACKET_CODEC = class_9139.method_56436(SIDE_MAP_PACKET_CODEC, FluidConfiguration::getSideMap, (class_9139)class_9135.field_48547, FluidConfiguration::autoInput, (class_9139)class_9135.field_48547, FluidConfiguration::autoOutput, FluidConfiguration::new);
    Map<class_2350, FluidConfig> sideMap;
    boolean input;
    boolean output;

    public FluidConfiguration() {
        this.sideMap = new HashMap<class_2350, FluidConfig>();
        Arrays.stream(class_2350.values()).forEach(facing -> this.sideMap.put((class_2350)facing, new FluidConfig((class_2350)facing)));
    }

    public FluidConfiguration(class_2487 tagCompound) {
        this.sideMap = new HashMap<class_2350, FluidConfig>();
        this.read(tagCompound);
    }

    private FluidConfiguration(Map<class_2350, FluidConfig> sideMap, boolean input, boolean output) {
        this.sideMap = sideMap;
        this.input = input;
        this.output = output;
    }

    public FluidConfig getSideDetail(class_2350 side) {
        if (side == null) {
            return this.sideMap.get(class_2350.field_11043);
        }
        return this.sideMap.get(side);
    }

    public List<FluidConfig> getAllSides() {
        return new ArrayList<FluidConfig>(this.sideMap.values());
    }

    public Map<class_2350, FluidConfig> getSideMap() {
        return this.sideMap;
    }

    public void updateFluidConfig(FluidConfig config) {
        FluidConfig toEdit = this.sideMap.get(config.side);
        toEdit.ioConfig = config.ioConfig;
    }

    public void update(MachineBaseBlockEntity machineBase) {
        if (!this.input && !this.output) {
            return;
        }
        if (machineBase.getTank() == null || machineBase.method_10997().method_8510() % (long)machineBase.slotTransferSpeed() != 0L) {
            return;
        }
        for (class_2350 facing : class_2350.values()) {
            FluidConfig fluidConfig = this.getSideDetail(facing);
            if (fluidConfig == null || !fluidConfig.getIoConfig().isEnabled()) continue;
            @Nullable Storage<FluidVariant> tank = this.getTank(machineBase, facing);
            if (this.autoInput() && fluidConfig.getIoConfig().isInsert()) {
                StorageUtil.move(tank, (Storage)machineBase.getTank(), fv -> true, (long)machineBase.fluidTransferAmount().getRawValue(), null);
            }
            if (!this.autoOutput() || !fluidConfig.getIoConfig().isExtract()) continue;
            StorageUtil.move((Storage)machineBase.getTank(), tank, fv -> true, (long)machineBase.fluidTransferAmount().getRawValue(), null);
        }
    }

    @Nullable
    private Storage<FluidVariant> getTank(MachineBaseBlockEntity machine, class_2350 facing) {
        class_2338 pos = machine.method_11016().method_10093(facing);
        return (Storage)FluidStorage.SIDED.find(machine.method_10997(), pos, (Object)facing.method_10153());
    }

    public boolean autoInput() {
        return this.input;
    }

    public boolean autoOutput() {
        return this.output;
    }

    public void setInput(boolean input) {
        this.input = input;
    }

    public void setOutput(boolean output) {
        this.output = output;
    }

    @Override
    @NotNull
    public class_2487 write() {
        class_2487 compound = new class_2487();
        Arrays.stream(class_2350.values()).forEach(facing -> compound.method_10566("side_" + facing.ordinal(), (class_2520)this.sideMap.get(facing).write()));
        compound.method_10556("input", this.input);
        compound.method_10556("output", this.output);
        return compound;
    }

    @Override
    public void read(@NotNull class_2487 nbt) {
        this.sideMap.clear();
        Arrays.stream(class_2350.values()).forEach(facing -> {
            class_2487 compound = nbt.method_10562("side_" + facing.ordinal());
            FluidConfig config = new FluidConfig(compound);
            this.sideMap.put((class_2350)facing, config);
        });
        this.input = nbt.method_10577("input");
        this.output = nbt.method_10577("output");
    }

    public static class FluidConfig
    implements NBTSerializable {
        public static final class_9139<ByteBuf, FluidConfig> PACKET_CODEC = class_9139.method_56435((class_9139)class_2350.field_48450, FluidConfig::getSide, ExtractConfig.PACKET_CODEC, FluidConfig::getIoConfig, FluidConfig::new);
        class_2350 side;
        ExtractConfig ioConfig;

        public FluidConfig(class_2350 side) {
            this.side = side;
            this.ioConfig = ExtractConfig.ALL;
        }

        public FluidConfig(class_2350 side, ExtractConfig ioConfig) {
            this.side = side;
            this.ioConfig = ioConfig;
        }

        public FluidConfig(class_2487 tagCompound) {
            this.read(tagCompound);
        }

        public class_2350 getSide() {
            return this.side;
        }

        public ExtractConfig getIoConfig() {
            return this.ioConfig;
        }

        @Override
        @NotNull
        public class_2487 write() {
            class_2487 tagCompound = new class_2487();
            tagCompound.method_10569("side", this.side.ordinal());
            tagCompound.method_10569("config", this.ioConfig.ordinal());
            return tagCompound;
        }

        @Override
        public void read(@NotNull class_2487 nbt) {
            this.side = class_2350.values()[nbt.method_10550("side")];
            this.ioConfig = ExtractConfig.values()[nbt.method_10550("config")];
        }
    }

    public static enum ExtractConfig {
        NONE(false, false),
        INPUT(false, true),
        OUTPUT(true, false),
        ALL(true, true);

        public static final class_9139<ByteBuf, ExtractConfig> PACKET_CODEC;
        boolean extract;
        boolean insert;

        private ExtractConfig(boolean extract, boolean insert) {
            this.extract = extract;
            this.insert = insert;
        }

        public boolean isExtract() {
            return this.extract;
        }

        public boolean isInsert() {
            return this.insert;
        }

        public boolean isEnabled() {
            return this.extract || this.insert;
        }

        public ExtractConfig getNext() {
            int i = this.ordinal() + 1;
            if (i >= ExtractConfig.values().length) {
                i = 0;
            }
            return ExtractConfig.values()[i];
        }

        static {
            PACKET_CODEC = class_9135.field_49675.method_56432(integer -> ExtractConfig.values()[integer], Enum::ordinal);
        }
    }
}

