/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.chunkloading;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_18;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2960;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import reborncore.common.network.NetworkManager;
import reborncore.common.network.clientbound.ChunkSyncPayload;

public class ChunkLoaderManager
extends class_18 {
    public static final class_18.class_8645<ChunkLoaderManager> TYPE = new class_18.class_8645(ChunkLoaderManager::new, ChunkLoaderManager::fromTag, null);
    public static Codec<List<LoadedChunk>> CODEC = Codec.list(LoadedChunk.CODEC);
    private static final class_3230<class_1923> CHUNK_LOADER = class_3230.method_14291((String)"reborncore:chunk_loader", Comparator.comparingLong(class_1923::method_8324));
    private static final String KEY = "reborncore_chunk_loader";
    private static final int RADIUS = 1;
    private final List<LoadedChunk> loadedChunks = new ArrayList<LoadedChunk>();

    public static ChunkLoaderManager get(class_1937 world) {
        class_3218 serverWorld = (class_3218)world;
        return (ChunkLoaderManager)serverWorld.method_17983().method_17924(TYPE, KEY);
    }

    public static ChunkLoaderManager fromTag(class_2487 tag, class_7225.class_7874 registryLookup) {
        ChunkLoaderManager chunkLoaderManager = new ChunkLoaderManager();
        chunkLoaderManager.loadedChunks.clear();
        List chunks = CODEC.parse((DynamicOps)class_2509.field_11560, (Object)tag.method_10554("loadedchunks", 10)).result().orElse(Collections.emptyList());
        chunkLoaderManager.loadedChunks.addAll(chunks);
        return chunkLoaderManager;
    }

    public class_2487 method_75(class_2487 compoundTag, class_7225.class_7874 registryLookup) {
        CODEC.encodeStart((DynamicOps)class_2509.field_11560, this.loadedChunks).result().ifPresent(tag -> compoundTag.method_10566("loadedchunks", tag));
        return compoundTag;
    }

    public Optional<LoadedChunk> getLoadedChunk(class_1937 world, class_1923 chunkPos, class_2338 chunkLoader) {
        return this.loadedChunks.stream().filter(loadedChunk -> loadedChunk.world().equals((Object)ChunkLoaderManager.getWorldName(world))).filter(loadedChunk -> loadedChunk.chunk().equals((Object)chunkPos)).filter(loadedChunk -> loadedChunk.chunkLoader().equals((Object)chunkLoader)).findFirst();
    }

    public Optional<LoadedChunk> getLoadedChunk(class_1937 world, class_1923 chunkPos) {
        return this.loadedChunks.stream().filter(loadedChunk -> loadedChunk.world().equals((Object)ChunkLoaderManager.getWorldName(world))).filter(loadedChunk -> loadedChunk.chunk().equals((Object)chunkPos)).findFirst();
    }

    public List<LoadedChunk> getLoadedChunks(class_1937 world, class_2338 chunkLoader) {
        return this.loadedChunks.stream().filter(loadedChunk -> loadedChunk.world().equals((Object)ChunkLoaderManager.getWorldName(world))).filter(loadedChunk -> loadedChunk.chunkLoader().equals((Object)chunkLoader)).collect(Collectors.toList());
    }

    public boolean isChunkLoaded(class_1937 world, class_1923 chunkPos, class_2338 chunkLoader) {
        return this.getLoadedChunk(world, chunkPos, chunkLoader).isPresent();
    }

    public boolean isChunkLoaded(class_1937 world, class_1923 chunkPos) {
        return this.getLoadedChunk(world, chunkPos).isPresent();
    }

    public void loadChunk(class_1937 world, class_1923 chunkPos, class_2338 chunkLoader, String player) {
        Validate.isTrue((!this.isChunkLoaded(world, chunkPos, chunkLoader) ? 1 : 0) != 0, (String)"chunk is already loaded", (Object[])new Object[0]);
        LoadedChunk loadedChunk = new LoadedChunk(chunkPos, ChunkLoaderManager.getWorldName(world), player, chunkLoader);
        this.loadedChunks.add(loadedChunk);
        this.loadChunk((class_3218)world, loadedChunk);
        this.method_80();
    }

    public void unloadChunkLoader(class_1937 world, class_2338 chunkLoader) {
        this.getLoadedChunks(world, chunkLoader).forEach(loadedChunk -> this.unloadChunk(world, loadedChunk.chunk(), chunkLoader));
    }

    public void unloadChunk(class_1937 world, class_1923 chunkPos, class_2338 chunkLoader) {
        Optional<LoadedChunk> optionalLoadedChunk = this.getLoadedChunk(world, chunkPos, chunkLoader);
        Validate.isTrue((boolean)optionalLoadedChunk.isPresent(), (String)"chunk is not loaded", (Object[])new Object[0]);
        LoadedChunk loadedChunk = optionalLoadedChunk.get();
        this.loadedChunks.remove(loadedChunk);
        if (!this.isChunkLoaded(world, loadedChunk.chunk())) {
            class_3215 serverChunkManager = ((class_3218)world).method_14178();
            serverChunkManager.method_17300(CHUNK_LOADER, loadedChunk.chunk(), 1, (Object)loadedChunk.chunk());
        }
        this.method_80();
    }

    public void onServerWorldLoad(class_3218 world) {
        this.loadedChunks.forEach(loadedChunk -> this.loadChunk(world, (LoadedChunk)loadedChunk));
    }

    public void onServerWorldTick(class_3218 world) {
        if (!this.loadedChunks.isEmpty()) {
            world.method_14197();
        }
    }

    public static class_2960 getWorldName(class_1937 world) {
        return world.method_27983().method_29177();
    }

    public static class_5321<class_1937> getDimensionRegistryKey(class_1937 world) {
        return world.method_27983();
    }

    public void syncChunkLoaderToClient(class_3222 serverPlayerEntity, class_2338 chunkLoader) {
        this.syncToClient(serverPlayerEntity, this.loadedChunks.stream().filter(loadedChunk -> loadedChunk.chunkLoader().equals((Object)chunkLoader)).collect(Collectors.toList()));
    }

    public void syncAllToClient(class_3222 serverPlayerEntity) {
        this.syncToClient(serverPlayerEntity, this.loadedChunks);
    }

    public void clearClient(class_3222 serverPlayerEntity) {
        this.syncToClient(serverPlayerEntity, Collections.emptyList());
    }

    public void syncToClient(class_3222 serverPlayerEntity, List<LoadedChunk> chunks) {
        NetworkManager.sendToPlayer(new ChunkSyncPayload(chunks), serverPlayerEntity);
    }

    private void loadChunk(class_3218 world, LoadedChunk loadedChunk) {
        class_1923 chunkPos = loadedChunk.chunk();
        world.method_14178().method_17297(CHUNK_LOADER, chunkPos, 1, (Object)chunkPos);
    }

    public record LoadedChunk(class_1923 chunk, class_2960 world, String player, class_2338 chunkLoader) {
        public static Codec<class_1923> CHUNK_POS_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("x").forGetter(p -> p.field_9181), (App)Codec.INT.fieldOf("z").forGetter(p -> p.field_9180)).apply((Applicative)instance, class_1923::new));
        public static Codec<LoadedChunk> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CHUNK_POS_CODEC.fieldOf("chunk").forGetter(LoadedChunk::chunk), (App)class_2960.field_25139.fieldOf("world").forGetter(LoadedChunk::world), (App)Codec.STRING.fieldOf("player").forGetter(LoadedChunk::player), (App)class_2338.field_25064.fieldOf("chunkLoader").forGetter(LoadedChunk::chunkLoader)).apply((Applicative)instance, LoadedChunk::new));
        public static class_9139<ByteBuf, class_1923> CHUNK_POS_PACKET_CODEC = class_9139.method_56435((class_9139)class_9135.field_49675, chunkPos -> chunkPos.field_9181, (class_9139)class_9135.field_49675, chunkPos -> chunkPos.field_9180, class_1923::new);
        public static class_9139<ByteBuf, LoadedChunk> PACKET_CODEC = class_9139.method_56905(CHUNK_POS_PACKET_CODEC, LoadedChunk::chunk, (class_9139)class_2960.field_48267, LoadedChunk::world, (class_9139)class_9135.field_48554, LoadedChunk::player, (class_9139)class_2338.field_48404, LoadedChunk::chunkLoader, LoadedChunk::new);

        public LoadedChunk {
            Validate.isTrue((!StringUtils.isBlank((CharSequence)player) ? 1 : 0) != 0, (String)"Player cannot be blank", (Object[])new Object[0]);
        }
    }
}

