/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.multiblock;

import java.util.HashMap;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_2791;
import reborncore.RebornCore;
import reborncore.common.multiblock.IMultiblockPart;
import reborncore.common.multiblock.MultiblockControllerBase;
import reborncore.common.multiblock.MultiblockWorldRegistry;

public class MultiblockRegistry {
    private static HashMap<class_1937, MultiblockWorldRegistry> registries = new HashMap();

    public static void tickStart(class_1937 world) {
        if (registries.containsKey(world)) {
            MultiblockWorldRegistry registry = registries.get(world);
            registry.processMultiblockChanges();
            registry.tickStart();
        }
    }

    public static void onChunkLoaded(class_1937 world, class_2791 chunk) {
        if (registries.containsKey(world)) {
            registries.get(world).onChunkLoaded(chunk);
        }
    }

    public static void onPartAdded(class_1937 world, IMultiblockPart part) {
        MultiblockWorldRegistry registry = MultiblockRegistry.getOrCreateRegistry(world);
        registry.onPartAdded(part);
    }

    public static void onPartRemovedFromWorld(class_1937 world, IMultiblockPart part) {
        if (registries.containsKey(world)) {
            registries.get(world).onPartRemovedFromWorld(part);
        }
    }

    public static void onWorldUnloaded(class_1937 world) {
        if (registries.containsKey(world)) {
            registries.get(world).onWorldUnloaded();
            registries.remove(world);
        }
    }

    public static void addDirtyController(class_1937 world, MultiblockControllerBase controller) {
        if (registries.containsKey(world)) {
            registries.get(world).addDirtyController(controller);
        } else {
            RebornCore.LOGGER.error("Adding a dirty controller to a world that has no registered controllers! This is most likely not an issue with reborn core, please check the full log file for more information!");
        }
    }

    public static void addDeadController(class_1937 world, MultiblockControllerBase controller) {
        if (registries.containsKey(world)) {
            registries.get(world).addDeadController(controller);
        } else {
            RebornCore.LOGGER.warn(String.format("Controller %d in world %s marked as dead, but that world is not tracked! Controller is being ignored.", controller.hashCode(), world));
        }
    }

    public static Set<MultiblockControllerBase> getControllersFromWorld(class_1937 world) {
        if (registries.containsKey(world)) {
            return registries.get(world).getControllers();
        }
        return null;
    }

    private static MultiblockWorldRegistry getOrCreateRegistry(class_1937 world) {
        if (registries.containsKey(world)) {
            return registries.get(world);
        }
        MultiblockWorldRegistry newRegistry = new MultiblockWorldRegistry(world);
        registries.put(world, newRegistry);
        return newRegistry;
    }
}

