/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.network;

import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.apache.commons.lang3.Validate;
import reborncore.common.blockentity.FluidConfiguration;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.blockentity.SlotConfiguration;
import reborncore.common.chunkloading.ChunkLoaderManager;
import reborncore.common.network.NetworkManager;
import reborncore.common.network.clientbound.FluidConfigSyncPayload;
import reborncore.common.network.clientbound.SlotSyncPayload;
import reborncore.common.network.serverbound.ChunkLoaderRequestPayload;
import reborncore.common.network.serverbound.FluidConfigSavePayload;
import reborncore.common.network.serverbound.FluidIoSavePayload;
import reborncore.common.network.serverbound.IoSavePayload;
import reborncore.common.network.serverbound.SetRedstoneStatePayload;
import reborncore.common.network.serverbound.SlotConfigSavePayload;
import reborncore.common.network.serverbound.SlotSavePayload;

public class ServerBoundPackets {
    public static void init() {
        ServerPlayNetworking.registerGlobalReceiver(FluidConfigSavePayload.ID, (payload, context) -> {
            MachineBaseBlockEntity machine = (MachineBaseBlockEntity)payload.getBlockEntity(MachineBaseBlockEntity.class, (class_1657)context.player());
            machine.fluidConfiguration.updateFluidConfig(payload.fluidConfiguration());
            machine.method_5431();
            NetworkManager.sendToTracking(new FluidConfigSyncPayload(payload.pos(), machine.fluidConfiguration), machine);
            class_1937 world = machine.method_10997();
            class_2680 blockState = world.method_8320(machine.method_11016());
            world.method_8452(machine.method_11016(), blockState.method_26204());
        });
        ServerPlayNetworking.registerGlobalReceiver(SlotConfigSavePayload.ID, (payload, context) -> {
            MachineBaseBlockEntity machine = (MachineBaseBlockEntity)payload.getBlockEntity(MachineBaseBlockEntity.class, (class_1657)context.player());
            for (SlotConfiguration.SlotConfigHolder slotDetail : payload.slotConfig().getSlotDetails()) {
                machine.getSlotConfiguration().updateSlotDetails(slotDetail);
            }
            machine.method_5431();
            NetworkManager.sendToWorld(new SlotSyncPayload(payload.pos(), machine.getSlotConfiguration()), (class_3218)machine.method_10997());
        });
        ServerPlayNetworking.registerGlobalReceiver(FluidIoSavePayload.ID, (payload, context) -> {
            MachineBaseBlockEntity machine = (MachineBaseBlockEntity)payload.getBlockEntity(MachineBaseBlockEntity.class, (class_1657)context.player());
            FluidConfiguration config = machine.fluidConfiguration;
            if (config == null) {
                return;
            }
            config.setInput(payload.input());
            config.setOutput(payload.output());
            NetworkManager.sendToTracking(new FluidConfigSyncPayload(payload.pos(), machine.fluidConfiguration), machine);
        });
        ServerPlayNetworking.registerGlobalReceiver(IoSavePayload.ID, (payload, context) -> {
            MachineBaseBlockEntity machine = (MachineBaseBlockEntity)payload.getBlockEntity(MachineBaseBlockEntity.class, (class_1657)context.player());
            Validate.notNull((Object)machine, (String)"machine cannot be null", (Object[])new Object[0]);
            SlotConfiguration.SlotConfigHolder holder = machine.getSlotConfiguration().getSlotDetails(payload.slotID());
            if (holder == null) {
                return;
            }
            holder.setInput(payload.input());
            holder.setOutput(payload.output());
            holder.setFilter(payload.filter());
            holder.setPriority(payload.priority());
            NetworkManager.sendToAll(new SlotSyncPayload(payload.pos(), machine.getSlotConfiguration()), context.player().method_5682());
        });
        ServerPlayNetworking.registerGlobalReceiver(SlotSavePayload.ID, (payload, context) -> {
            MachineBaseBlockEntity machine = (MachineBaseBlockEntity)payload.getBlockEntity(MachineBaseBlockEntity.class, (class_1657)context.player());
            machine.getSlotConfiguration().getSlotDetails(payload.slotConfig().getSlotID()).updateSlotConfig(payload.slotConfig());
            machine.method_5431();
            NetworkManager.sendToWorld(new SlotSyncPayload(payload.pos(), machine.getSlotConfiguration()), (class_3218)machine.method_10997());
        });
        ServerPlayNetworking.registerGlobalReceiver(ChunkLoaderRequestPayload.ID, (payload, context) -> {
            payload.getBlockEntity(MachineBaseBlockEntity.class, (class_1657)context.player());
            ChunkLoaderManager chunkLoaderManager = ChunkLoaderManager.get(context.player().method_37908());
            chunkLoaderManager.syncChunkLoaderToClient(context.player(), payload.pos());
        });
        ServerPlayNetworking.registerGlobalReceiver(SetRedstoneStatePayload.ID, (payload, context) -> {
            MachineBaseBlockEntity machine = (MachineBaseBlockEntity)payload.getBlockEntity(MachineBaseBlockEntity.class, (class_1657)context.player());
            machine.setRedstoneConfiguration(machine.getRedstoneConfiguration().withState(payload.element(), payload.state()));
        });
    }
}

