/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.screen.builder;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1263;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2586;
import net.minecraft.class_2609;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.apache.commons.lang3.Range;
import reborncore.RebornCore;
import reborncore.api.blockentity.IUpgrade;
import reborncore.api.blockentity.IUpgradeable;
import reborncore.api.recipe.IRecipeCrafterProvider;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.blockentity.RedstoneConfiguration;
import reborncore.common.fluid.FluidUtils;
import reborncore.common.powerSystem.PowerAcceptorBlockEntity;
import reborncore.common.screen.Syncable;
import reborncore.common.screen.builder.ScreenHandlerBuilder;
import reborncore.common.screen.builder.SyncedObject;
import reborncore.common.screen.slot.BaseSlot;
import reborncore.common.screen.slot.FilteredSlot;
import reborncore.common.screen.slot.SlotFake;
import reborncore.common.screen.slot.SlotOutput;
import reborncore.common.screen.slot.UpgradeSlot;
import team.reborn.energy.api.EnergyStorageUtil;

public class BlockEntityScreenHandlerBuilder {
    private final class_1263 inventory;
    private final class_2586 blockEntity;
    private final ScreenHandlerBuilder parent;
    private final int rangeStart;

    BlockEntityScreenHandlerBuilder(ScreenHandlerBuilder parent, class_2586 blockEntity) {
        if (!(blockEntity instanceof class_1263)) {
            throw new RuntimeException(blockEntity.getClass().getName() + " is not an inventory");
        }
        this.inventory = (class_1263)blockEntity;
        this.blockEntity = blockEntity;
        this.parent = parent;
        this.rangeStart = parent.slots.size();
        if (this.inventory instanceof IUpgradeable) {
            this.upgradeSlots((IUpgradeable)this.inventory);
        }
        if (blockEntity instanceof MachineBaseBlockEntity) {
            MachineBaseBlockEntity machineBaseBlockEntity = (MachineBaseBlockEntity)blockEntity;
            this.sync(RedstoneConfiguration.PACKET_CODEC, machineBaseBlockEntity::getRedstoneConfiguration, machineBaseBlockEntity::setRedstoneConfiguration);
        }
    }

    public BlockEntityScreenHandlerBuilder slot(int index, int x, int y) {
        this.parent.slots.add(new BaseSlot(this.inventory, index, x, y));
        return this;
    }

    public BlockEntityScreenHandlerBuilder slot(int index, int x, int y, Predicate<class_1799> filter) {
        this.parent.slots.add(new BaseSlot(this.inventory, index, x, y, filter));
        return this;
    }

    public BlockEntityScreenHandlerBuilder outputSlot(int index, int x, int y) {
        this.parent.slots.add(new SlotOutput(this.inventory, index, x, y));
        return this;
    }

    public BlockEntityScreenHandlerBuilder fakeSlot(int index, int x, int y) {
        this.parent.slots.add(new SlotFake(this.inventory, index, x, y, false, false, Integer.MAX_VALUE));
        return this;
    }

    public BlockEntityScreenHandlerBuilder filterSlot(int index, int x, int y, Predicate<class_1799> filter) {
        this.parent.slots.add(new FilteredSlot(this.inventory, index, x, y).setFilter(filter));
        return this;
    }

    public BlockEntityScreenHandlerBuilder energySlot(int index, int x, int y) {
        this.parent.slots.add(new FilteredSlot(this.inventory, index, x, y).setFilter(EnergyStorageUtil::isEnergyStorage));
        return this;
    }

    public BlockEntityScreenHandlerBuilder fluidSlot(int index, int x, int y) {
        this.parent.slots.add(new FilteredSlot(this.inventory, index, x, y).setFilter(FluidUtils::isContainer));
        return this;
    }

    public BlockEntityScreenHandlerBuilder fuelSlot(int index, int x, int y) {
        this.parent.slots.add(new FilteredSlot(this.inventory, index, x, y).setFilter(class_2609::method_11195));
        return this;
    }

    @Deprecated
    public BlockEntityScreenHandlerBuilder upgradeSlot(int index, int x, int y) {
        this.parent.slots.add(new FilteredSlot(this.inventory, index, x, y).setFilter(stack -> stack.method_7909() instanceof IUpgrade));
        return this;
    }

    private BlockEntityScreenHandlerBuilder upgradeSlots(IUpgradeable upgradeable) {
        if (upgradeable.canBeUpgraded()) {
            for (int i = 0; i < upgradeable.getUpgradeSlotCount(); ++i) {
                this.parent.slots.add(new UpgradeSlot(upgradeable.getUpgradeInventory(), i, -18, i * 18 + 12));
            }
        }
        return this;
    }

    public <T> BlockEntityScreenHandlerBuilder sync(class_9139<? super class_9129, T> codec, Supplier<T> supplier, Consumer<T> setter) {
        this.parent.objectValues.add(new SyncedObject<T>(codec, supplier, setter));
        return this;
    }

    public BlockEntityScreenHandlerBuilder sync(Syncable syncable) {
        syncable.configureSync(this::sync);
        return this;
    }

    public <T> BlockEntityScreenHandlerBuilder sync(Codec<T> codec) {
        return this.sync(class_9135.field_48556, () -> {
            DataResult dataResult = codec.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.blockEntity);
            if (dataResult.error().isPresent()) {
                throw new RuntimeException("Failed to encode: " + ((DataResult.Error)dataResult.error().get()).message() + " " + String.valueOf(this.blockEntity));
            }
            return (class_2487)dataResult.result().get();
        }, compoundTag -> {
            DataResult dataResult = codec.parse((DynamicOps)class_2509.field_11560, compoundTag);
            if (dataResult.error().isPresent()) {
                throw new RuntimeException("Failed to encode: " + ((DataResult.Error)dataResult.error().get()).message() + " " + String.valueOf(this.blockEntity));
            }
        });
    }

    public BlockEntityScreenHandlerBuilder syncEnergyValue() {
        class_2586 class_25862 = this.blockEntity;
        if (class_25862 instanceof PowerAcceptorBlockEntity) {
            PowerAcceptorBlockEntity powerAcceptor = (PowerAcceptorBlockEntity)class_25862;
            return this.sync(class_9135.field_48551, powerAcceptor::getEnergy, powerAcceptor::setEnergy).sync(class_9135.field_48551, powerAcceptor::getExtraPowerStorage, powerAcceptor::setExtraPowerStorage).sync(class_9135.field_48551, powerAcceptor::getPowerChange, powerAcceptor::setPowerChange);
        }
        RebornCore.LOGGER.error(String.valueOf(this.inventory) + " is not an instance of TilePowerAcceptor! Energy cannot be synced.");
        return this;
    }

    public BlockEntityScreenHandlerBuilder syncCrafterValue() {
        class_2586 class_25862 = this.blockEntity;
        if (class_25862 instanceof IRecipeCrafterProvider) {
            IRecipeCrafterProvider recipeCrafter = (IRecipeCrafterProvider)class_25862;
            return this.sync(class_9135.field_49675, () -> recipeCrafter.getRecipeCrafter().currentTickTime, time -> {
                recipeCrafter.getRecipeCrafter().currentTickTime = time;
            }).sync(class_9135.field_49675, () -> recipeCrafter.getRecipeCrafter().currentNeededTicks, ticks -> {
                recipeCrafter.getRecipeCrafter().currentNeededTicks = ticks;
            });
        }
        RebornCore.LOGGER.error(String.valueOf(this.inventory) + " is not an instance of IRecipeCrafterProvider! Craft progress cannot be synced.");
        return this;
    }

    public BlockEntityScreenHandlerBuilder onCraft(Consumer<class_1715> onCraft) {
        this.parent.craftEvents.add(onCraft);
        return this;
    }

    public ScreenHandlerBuilder addInventory() {
        this.parent.blockEntityInventoryRanges.add((Range<Integer>)Range.between((Comparable)Integer.valueOf(this.rangeStart), (Comparable)Integer.valueOf(this.parent.slots.size() - 1)));
        return this.parent;
    }
}

