/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.util;

public class Color {
    public static final Color WHITE = new Color(255, 255, 255);
    public static final Color RED = new Color(255, 0, 0);
    public static final Color GREEN = new Color(0, 255, 0);
    public static final Color DARK_GREEN = new Color(0, 128, 0);
    public static final Color BLUE = new Color(0, 0, 255);
    private final int color;

    public Color(int r, int g, int b, int a) {
        this.color = (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public Color(int r, int g, int b) {
        this(r, g, b, 255);
    }

    public Color(float r, float g, float b) {
        this((int)((double)(r * 255.0f) + 0.5), (int)((double)(g * 255.0f) + 0.5), (int)((double)(b * 255.0f) + 0.5));
    }

    public int getColor() {
        return this.color;
    }

    public int getRed() {
        return this.getColor() >> 16 & 0xFF;
    }

    public int getGreen() {
        return this.getColor() >> 8 & 0xFF;
    }

    public int getBlue() {
        return this.getColor() & 0xFF;
    }

    public int getAlpha() {
        return this.getColor() >> 24 & 0xFF;
    }

    public Color darker() {
        double amount = 0.7;
        return new Color((int)((double)this.getRed() * amount), (int)((double)this.getGreen() * amount), (int)((double)this.getBlue() * amount), this.getAlpha());
    }
}

