/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.util;

import java.util.List;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.item.PlayerInventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_3545;
import net.minecraft.class_9288;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import reborncore.common.powerSystem.RcEnergyItem;
import reborncore.common.recipes.IRecipeInput;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.EnergyStorageUtil;

public class ItemUtils {
    public static boolean isItemEqual(class_1799 a, class_1799 b, boolean matchComponent, boolean useTags) {
        if (a.method_7960() && b.method_7960()) {
            return true;
        }
        if (a.method_7960() || b.method_7960()) {
            return false;
        }
        if (matchComponent && class_1799.method_31577((class_1799)a, (class_1799)b)) {
            return true;
        }
        if (useTags) {
            // empty if block
        }
        return false;
    }

    public static boolean canExtractAnyFromShulker(class_1799 shulkerStack, class_1799 targetStack) {
        class_2371<class_1799> stacks = ItemUtils.getBlockEntityStacks(shulkerStack);
        for (class_1799 stack : stacks) {
            if (!class_1799.method_31577((class_1799)targetStack, (class_1799)stack)) continue;
            return true;
        }
        return false;
    }

    public static int canExtractFromCachedShulker(List<class_1799> stacks, class_1799 targetStack) {
        if (stacks == null) {
            return 0;
        }
        int defaultValue = 0;
        for (class_1799 stack : stacks) {
            if (!class_1799.method_31577((class_1799)targetStack, (class_1799)stack)) continue;
            defaultValue += stack.method_7947();
        }
        return defaultValue;
    }

    public static boolean isStackListEmpty(List<class_1799> stacks) {
        for (class_1799 stack : stacks) {
            if (stack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public static int extractableFromCachedShulker(List<class_1799> stacks, class_1799 targetStack, int maxAmount) {
        int extracted = 0;
        for (class_1799 stack : stacks) {
            if (stack.method_7960()) continue;
            if (class_1799.method_31577((class_1799)targetStack, (class_1799)stack)) {
                int count = stack.method_7947();
                int toExtract = Math.min(maxAmount, count);
                stack.method_7934(toExtract);
                maxAmount -= toExtract;
                extracted += toExtract;
            }
            if (maxAmount == 0) break;
            if (maxAmount < 0) {
                throw new AssertionError((Object)"Extracted more than required amount!");
            }
        }
        return extracted;
    }

    public static class_3545<Integer, class_1799> extractFromShulker(class_1799 shulkerStack, class_2371<class_1799> entityStack, class_1799 targetStack, int capacity) {
        class_1799 newStack = shulkerStack.method_7972();
        if (entityStack == null) {
            return new class_3545((Object)0, (Object)shulkerStack);
        }
        int extracted = ItemUtils.extractableFromCachedShulker(entityStack, targetStack, capacity);
        if (extracted == 0) {
            return new class_3545((Object)0, (Object)shulkerStack);
        }
        if (ItemUtils.isStackListEmpty(entityStack)) {
            newStack.method_57379(class_9334.field_49622, (Object)class_9288.field_49334);
            return new class_3545((Object)extracted, (Object)newStack);
        }
        newStack.method_57379(class_9334.field_49622, (Object)class_9288.method_57493(entityStack));
        return new class_3545((Object)extracted, (Object)newStack);
    }

    public static class_2371<class_1799> getBlockEntityStacks(class_1799 targetStack) {
        int maxSize = 128;
        class_2371 returnStacks = class_2371.method_10213((int)maxSize, (Object)class_1799.field_8037);
        ((class_9288)targetStack.method_57825(class_9334.field_49622, (Object)class_9288.field_49334)).method_57492(returnStacks);
        return returnStacks;
    }

    public static boolean isEqualIgnoreEnergy(class_1799 stack1, class_1799 stack2) {
        if (stack1 == stack2) {
            return true;
        }
        if (stack1.method_7947() != stack2.method_7947()) {
            return false;
        }
        if (class_1799.method_31577((class_1799)stack1, (class_1799)stack2)) {
            return true;
        }
        if (stack1.method_57353() == class_9323.field_49584 || stack2.method_57353() == class_9323.field_49584) {
            return false;
        }
        class_1799 stack1Copy = stack1.method_7972();
        stack1Copy.method_57381(EnergyStorage.ENERGY_COMPONENT);
        class_1799 stack2Copy = stack2.method_7972();
        stack2Copy.method_57381(EnergyStorage.ENERGY_COMPONENT);
        return class_1799.method_31577((class_1799)stack1Copy, (class_1799)stack2Copy);
    }

    public static boolean isInputEqual(Object input, class_1799 other, boolean matchNBT, boolean useTags) {
        if (input instanceof class_1799) {
            return ItemUtils.isItemEqual((class_1799)input, other, matchNBT, useTags);
        }
        if (!(input instanceof String) && input instanceof IRecipeInput) {
            List<class_1799> inputs = ((IRecipeInput)input).getAllStacks();
            for (class_1799 stack : inputs) {
                if (!ItemUtils.isItemEqual(stack, other, matchNBT, false)) continue;
                return true;
            }
        }
        return false;
    }

    public static int getPowerForDurabilityBar(class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof RcEnergyItem)) {
            throw new UnsupportedOperationException();
        }
        RcEnergyItem energyItem = (RcEnergyItem)class_17922;
        return Math.round((float)energyItem.getStoredEnergy(stack) * 100.0f / (float)energyItem.getEnergyCapacity(stack) * 13.0f) / 100;
    }

    public static int getColorForDurabilityBar(class_1799 stack) {
        return 16744454;
    }

    public static void distributePowerToInventory(class_1657 player, class_1799 itemStack, long maxOutput) {
        ItemUtils.distributePowerToInventory(player, itemStack, maxOutput, stack -> true);
    }

    public static void distributePowerToInventory(class_1657 player, class_1799 itemStack, long maxOutput, Predicate<class_1799> filter) {
        PlayerInventoryStorage playerInv = PlayerInventoryStorage.of((class_1657)player);
        SingleSlotStorage sourceSlot = null;
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            if (player.method_31548().method_5438(i) != itemStack) continue;
            sourceSlot = (SingleSlotStorage)playerInv.getSlots().get(i);
            break;
        }
        if (sourceSlot == null) {
            throw new IllegalArgumentException("Failed to locate current stack in the player inventory.");
        }
        EnergyStorage sourceStorage = (EnergyStorage)ContainerItemContext.ofPlayerSlot((class_1657)player, sourceSlot).find(EnergyStorage.ITEM);
        if (sourceStorage == null) {
            return;
        }
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1799 invStack = player.method_31548().method_5438(i);
            if (invStack.method_7960() || !filter.test(invStack)) continue;
            EnergyStorageUtil.move((EnergyStorage)sourceStorage, (EnergyStorage)((EnergyStorage)ContainerItemContext.ofPlayerSlot((class_1657)player, (SingleSlotStorage)((SingleSlotStorage)playerInv.getSlots().get(i))).find(EnergyStorage.ITEM)), (long)maxOutput, null);
        }
    }
}

