/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main.entitydata;

import com.wildfire.main.WildfireHelper;
import com.wildfire.main.config.Configuration;
import com.wildfire.main.entitydata.PlayerConfig;
import net.minecraft.class_1657;
import net.minecraft.class_1664;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_9279;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public record BreastDataComponent(float breastSize, float cleavage, Vector3f offsets, boolean jacket, @Nullable class_9279 nbtComponent) {
    @Nullable
    public static BreastDataComponent fromPlayer(@NotNull class_1657 player, @NotNull PlayerConfig config) {
        if (!config.getGender().canHaveBreasts() || !config.showBreastsInArmor()) {
            return null;
        }
        return new BreastDataComponent(config.getBustSize(), config.getBreasts().getCleavage(), config.getBreasts().getOffsets(), player.method_7348(class_1664.field_7564), null);
    }

    @Nullable
    public static BreastDataComponent fromComponent(@Nullable class_9279 component) {
        if (component == null) {
            return null;
        }
        class_2487 root = component.method_57463();
        if (!root.method_10573("WildfireGender", 10)) {
            return null;
        }
        class_2487 nbt = root.method_10562("WildfireGender");
        float breastSize = WildfireHelper.readNbt(nbt, "BreastSize", Configuration.BUST_SIZE).orElse(Float.valueOf(0.0f)).floatValue();
        float cleavage = WildfireHelper.readNbt(nbt, "Cleavage", Configuration.BREASTS_CLEAVAGE).orElseGet(Configuration.BREASTS_CLEAVAGE::getDefault).floatValue();
        boolean jacket = WildfireHelper.readNbt(nbt, "Jacket", arg_0 -> ((class_2487)nbt).method_10577(arg_0)).orElse(true);
        Vector3f offsets = new Vector3f(WildfireHelper.readNbt(nbt, "XOffset", Configuration.BREASTS_OFFSET_X).orElse(Float.valueOf(0.0f)).floatValue(), WildfireHelper.readNbt(nbt, "YOffset", Configuration.BREASTS_OFFSET_Y).orElse(Float.valueOf(0.0f)).floatValue(), WildfireHelper.readNbt(nbt, "ZOffset", Configuration.BREASTS_OFFSET_Z).orElse(Float.valueOf(0.0f)).floatValue());
        return new BreastDataComponent(breastSize, cleavage, offsets, jacket, component);
    }

    public void write(class_1799 stack) {
        if (stack.method_7960()) {
            throw new IllegalArgumentException("The provided ItemStack must not be empty");
        }
        class_2487 nbt = new class_2487();
        nbt.method_10548("BreastSize", this.breastSize);
        nbt.method_10548("Cleavage", this.cleavage);
        nbt.method_10548("XOffset", this.offsets.x);
        nbt.method_10548("YOffset", this.offsets.y);
        nbt.method_10548("ZOffset", this.offsets.z);
        nbt.method_10556("Jacket", this.jacket);
        class_9279.method_57452((class_9331)class_9334.field_49628, (class_1799)stack, stackNbt -> stackNbt.method_10566("WildfireGender", (class_2520)nbt));
    }
}

