/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.physics;

import com.wildfire.api.IGenderArmor;
import com.wildfire.main.WildfireHelper;
import com.wildfire.main.entitydata.EntityConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1428;
import net.minecraft.class_1452;
import net.minecraft.class_1496;
import net.minecraft.class_1498;
import net.minecraft.class_1531;
import net.minecraft.class_1690;
import net.minecraft.class_1695;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_4985;
import net.minecraft.class_7689;

public class BreastPhysics {
    private float bounceVelX = 0.0f;
    private float targetBounceX = 0.0f;
    private float velocityX = 0.0f;
    private float positionX;
    private float prePositionX;
    private float bounceVel = 0.0f;
    private float targetBounceY = 0.0f;
    private float velocity = 0.0f;
    private float positionY;
    private float prePositionY;
    private float bounceRotVel = 0.0f;
    private float targetRotVel = 0.0f;
    private float rotVelocity = 0.0f;
    private float wfg_bounceRotation;
    private float wfg_preBounceRotation;
    private float breastSize = 0.0f;
    private float preBreastSize = 0.0f;
    private class_4050 lastPose;
    private int lastSwingDuration = 6;
    private int lastSwingTick = 0;
    private class_243 prePos;
    private final EntityConfig entityConfig;
    private int randomB = 1;
    private boolean alreadyFalling = false;

    public BreastPhysics(EntityConfig entityConfig) {
        this.entityConfig = entityConfig;
    }

    private static boolean vehicleSuppressesRotation(class_1297 vehicle) {
        class_7689 camel;
        class_1496 horseLike;
        return vehicle instanceof class_1428 || vehicle instanceof class_1496 && !(horseLike = (class_1496)vehicle).method_6725() || vehicle instanceof class_7689 && (camel = (class_7689)vehicle).method_45357();
    }

    private static boolean shouldUseVehicleYaw(class_1309 rider, class_1297 vehicle) {
        return vehicle.method_42148() || vehicle instanceof class_1690 || vehicle.method_43078() == rider.method_43078();
    }

    private static float calcRotation(class_1309 entity, float bounceIntensity) {
        class_1297 vehicle = entity.method_5854();
        if (vehicle != null) {
            if (BreastPhysics.vehicleSuppressesRotation(vehicle)) {
                return 0.0f;
            }
            if (BreastPhysics.shouldUseVehicleYaw(entity, vehicle)) {
                if (vehicle instanceof class_1309) {
                    class_1309 livingVehicle = (class_1309)vehicle;
                    return -((livingVehicle.field_6283 - livingVehicle.field_6220) / 15.0f) * bounceIntensity;
                }
                return -((vehicle.method_36454() - vehicle.field_5982) / 15.0f) * bounceIntensity;
            }
        }
        return -((entity.field_6283 - entity.field_6220) / 15.0f) * bounceIntensity;
    }

    @Environment(value=EnvType.CLIENT)
    public void update(class_1309 entity, IGenderArmor armor) {
        int swingDuration;
        if (entity instanceof class_1531) {
            if (this.entityConfig.getGender().canHaveBreasts()) {
                this.breastSize = this.entityConfig.getBustSize();
                if (!this.entityConfig.getArmorPhysicsOverride()) {
                    float tightness = class_3532.method_15363((float)armor.tightness(), (float)0.0f, (float)1.0f);
                    this.breastSize *= 1.0f - 0.15f * tightness;
                }
                this.preBreastSize = this.breastSize;
            } else {
                this.breastSize = 0.0f;
            }
            return;
        }
        this.prePositionY = this.positionY;
        this.prePositionX = this.positionX;
        this.wfg_preBounceRotation = this.wfg_bounceRotation;
        this.preBreastSize = this.breastSize;
        if (this.prePos == null) {
            this.prePos = entity.method_19538();
            return;
        }
        float breastWeight = this.entityConfig.getBustSize() * 1.25f;
        float targetBreastSize = this.entityConfig.getBustSize();
        if (!this.entityConfig.getGender().canHaveBreasts()) {
            targetBreastSize = 0.0f;
        } else {
            float tightness = class_3532.method_15363((float)armor.tightness(), (float)0.0f, (float)1.0f);
            if (this.entityConfig.getArmorPhysicsOverride()) {
                tightness = 0.0f;
            }
            targetBreastSize *= 1.0f - 0.15f * tightness;
        }
        this.breastSize += this.breastSize < targetBreastSize ? Math.abs(this.breastSize - targetBreastSize) / 2.0f : -Math.abs(this.breastSize - targetBreastSize) / 2.0f;
        class_243 motion = entity.method_19538().method_1020(this.prePos);
        this.prePos = entity.method_19538();
        float bounceIntensity = targetBreastSize * 3.0f * (float)Math.round(this.entityConfig.getBounceMultiplier() * 3.0f * 100.0f) / 100.0f;
        float resistance = class_3532.method_15363((float)armor.physicsResistance(), (float)0.0f, (float)1.0f);
        if (this.entityConfig.getArmorPhysicsOverride()) {
            resistance = 0.0f;
        }
        bounceIntensity *= 1.0f - resistance;
        if (!this.entityConfig.getBreasts().isUniboob()) {
            bounceIntensity *= WildfireHelper.randFloat(0.5f, 1.5f);
        }
        if (entity.field_6017 > 0.0f && !this.alreadyFalling) {
            this.randomB = entity.method_37908().field_9229.method_43056() ? -1 : 1;
            this.alreadyFalling = true;
        }
        if (entity.field_6017 == 0.0f) {
            this.alreadyFalling = false;
        }
        this.targetBounceY = (float)motion.field_1351 * bounceIntensity;
        this.targetBounceY += breastWeight;
        float horizVel = (float)Math.sqrt(Math.pow(motion.field_1352, 2.0) + Math.pow(motion.field_1350, 2.0)) * bounceIntensity;
        this.targetRotVel = BreastPhysics.calcRotation(entity, bounceIntensity);
        this.targetRotVel += (float)motion.field_1351 * bounceIntensity * (float)this.randomB;
        float f2 = (float)entity.method_18798().method_1027() / 0.2f;
        if ((f2 = f2 * f2 * f2) < 1.0f) {
            f2 = 1.0f;
        }
        this.targetBounceY += class_3532.method_15362((float)(entity.field_42108.method_48569() * 0.6662f + (float)Math.PI)) * 0.5f * entity.field_42108.method_48566() * 0.5f / f2;
        class_4050 pose = entity.method_18376();
        if (pose != this.lastPose) {
            if (pose == class_4050.field_18081 || this.lastPose == class_4050.field_18081) {
                this.targetBounceY += bounceIntensity;
            } else if (pose == class_4050.field_18078 || this.lastPose == class_4050.field_18078) {
                this.targetBounceY = bounceIntensity;
            }
            this.lastPose = pose;
        }
        if (entity.method_5854() != null) {
            class_1297 class_12972 = entity.method_5854();
            if (class_12972 instanceof class_1690) {
                class_1690 boat = (class_1690)class_12972;
                int rowTime = (int)boat.method_7551(0, entity.field_42108.method_48569());
                int rowTime2 = (int)boat.method_7551(1, entity.field_42108.method_48569());
                float rotationL = (float)class_3532.method_15390((double)-1.0471975803375244, (double)-0.2617993950843811, (double)((class_3532.method_15374((float)(-rowTime2)) + 1.0f) / 2.0f));
                float rotationR = (float)class_3532.method_15390((double)-0.7853981852531433, (double)0.7853981852531433, (double)((class_3532.method_15374((float)((float)(-rowTime) + 1.0f)) + 1.0f) / 2.0f));
                if (rotationL < -1.0f || rotationR < -0.6f) {
                    this.targetBounceY = bounceIntensity / 3.25f;
                }
            } else {
                class_1297 rowTime = entity.method_5854();
                if (rowTime instanceof class_1695) {
                    class_1695 cart = (class_1695)rowTime;
                    float speed = (float)cart.method_18798().method_1027();
                    if (Math.random() * (double)speed < 0.5 && speed > 0.2f) {
                        this.targetBounceY = (Math.random() > 0.5 ? -bounceIntensity : bounceIntensity) / 6.0f;
                        this.targetBounceY += breastWeight;
                    }
                } else {
                    class_1297 speed = entity.method_5854();
                    if (speed instanceof class_1498) {
                        class_1498 horse = (class_1498)speed;
                        float movement = (float)horse.method_18798().method_1027();
                        if (horse.field_6012 % this.clampMovement(movement) == 5 && movement > 0.05f) {
                            this.targetBounceY = bounceIntensity / 4.0f;
                            this.targetBounceY += breastWeight;
                        }
                    } else {
                        class_1297 movement = entity.method_5854();
                        if (movement instanceof class_1452) {
                            class_1452 pig = (class_1452)movement;
                            float movement2 = (float)pig.method_18798().method_1027();
                            if (pig.field_6012 % this.clampMovement(movement2) == 5 && movement2 > 0.002f) {
                                this.targetBounceY = bounceIntensity * class_3532.method_15363((float)(movement2 * 75.0f), (float)0.1f, (float)1.0f) / 4.0f;
                                this.targetBounceY += breastWeight;
                            }
                        } else {
                            movement = entity.method_5854();
                            if (movement instanceof class_4985) {
                                class_4985 strider = (class_4985)movement;
                                double heightOffset = (double)strider.method_17682() - 0.19 + (double)(0.12f * class_3532.method_15362((float)(strider.field_42108.method_48569() * 1.5f)) * 2.0f * Math.min(0.25f, strider.field_42108.method_48566()));
                                this.targetBounceY += ((float)(heightOffset * 3.0) - 4.5f) * bounceIntensity;
                            }
                        }
                    }
                }
            }
        }
        if (((swingDuration = entity.method_6028()) > 1 || this.lastSwingDuration > 1) && pose != class_4050.field_18078) {
            class_1306 swingingArm;
            float amplifier = 0.0f;
            if (swingDuration < 6) {
                amplifier = 0.15f * (float)(6 - swingDuration);
            } else if (swingDuration > 6) {
                amplifier = -0.067f * (float)(swingDuration - 6);
            }
            amplifier = class_3532.method_15363((float)(1.0f + amplifier), (float)0.6f, (float)1.3f);
            int everyNthTick = class_3532.method_15340((int)(swingDuration - 1), (int)1, (int)5);
            if (entity.field_6252 && entity.field_6012 % everyNthTick == 0) {
                float hasteMult = class_3532.method_15363((float)((float)everyNthTick / 5.0f), (float)0.4f, (float)1.0f);
                this.targetBounceY += (Math.random() > 0.5 ? -0.25f : 0.25f) * amplifier * bounceIntensity * hasteMult;
            }
            int swingTickDelta = entity.field_6279 - this.lastSwingTick;
            float swingProgress = BreastPhysics.distanceFromMedian(0, this.lastSwingDuration, class_3532.method_15340((int)this.lastSwingTick, (int)0, (int)this.lastSwingDuration));
            class_1306 class_13062 = swingingArm = entity.field_6266 == class_1268.field_5808 ? entity.method_6068() : entity.method_6068().method_5928();
            if (swingTickDelta < 0 && this.lastSwingTick != this.lastSwingDuration - 1) {
                this.targetRotVel += (swingingArm == class_1306.field_6183 ? -2.5f : 2.5f) * Math.abs(swingProgress) * bounceIntensity;
            } else if (entity.field_6252 && swingDuration > 1) {
                class_1306 swingingToward = swingProgress > 0.0f ? swingingArm.method_5928() : swingingArm;
                this.targetRotVel += (swingingToward == class_1306.field_6183 ? -0.2f : 0.2f) * amplifier * bounceIntensity;
            }
            this.lastSwingTick = entity.field_6279;
        }
        if (!entity.field_6252) {
            this.lastSwingTick = 0;
        }
        this.lastSwingDuration = Math.max(swingDuration, 1);
        float percent = this.entityConfig.getFloppiness();
        float bounceAmount = 0.45f * (1.0f - percent) + 0.15f;
        bounceAmount = class_3532.method_15363((float)bounceAmount, (float)0.15f, (float)0.6f);
        float delta = 2.25f - bounceAmount;
        float distanceFromMin = Math.abs(this.bounceVel + 1.5f) * 0.5f;
        float distanceFromMax = Math.abs(this.bounceVel - 2.65f) * 0.5f;
        if (this.bounceVel < -0.5f) {
            this.targetBounceY += distanceFromMin;
        }
        if (this.bounceVel > 2.5f) {
            this.targetBounceY -= distanceFromMax;
        }
        this.targetBounceY = class_3532.method_15363((float)this.targetBounceY, (float)-1.5f, (float)2.5f);
        this.targetRotVel = class_3532.method_15363((float)this.targetRotVel, (float)-25.0f, (float)25.0f);
        this.velocity = class_3532.method_16439((float)bounceAmount, (float)this.velocity, (float)((this.targetBounceY - this.bounceVel) * delta));
        this.bounceVel += this.velocity * percent * 1.1625f;
        this.velocityX = class_3532.method_16439((float)bounceAmount, (float)this.velocityX, (float)((this.targetBounceX - this.bounceVelX) * delta));
        this.bounceVelX += this.velocityX * percent;
        this.rotVelocity = class_3532.method_16439((float)bounceAmount, (float)this.rotVelocity, (float)((this.targetRotVel - this.bounceRotVel) * delta));
        this.bounceRotVel += this.rotVelocity * percent;
        this.wfg_bounceRotation = this.bounceRotVel;
        this.positionX = this.bounceVelX;
        this.positionY = this.bounceVel;
        if (this.positionY < -0.5f) {
            this.positionY = -0.5f;
        }
        if (this.positionY > 1.5f) {
            this.positionY = 1.5f;
            this.velocity = 0.0f;
        }
    }

    public float getBreastSize(float partialTicks) {
        return class_3532.method_16439((float)partialTicks, (float)this.preBreastSize, (float)this.breastSize);
    }

    public float getPrePositionY() {
        return this.prePositionY;
    }

    public float getPositionY() {
        return this.positionY;
    }

    public float getPrePositionX() {
        return this.prePositionX;
    }

    public float getPositionX() {
        return this.positionX;
    }

    public float getBounceRotation() {
        return this.wfg_bounceRotation;
    }

    public float getPreBounceRotation() {
        return this.wfg_preBounceRotation;
    }

    private int clampMovement(float movement) {
        return Math.max((int)(10.0f - movement * 2.0f), 1);
    }

    private static float distanceFromMedian(int p1, int p2, float point) {
        if (p1 >= p2) {
            throw new IllegalArgumentException("p2 must be greater than p1");
        }
        if (point < (float)p1 || point > (float)p2) {
            throw new IllegalArgumentException(point + " is not within bounds of (" + p1 + ", " + p2 + ")");
        }
        if (point == (float)p1 || point == (float)p2) {
            return 0.0f;
        }
        float median = (float)(p2 - p1) / 2.0f;
        if ((point -= (float)p1) > median) {
            point = -(median - (point - median));
        }
        return point / median;
    }
}

