/*
 * Decompiled with CFR 0.152.
 */
package net.venturecraft.gliders.common.compat.trinket;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import net.venturecraft.gliders.common.compat.trinket.CuriosTrinketsSlotInv;
import net.venturecraft.gliders.common.item.GliderItem;
import net.venturecraft.gliders.util.GliderUtil;

public class CuriosTrinketsUtil {
    public static final Slot HAT = new Slot("head", "head/hat");
    public static final Slot NECKLACE = new Slot("necklace", "chest/necklace");
    public static final Slot BACK = new Slot("glider", "chest/back");
    public static final Slot BACK_NATIVE = new Slot("back", "chest/back");
    public static final Slot CAPE = new Slot("back", "chest/cape");
    public static final Slot BELT = new Slot("belt", "legs/belt");
    public static final Slot HAND = new Slot("hand", "hand/glove");
    public static final Slot OFFHAND = new Slot("hand", "offhand/glove");
    public static final Slot RING = new Slot("hand", "hand/ring");
    public static final Slot OFFHAND_RING = new Slot("ring", "offhand/ring");
    private static CuriosTrinketsUtil INSTANCE = new CuriosTrinketsUtil();

    public static CuriosTrinketsUtil getInstance() {
        return INSTANCE;
    }

    public static void setInstance(CuriosTrinketsUtil instance) {
        INSTANCE = instance;
    }

    public boolean isTrinkets() {
        return false;
    }

    public boolean isCurios() {
        return false;
    }

    public class_1799 getFirstFoundGlider(class_1309 livingEntity) {
        return this.findGliders(livingEntity, CuriosTrinketsUtil.BACK.identifier, CuriosTrinketsUtil.CAPE.identifier, CuriosTrinketsUtil.BACK_NATIVE.identifier);
    }

    public class_1799 findGliders(class_1309 entity, String ... slots) {
        if (entity.method_6118(class_1304.field_6174).method_7909() instanceof GliderItem) {
            return entity.method_6118(class_1304.field_6174);
        }
        for (String slot : slots) {
            List<class_1799> items = this.getItemsInSlot(entity, slot);
            for (class_1799 item : items) {
                class_1792 class_17922 = item.method_7909();
                if (!(class_17922 instanceof GliderItem)) continue;
                GliderItem gliderItem = (GliderItem)class_17922;
                return item;
            }
        }
        return class_1799.field_8037;
    }

    public List<class_1799> getItemsInSlot(class_1309 entity, String slot) {
        CuriosTrinketsSlotInv inv = this.getSlot(entity, slot);
        ArrayList<class_1799> items = new ArrayList<class_1799>();
        for (int i = 0; i < inv.getSlots(); ++i) {
            class_1799 stack = inv.getStackInSlot(i);
            if (stack.method_7960()) continue;
            items.add(stack);
        }
        return items;
    }

    public CuriosTrinketsSlotInv getSlot(class_1309 entity, String slot) {
        return CuriosTrinketsSlotInv.EMPTY;
    }

    public CuriosTrinketsSlotInv getSlot(class_1309 entity, Slot slot) {
        return this.getSlot(entity, (GliderUtil.isNeoForge() ? slot.getForge() : slot.getFabric()).comp_327().method_12832());
    }

    public static class Slot {
        private final class_6862<class_1792> forge;
        private final class_6862<class_1792> fabric;
        private final String identifier;

        public Slot(String forge, String fabric) {
            this.forge = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_12829((String)("curios:" + forge)));
            this.fabric = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_12829((String)("trinkets:" + fabric)));
            this.identifier = GliderUtil.isNeoForge() ? forge : fabric;
        }

        public String identifier() {
            return this.identifier;
        }

        public class_6862<class_1792> getFabric() {
            return this.fabric;
        }

        public class_6862<class_1792> getForge() {
            return this.forge;
        }
    }
}

