/*
 * Decompiled with CFR 0.152.
 */
package net.venturecraft.gliders.common.item;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2315;
import net.minecraft.class_2357;
import net.minecraft.class_2561;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5151;
import net.minecraft.class_6880;
import net.minecraft.class_9323;
import net.venturecraft.gliders.common.item.ItemComponentRegistry;
import net.venturecraft.gliders.util.ModConstants;

public class GliderItem
extends class_1792
implements class_5151 {
    private final Supplier<class_1799> repair;

    public GliderItem(class_1792.class_1793 itemProperties, Supplier<class_1799> stackSupplier) {
        super(itemProperties);
        this.repair = stackSupplier;
        class_2315.method_10009((class_1935)this, (class_2357)class_1738.field_7879);
    }

    public static boolean isSpaceGlider(class_1799 stack) {
        return stack.method_7954().getString().contains("xwing");
    }

    public static class_1799 setCopper(class_1799 itemStack, boolean copper) {
        itemStack.method_57379(ItemComponentRegistry.COPPER_UPGRADE.get(), (Object)copper);
        return itemStack;
    }

    public static boolean hasCopperUpgrade(class_1799 itemStack) {
        class_9323 compound = itemStack.method_57353();
        if (!compound.method_57832(ItemComponentRegistry.COPPER_UPGRADE.get())) {
            return false;
        }
        return (Boolean)compound.method_57829(ItemComponentRegistry.COPPER_UPGRADE.get());
    }

    public static class_1799 setNether(class_1799 itemStack, boolean copper) {
        itemStack.method_57379(ItemComponentRegistry.NETHER_UPGRADE.get(), (Object)copper);
        return itemStack;
    }

    public static boolean hasNetherUpgrade(class_1799 itemStack) {
        class_9323 compound = itemStack.method_57353();
        if (!compound.method_57832(ItemComponentRegistry.NETHER_UPGRADE.get())) {
            return false;
        }
        return (Boolean)compound.method_57829(ItemComponentRegistry.NETHER_UPGRADE.get());
    }

    public static boolean isGlidingEnabled(class_1799 itemStack) {
        class_9323 compound = itemStack.method_57353();
        if (!compound.method_57832(ItemComponentRegistry.GLIDE.get())) {
            return false;
        }
        return (Boolean)compound.method_57829(ItemComponentRegistry.GLIDE.get()) != false && !GliderItem.isBroken(itemStack);
    }

    public static boolean isTooBroken(class_1799 itemStack) {
        return itemStack.method_7919() >= itemStack.method_7936() - 1;
    }

    public static void setGlide(class_1799 itemStack, boolean canGlide) {
        itemStack.method_57379(ItemComponentRegistry.GLIDE.get(), (Object)canGlide);
    }

    public static void setBroken(class_1799 itemStack, boolean broken) {
        itemStack.method_57379(ItemComponentRegistry.BROKEN.get(), (Object)broken);
    }

    public static boolean isBroken(class_1799 itemStack) {
        class_9323 compound = itemStack.method_57353();
        if (!compound.method_57832(ItemComponentRegistry.BROKEN.get())) {
            return false;
        }
        return (Boolean)compound.method_57829(ItemComponentRegistry.BROKEN.get());
    }

    public static void setStruck(class_1799 itemStack, boolean isStruck) {
        itemStack.method_57379(ItemComponentRegistry.STRUCK.get(), (Object)isStruck);
    }

    public static boolean hasBeenStruck(class_1799 itemStack) {
        class_9323 compound = itemStack.method_57353();
        if (!compound.method_57832(ItemComponentRegistry.STRUCK.get())) {
            return false;
        }
        return (Boolean)compound.method_57829(ItemComponentRegistry.STRUCK.get());
    }

    public boolean method_7878(class_1799 stack, class_1799 repairCandidate) {
        return repairCandidate.method_7909() == this.repair.get().method_7909();
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 tooltipFlag) {
        super.method_7851(stack, context, tooltip, tooltipFlag);
        if (GliderItem.hasCopperUpgrade(stack) || GliderItem.hasNetherUpgrade(stack)) {
            tooltip.add((class_2561)class_2561.method_43471((String)ModConstants.INSTALLED_UPGRADES));
            if (GliderItem.hasCopperUpgrade(stack)) {
                tooltip.add((class_2561)class_2561.method_43470((String)"- ").method_10852((class_2561)class_2561.method_43471((String)ModConstants.COPPER_UPGRADE)));
            }
            if (GliderItem.hasNetherUpgrade(stack)) {
                tooltip.add((class_2561)class_2561.method_43470((String)"- ").method_10852((class_2561)class_2561.method_43471((String)ModConstants.NETHER_UPGRADE)));
            }
        }
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 usedHand) {
        return this.method_48576(this, level, player, usedHand);
    }

    public class_1304 method_7685() {
        return class_1304.field_6174;
    }

    public class_6880<class_3414> method_31570() {
        return class_3417.field_14966;
    }
}

