/*
 * Decompiled with CFR 0.152.
 */
package net.venturecraft.gliders.data;

import commonnetwork.api.Network;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import net.minecraft.class_7094;
import net.venturecraft.gliders.data.fabric.GliderDataImpl;
import net.venturecraft.gliders.network.SyncGliderData;
import net.venturecraft.gliders.util.GliderUtil;

public class GliderData {
    public static class_7094 glideAnimation = new class_7094();
    public static class_7094 fallingAnimation = new class_7094();
    public static class_7094 gliderOpeningAnimation = new class_7094();

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean getIsGliding(class_1309 player) {
        return GliderDataImpl.getIsGliding(player);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static int getLightningTimer(class_1309 player) {
        return GliderDataImpl.getLightningTimer(player);
    }

    public static void tick(class_1309 livingEntity) {
        GliderData.glideAndFallLogic(livingEntity);
        GliderUtil.onTickPlayerGlide(livingEntity.method_37908(), livingEntity);
        if (!GliderUtil.isGlidingWithActiveGlider(livingEntity)) {
            GliderData.setLightningTimer(livingEntity, 0);
        }
        if (livingEntity.method_37908().field_9236) {
            return;
        }
        GliderData.setIsGliding(livingEntity, GliderUtil.isGlidingWithActiveGlider(livingEntity));
        if (livingEntity.field_6012 % 40 == 0) {
            GliderData.sync(livingEntity);
        }
    }

    private static void glideAndFallLogic(class_1309 livingEntity) {
        if (GliderData.getIsGliding(livingEntity) || GliderUtil.isGlidingWithActiveGlider(livingEntity)) {
            if (!glideAnimation.method_41327()) {
                glideAnimation.method_41322(livingEntity.field_6012);
            }
            if (!gliderOpeningAnimation.method_41327()) {
                gliderOpeningAnimation.method_41322(livingEntity.field_6012);
            }
        } else {
            glideAnimation.method_41325();
            gliderOpeningAnimation.method_41325();
        }
    }

    public static void sync(class_1309 livingEntity) {
        if (livingEntity.method_37908().field_9236) {
            throw new IllegalStateException("Don't sync client -> server");
        }
        SyncGliderData syncGliderData = new SyncGliderData(livingEntity.method_5628(), GliderData.serializeNBT());
        Network.getNetworkHandler().sendToClient((Object)syncGliderData, (class_3222)livingEntity);
    }

    public static void syncTo(class_3222 receiver) {
        if (receiver.method_37908().field_9236) {
            throw new IllegalStateException("Don't sync client -> server");
        }
        Network.getNetworkHandler().sendToClient((Object)new SyncGliderData(receiver.method_5628(), GliderData.serializeNBT()), receiver);
    }

    public static class_7094 getAnimation(AnimationStates animationStates) {
        return switch (animationStates.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> fallingAnimation;
            case 1 -> glideAnimation;
            case 2 -> gliderOpeningAnimation;
        };
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void setLightningTimer(class_1309 player, int lightningTimer) {
        void var1_1;
        GliderDataImpl.setLightningTimer(player, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void setIsGliding(class_1309 player, boolean isGliding) {
        void var1_1;
        GliderDataImpl.setIsGliding(player, (boolean)var1_1);
    }

    public static void deserializeNBT(class_1657 player, class_2487 nbt) {
        GliderData.setIsGliding((class_1309)player, nbt.method_10577("is_gliding"));
        GliderData.setLightningTimer((class_1309)player, nbt.method_10550("lightningTimer"));
    }

    public static class_2487 serializeNBT() {
        class_2487 compoundTag = new class_2487();
        return compoundTag;
    }

    public static enum AnimationStates {
        FALLING,
        GLIDING,
        GLIDER_OPENING;

    }
}

