/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide;

import com.li64.tide.config.TideConfig;
import com.li64.tide.data.TideDataLoader;
import com.li64.tide.data.TideLootTables;
import com.li64.tide.data.journal.JournalLayout;
import com.li64.tide.data.journal.config.CustomPageLoader;
import com.li64.tide.data.journal.config.CustomProfileLoader;
import com.li64.tide.data.journal.config.CustomRemovalLoader;
import com.li64.tide.data.loot.TideFishingPredicate;
import com.li64.tide.data.loot.TornNoteData;
import com.li64.tide.data.rods.AccessoryData;
import com.li64.tide.data.rods.AccessoryDataLoader;
import com.li64.tide.data.rods.BaitData;
import com.li64.tide.data.rods.BaitDataLoader;
import com.li64.tide.platform.Services;
import com.li64.tide.platform.services.TideMainPlatform;
import com.li64.tide.platform.services.TideNetworkPlatform;
import com.li64.tide.registries.TideEntityTypes;
import com.li64.tide.registries.TideItems;
import com.li64.tide.registries.items.TornNoteItem;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2048;
import net.minecraft.class_2050;
import net.minecraft.class_215;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3302;
import net.minecraft.class_47;
import net.minecraft.class_4965;
import net.minecraft.class_5341;
import net.minecraft.class_7376;
import net.minecraft.class_79;
import net.minecraft.class_83;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tide {
    public static final String MOD_ID = "tide";
    public static final String MOD_NAME = "Tide";
    public static final Logger LOG = LoggerFactory.getLogger((String)"Tide");
    public static final TideMainPlatform PLATFORM = Services.load(TideMainPlatform.class);
    public static final TideNetworkPlatform NETWORK = Services.load(TideNetworkPlatform.class);
    private static final ArrayList<TideDataLoader<?>> LOADERS = new ArrayList();
    public static TideConfig CONFIG;
    public static JournalLayout JOURNAL;
    public static TideDataLoader<BaitData> BAIT_DATA;
    public static TideDataLoader<AccessoryData> ACCESSORY_DATA;
    public static TideDataLoader<JournalLayout.Page> PAGE_DATA;
    public static TideDataLoader<JournalLayout.Profile> PROFILE_DATA;
    public static TideDataLoader<CustomRemovalLoader.Removal> REMOVAL_DATA;

    private static <T> TideDataLoader<T> registerDataLoader(TideDataLoader<T> loader) {
        LOADERS.add(loader);
        return loader;
    }

    public static void init() {
        CONFIG = (TideConfig)AutoConfig.register(TideConfig.class, Toml4jConfigSerializer::new).getConfig();
        LOG.info("Initialized Tide mod on {}", (Object)PLATFORM.getPlatformName());
    }

    public static class_2960 resource(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    public static class_1761.class_7913 getCreativeTab(class_1761.class_7913 builder) {
        return builder.method_47321((class_2561)class_2561.method_43471((String)"itemGroup.tide.main")).method_47320(() -> new class_1799((class_1935)TideItems.ANGELFISH)).method_47317(Tide::displayItems);
    }

    public static void displayItems(class_1761.class_8128 itemDisplayParameters, class_1761.class_7704 output) {
        TideItems.getCreativeModeItemList().forEach(arg_0 -> ((class_1761.class_7704)output).method_45421(arg_0));
        TornNoteData.INSTANCES.forEach(instance -> output.method_45420(TornNoteItem.create(instance)));
    }

    public static void onRegisterReloadListeners(BiConsumer<class_2960, class_3302> registry) {
        LOADERS.forEach((Consumer<TideDataLoader<?>>)((Consumer<TideDataLoader>)loader -> registry.accept(loader.getDirectory(), (class_3302)loader)));
    }

    public static class_79.class_80<?> getCrateFishingEntry() {
        return class_83.method_428(TideLootTables.Fishing.Crates.BLOCK).method_437(Tide.CONFIG.general.crateWeight).method_436(Tide.CONFIG.general.crateQuality).method_421((class_5341.class_210)class_215.method_917((class_47.class_50)class_47.class_50.field_935, (class_2048.class_2049)class_2048.class_2049.method_8916().method_43094((class_7376)class_4965.method_26095((boolean)true))).method_893(class_215.method_917((class_47.class_50)class_47.class_50.field_935, (class_2048.class_2049)class_2048.class_2049.method_8916().method_43094((class_7376)TideFishingPredicate.isLavaFishing(true)))).and(class_215.method_917((class_47.class_50)class_47.class_50.field_935, (class_2048.class_2049)class_2048.class_2049.method_8916().method_8917(class_2050.method_8929(TideEntityTypes.FISHING_BOBBER)))));
    }

    static {
        BAIT_DATA = Tide.registerDataLoader(new BaitDataLoader());
        ACCESSORY_DATA = Tide.registerDataLoader(new AccessoryDataLoader());
        PAGE_DATA = Tide.registerDataLoader(new CustomPageLoader());
        PROFILE_DATA = Tide.registerDataLoader(new CustomProfileLoader());
        REMOVAL_DATA = Tide.registerDataLoader(new CustomRemovalLoader());
    }
}

