/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.data;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.li64.tide.Tide;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import org.jetbrains.annotations.NotNull;

public abstract class TideDataLoader<T>
extends class_4309 {
    private List<T> values = new ArrayList<T>();
    private final String directory;

    public TideDataLoader(String directory) {
        super(new Gson(), directory);
        this.directory = directory;
    }

    protected abstract Codec<T> entryCodec();

    protected abstract String getDataTypeMessage();

    protected void apply(@NotNull Map<class_2960, JsonElement> map, @NotNull class_3300 manager, @NotNull class_3695 profiler) {
        ArrayList output = new ArrayList();
        for (Map.Entry<class_2960, JsonElement> entry : map.entrySet()) {
            class_2960 entryKey = entry.getKey();
            try {
                this.entryCodec().parse((DynamicOps)JsonOps.INSTANCE, (Object)entry.getValue()).result().ifPresentOrElse(value -> this.add(value, output), () -> this.postInvalidEntryMessage(entryKey));
            }
            catch (JsonParseException | IllegalArgumentException parseException) {
                Tide.LOG.error("Parsing error during tide data loading for entry " + String.valueOf(entryKey), parseException);
            }
        }
        this.values = ImmutableList.copyOf(output);
        if (!this.values.isEmpty()) {
            Tide.LOG.info("Loaded {} {}", (Object)this.values.size(), (Object)this.getDataTypeMessage());
        }
    }

    protected void postInvalidEntryMessage(class_2960 entryKey) {
        Tide.LOG.warn("Skipped loading invalid data entry {}", (Object)entryKey);
    }

    protected void add(T value, ArrayList<T> list) {
        list.add(value);
    }

    public List<T> get() {
        return this.values;
    }

    public void set(List<T> values) {
        this.values = new ArrayList<T>(values);
    }

    public class_2960 getDirectory() {
        return Tide.resource(this.directory);
    }
}

