/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.data.loot;

import com.li64.tide.data.loot.DepthLayer;
import com.li64.tide.registries.TideEntitySubPredicates;
import com.li64.tide.registries.entities.misc.fishing.TideFishingHook;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_7376;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record TideFishingPredicate(Optional<Boolean> isLavaFishing, Optional<Boolean> usingMagneticBait, Optional<String> depthLayer) implements class_7376
{
    public static final MapCodec<TideFishingPredicate> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("is_lava_fishing").forGetter(TideFishingPredicate::isLavaFishing), (App)Codec.BOOL.optionalFieldOf("using_magnetic_bait").forGetter(TideFishingPredicate::usingMagneticBait), (App)Codec.STRING.optionalFieldOf("loot_layer").forGetter(TideFishingPredicate::depthLayer)).apply((Applicative)instance, TideFishingPredicate::new));

    public static TideFishingPredicate isLavaFishing(boolean lavaFishing) {
        return new TideFishingPredicate(Optional.of(lavaFishing), Optional.empty(), Optional.empty());
    }

    public static TideFishingPredicate usingMagneticBait(boolean magneticBait) {
        return new TideFishingPredicate(Optional.empty(), Optional.of(magneticBait), Optional.empty());
    }

    public static TideFishingPredicate depthLayer(DepthLayer layer) {
        return new TideFishingPredicate(Optional.empty(), Optional.empty(), Optional.of(layer.key));
    }

    @NotNull
    public MapCodec<TideFishingPredicate> method_58152() {
        return TideEntitySubPredicates.TIDE_FISHING_HOOK;
    }

    public boolean method_22497(@NotNull class_1297 entity, @NotNull class_3218 level, @Nullable class_243 position) {
        if (entity instanceof TideFishingHook) {
            Optional<DepthLayer> layer;
            TideFishingHook hook = (TideFishingHook)entity;
            if (this.isLavaFishing.isPresent()) {
                return this.isLavaFishing.get().booleanValue() == hook.isLavaFishing();
            }
            if (this.usingMagneticBait.isPresent()) {
                return this.usingMagneticBait.get().booleanValue() == hook.usingMagneticBait();
            }
            if (this.depthLayer.isPresent() && (layer = DepthLayer.fromKey(this.depthLayer.get())).isPresent()) {
                return layer.get() == DepthLayer.getLayerAt(hook.method_23318());
            }
        }
        return false;
    }
}

