/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.data.minigame;

import com.li64.tide.Tide;
import com.li64.tide.network.messages.MinigameClientMsg;
import com.li64.tide.registries.TideItems;
import com.li64.tide.registries.entities.misc.fishing.HookAccessor;
import com.li64.tide.registries.entities.misc.fishing.TideFishingHook;
import com.li64.tide.util.TideUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class FishCatchMinigame {
    private static final int SERVER_DELAY_MILLIS = 200;
    private static final ArrayList<FishCatchMinigame> ACTIVE_MINIGAMES = new ArrayList();
    private static final HashMap<class_3222, Long> ACTIVE_DELAYS = new HashMap();
    private final TideFishingHook hook;
    private final class_3222 player;

    public static FishCatchMinigame getInstance(class_1657 player) {
        for (FishCatchMinigame minigame : ACTIVE_MINIGAMES) {
            if (minigame.getPlayer() != player) continue;
            return minigame;
        }
        return null;
    }

    public static FishCatchMinigame create(class_1657 player) {
        FishCatchMinigame existingInstance = FishCatchMinigame.getInstance(player);
        if (existingInstance != null) {
            return existingInstance;
        }
        FishCatchMinigame minigame = new FishCatchMinigame((class_3222)player);
        ACTIVE_MINIGAMES.add(minigame);
        return minigame;
    }

    public static boolean minigameActive(class_1657 player) {
        for (FishCatchMinigame minigame : ACTIVE_MINIGAMES) {
            if (minigame.getPlayer() != player) continue;
            return true;
        }
        return false;
    }

    protected FishCatchMinigame(class_3222 player) {
        this.player = player;
        this.hook = Objects.requireNonNull(HookAccessor.getHook((class_1657)player));
        this.hook.setMinigameActive(true);
        float strength = TideUtils.getHighestStrength(this.hook.getHookedItems());
        if (this.hook.getHook().method_31574(TideItems.IRON_FISHING_HOOK)) {
            strength *= 0.89f;
        }
        Tide.NETWORK.sendToPlayer(new MinigameClientMsg(0, strength), player);
    }

    public static boolean delayActive(class_3222 player) {
        if (!ACTIVE_DELAYS.containsKey(player)) {
            return false;
        }
        if (System.currentTimeMillis() > ACTIVE_DELAYS.get(player)) {
            ACTIVE_DELAYS.remove(player);
            return false;
        }
        return true;
    }

    private class_3222 getPlayer() {
        return this.player;
    }

    public void onFinish() {
        if (this.cancelIfNecessary()) {
            return;
        }
        this.hook.setMinigameActive(false);
        Tide.NETWORK.sendToPlayer(new MinigameClientMsg(2), this.player);
        ACTIVE_MINIGAMES.remove(this);
        ACTIVE_DELAYS.put(this.player, System.currentTimeMillis() + 200L);
    }

    public void onTimeout() {
        if (this.cancelIfNecessary()) {
            return;
        }
        this.onFinish();
    }

    public void onFail() {
        if (this.cancelIfNecessary()) {
            return;
        }
        if (Tide.CONFIG.minigame.doFailSound) {
            this.hook.method_37908().method_8396(null, this.hook.getPlayerOwner().method_24515(), class_3417.field_14975, class_3419.field_15256, 0.9f, 1.0f);
        }
        this.hook.invalidateCatch();
        this.hook.retrieve();
        this.onFinish();
    }

    public void onWin() {
        if (this.cancelIfNecessary()) {
            return;
        }
        if (Tide.CONFIG.minigame.doSuccessSound) {
            this.hook.method_37908().method_8396(null, this.hook.getPlayerOwner().method_24515(), class_3417.field_14627, class_3419.field_15256, 0.15f, 1.0f);
        }
        this.hook.retrieve();
        this.onFinish();
    }

    public boolean cancelIfNecessary() {
        if (this.hook == null || this.player == null) {
            Tide.NETWORK.sendToPlayer(new MinigameClientMsg(2), this.player);
            ACTIVE_MINIGAMES.remove(this);
            return true;
        }
        return false;
    }

    public void handleClientEvent(byte event) {
        this.cancelIfNecessary();
        switch (event) {
            case 0: {
                this.onTimeout();
                break;
            }
            case 1: {
                this.onFail();
                break;
            }
            case 2: {
                this.onWin();
            }
        }
    }
}

