/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.data.rods;

import com.google.common.collect.ImmutableList;
import com.li64.tide.data.TideDataComponents;
import com.li64.tide.registries.TideItems;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_7225;
import net.minecraft.class_9331;

public class CustomRodManager {
    private static final class_1799 DEFAULT_BOBBER = TideItems.RED_FISHING_BOBBER.method_7854();
    private static final class_1799 DEFAULT_HOOK = TideItems.FISHING_HOOK.method_7854();
    private static final class_1799 DEFAULT_LINE = TideItems.FISHING_LINE.method_7854();

    public static void setBobber(class_1799 rod, class_1799 bobber, class_7225.class_7874 registries) {
        CustomRodManager.setAccessory(TideDataComponents.FISHING_BOBBER, rod, bobber, registries);
    }

    public static void setHook(class_1799 rod, class_1799 hook, class_7225.class_7874 registries) {
        CustomRodManager.setAccessory(TideDataComponents.FISHING_HOOK, rod, hook, registries);
    }

    public static void setLine(class_1799 rod, class_1799 line, class_7225.class_7874 registries) {
        CustomRodManager.setAccessory(TideDataComponents.FISHING_LINE, rod, line, registries);
    }

    private static void setAccessory(class_9331<class_2487> componentType, class_1799 rod, class_1799 accessory, class_7225.class_7874 registries) {
        if (accessory == null || accessory.method_7960()) {
            rod.method_57379(componentType, (Object)new class_2487());
            return;
        }
        class_2487 tag = (class_2487)accessory.method_57376(registries, (class_2520)new class_2487());
        rod.method_57379(componentType, (Object)tag);
    }

    public static class_1799 getBobber(class_1799 rod, class_7225.class_7874 registryAccess) {
        return CustomRodManager.getAccessory(TideDataComponents.FISHING_BOBBER, rod, registryAccess, DEFAULT_BOBBER);
    }

    public static class_1799 getHook(class_1799 rod, class_7225.class_7874 registryAccess) {
        return CustomRodManager.getAccessory(TideDataComponents.FISHING_HOOK, rod, registryAccess, DEFAULT_HOOK);
    }

    public static class_1799 getLine(class_1799 rod, class_7225.class_7874 registryAccess) {
        return CustomRodManager.getAccessory(TideDataComponents.FISHING_LINE, rod, registryAccess, DEFAULT_LINE);
    }

    public static boolean hasBobber(class_1799 rod, class_7225.class_7874 registryAccess) {
        return CustomRodManager.getAccessory(TideDataComponents.FISHING_BOBBER, rod, registryAccess) != null;
    }

    public static boolean hasHook(class_1799 rod, class_7225.class_7874 registryAccess) {
        return CustomRodManager.getAccessory(TideDataComponents.FISHING_HOOK, rod, registryAccess) != null;
    }

    public static boolean hasLine(class_1799 rod, class_7225.class_7874 registryAccess) {
        return CustomRodManager.getAccessory(TideDataComponents.FISHING_LINE, rod, registryAccess) != null;
    }

    private static class_1799 getAccessory(class_9331<class_2487> componentType, class_1799 rod, class_7225.class_7874 registryAccess, class_1799 defaultItem) {
        class_2487 data = (class_2487)rod.method_57824(componentType);
        if (data == null || data.method_33133()) {
            return defaultItem;
        }
        Optional hook = class_1799.method_57360((class_7225.class_7874)registryAccess, (class_2520)data);
        return hook.orElse(defaultItem);
    }

    private static class_1799 getAccessory(class_9331<class_2487> componentType, class_1799 rod, class_7225.class_7874 registryAccess) {
        return CustomRodManager.getAccessory(componentType, rod, registryAccess, null);
    }

    public static List<class_1799> getAccessoryList(class_1799 stack, class_7225.class_7874 registryAccess) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (CustomRodManager.hasBobber(stack, registryAccess)) {
            builder.add((Object)CustomRodManager.getBobber(stack, registryAccess));
        }
        if (CustomRodManager.hasHook(stack, registryAccess)) {
            builder.add((Object)CustomRodManager.getHook(stack, registryAccess));
        }
        if (CustomRodManager.hasLine(stack, registryAccess)) {
            builder.add((Object)CustomRodManager.getLine(stack, registryAccess));
        }
        return builder.build();
    }
}

