/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.events;

import com.li64.tide.Tide;
import com.li64.tide.client.gui.JournalPage;
import com.li64.tide.data.journal.JournalLayout;
import com.li64.tide.data.player.TidePlayerData;
import com.li64.tide.network.messages.ShowToastMsg;
import com.li64.tide.network.messages.UpdateDataMsg;
import com.li64.tide.network.messages.UpdateJournalMsg;
import com.li64.tide.registries.TideItems;
import com.li64.tide.util.TideUtils;
import java.util.List;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class TideEventHandler {
    public static void onEnterNether(class_3222 player) {
        TidePlayerData data = TidePlayerData.getOrCreate(player);
        JournalPage netherPage = TideUtils.getPageByName("nether");
        if (netherPage == null) {
            return;
        }
        if (!data.hasPageUnlocked(netherPage)) {
            data.unlockPage(netherPage);
            Tide.NETWORK.sendToPlayer(new ShowToastMsg((class_2561)class_2561.method_43471((String)"newpage.toast.title"), TideUtils.getPageToastDesc(netherPage), TideUtils.getPageToastIcon(netherPage)), player);
            data.syncTo(player);
        }
    }

    public static void onPlayerJoinWorld(class_3222 player) {
        Tide.NETWORK.sendToPlayer(new UpdateJournalMsg(), player);
        Tide.NETWORK.sendToPlayer(new UpdateDataMsg(), player);
        TidePlayerData playerData = TidePlayerData.getOrCreate(player);
        playerData.syncTo(player);
        if (!Tide.CONFIG.general.giveJournal) {
            return;
        }
        if (!playerData.gotJournal && player.method_7270(TideItems.FISHING_JOURNAL.method_7854())) {
            playerData.gotJournal = true;
            playerData.syncTo(player);
        }
    }

    public static void updateFishingJournal(class_3222 player) {
        class_1661 inventory = player.method_31548();
        for (int slot = 0; slot < inventory.method_5439(); ++slot) {
            class_1799 stack = inventory.method_5438(slot);
            if (!TideUtils.isJournalFish(stack)) continue;
            TidePlayerData data = TidePlayerData.getOrCreate(player);
            if (!data.hasFishUnlocked(stack)) {
                data.unlockFish(stack);
                Tide.NETWORK.sendToPlayer(new ShowToastMsg((class_2561)class_2561.method_43471((String)"newfish.toast.title"), TideUtils.removeRawTextInName(stack.method_7964()), stack.method_7909().method_7854()), player);
                data.syncTo(player);
            }
            List<JournalLayout.Page> pages = Tide.JOURNAL.getPageConfigs();
            pages.forEach(pageConfig -> {
                JournalPage page = new JournalPage((JournalLayout.Page)pageConfig);
                if (TideUtils.isInPage(page.idName(), stack)) {
                    TideUtils.unlockPage(player, page);
                    TideUtils.checkPageCompletion(data, page, player);
                }
            });
        }
    }
}

