/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client.gui;

import dev.ftb.mods.ftbchunks.client.map.MapManager;
import dev.ftb.mods.ftblibrary.config.ColorConfig;
import dev.ftb.mods.ftblibrary.config.ConfigCallback;
import dev.ftb.mods.ftblibrary.config.ConfigFromString;
import dev.ftb.mods.ftblibrary.config.ui.EditStringConfigOverlay;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.ColorSelectorPanel;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.DropDownMenu;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.IntTextBox;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleButton;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.TextBox;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TextComponentUtils;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class AddWaypointOverlay
extends EditStringConfigOverlay<String> {
    private final ColorButton colorButton;
    private final TextBox dimension;
    private final IntTextBox x;
    private final IntTextBox y;
    private final IntTextBox z;
    private final Button buttonAccept;
    private final Button buttonCancel;
    private final Button dropDownButton;
    private final GlobalPosConfig pos;

    public AddWaypointOverlay(Panel panel, class_2561 title, GlobalPosConfig pos, ConfigFromString<String> config, ColorConfig colorConfig, ConfigCallback callback) {
        super(panel, config, callback, title);
        this.pos = pos;
        this.colorButton = new ColorButton(this, (Icon)colorConfig.getValue(), (btn, mb) -> ColorSelectorPanel.popupAtMouse((BaseScreen)this.getGui(), (ColorConfig)colorConfig, accepted -> {
            if (accepted) {
                btn.setIcon((Icon)colorConfig.getValue());
            } else {
                colorConfig.setValue((Object)((ColorButton)btn).getIcon());
            }
        }));
        this.dimension = new TextBox(this, (Panel)this){

            public boolean allowInput() {
                return false;
            }
        };
        List<ContextMenuItem> contextMenuItems = AddWaypointOverlay.createDimContextItems(key -> {
            this.dimension.setText(key.method_29177().toString());
            this.getGui().closeContextMenu();
        });
        this.dropDownButton = new SimpleButton(this, (Panel)this, (class_2561)class_2561.method_43473(), Icons.DROPDOWN_OUT, (widget, mouseButton) -> {
            DropDownMenu dropDownMenu = this.getGui().openDropdownMenu(contextMenuItems);
            dropDownMenu.setPos(dropDownMenu.getPosX() + 3 + (this.dimension.getX() - this.getMouseX()), dropDownMenu.getPosY() + 3 + (this.dimension.getY() + this.dimension.getHeight() - this.getMouseY()));
        }){

            public void drawBackground(class_332 graphics, Theme theme, int x, int y, int w, int h) {
                theme.drawButton(graphics, x, y, w, h, this.getWidgetType());
            }
        };
        this.x = new AddWaypointIntBox((Panel)this);
        this.y = new AddWaypointIntBox((Panel)this);
        this.z = new AddWaypointIntBox((Panel)this);
        this.textBox.setLabel((class_2561)class_2561.method_43471((String)"ftbchunks.gui.label.name"));
        this.dimension.setLabel((class_2561)class_2561.method_43471((String)"ftbchunks.gui.label.dimension"));
        this.x.setLabel((class_2561)class_2561.method_43470((String)"X"));
        this.y.setLabel((class_2561)class_2561.method_43470((String)"Y"));
        this.z.setLabel((class_2561)class_2561.method_43470((String)"Z"));
        this.dimension.setText(((class_4208)pos.getValue()).comp_2207().method_29177().toString());
        this.x.setAmount(((class_4208)pos.getValue()).comp_2208().method_10263());
        this.y.setAmount(((class_4208)pos.getValue()).comp_2208().method_10264());
        this.z.setAmount(((class_4208)pos.getValue()).comp_2208().method_10260());
        this.x.setMinMax(Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.y.setMinMax(Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.z.setMinMax(Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.buttonAccept = new SimpleTextButton((Panel)this, (class_2561)class_2561.method_43471((String)"gui.accept"), Icons.ACCEPT){

            public void onClicked(MouseButton button) {
                AddWaypointOverlay.this.handleAccepted(button);
            }

            public void addMouseOverText(TooltipList list) {
                if (AddWaypointOverlay.this.isNameValid()) {
                    list.add(TextComponentUtils.hotkeyTooltip((String)"\u21e7 + Enter"));
                } else {
                    list.add((class_2561)class_2561.method_43471((String)"ftbchunks.gui.waypoint.no_name"));
                }
            }

            public void draw(class_332 graphics, Theme theme, int x, int y, int w, int h) {
                AddWaypointOverlay.this.buttonAccept.setIcon(AddWaypointOverlay.this.isNameValid() ? Icons.ACCEPT : Icons.ACCEPT_GRAY);
                super.draw(graphics, theme, x, y, w, h);
            }
        };
        SimpleTextButton.accept((Panel)this, this::handleAccepted, (class_2561[])new class_2561[]{TextComponentUtils.hotkeyTooltip((String)"\u21e7 + Enter")});
        this.buttonCancel = SimpleTextButton.cancel((Panel)this, this::handleCancelled, (class_2561[])new class_2561[]{TextComponentUtils.hotkeyTooltip((String)"ESC")});
        this.setAddAcceptCancelButtons(false);
    }

    private boolean isNameValid() {
        return !this.textBox.getText().isBlank();
    }

    private void handleAccepted(MouseButton mouseButton) {
        if (!this.isNameValid()) {
            return;
        }
        this.playClickSound();
        this.onAccepted(this.buttonAccept, mouseButton);
    }

    private void handleCancelled(MouseButton mouseButton) {
        this.playClickSound();
        this.onCancelled(this.buttonCancel, mouseButton);
    }

    private void updatePos() {
        class_2960 dimension = class_2960.method_60654((String)this.dimension.getText());
        class_5321 resourceKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)dimension);
        if (this.x.getText().isBlank() || this.y.getText().isBlank() || this.z.getText().isBlank()) {
            return;
        }
        class_2338 blockPos = new class_2338(this.x.getIntValue(), this.y.getIntValue(), this.z.getIntValue());
        this.pos.setValue(class_4208.method_19443((class_5321)resourceKey, (class_2338)blockPos));
    }

    public void addWidgets() {
        super.addWidgets();
        this.add((Widget)this.colorButton);
        this.add((Widget)this.dimension);
        this.add((Widget)this.x);
        this.add((Widget)this.y);
        this.add((Widget)this.z);
        this.add((Widget)this.buttonAccept);
        this.add((Widget)this.buttonCancel);
        this.add((Widget)this.dropDownButton);
    }

    public void alignWidgets() {
        super.alignWidgets();
        int widgetH = this.getGui().getTheme().getFontHeight() + 4;
        this.textBox.setPos(2, widgetH + 6);
        this.textBox.setWidth(this.width - widgetH - 4 - 4);
        this.colorButton.setPosAndSize(this.width - widgetH - 4, widgetH + 6, widgetH + 1, widgetH + 1);
        int w = (this.width - 3) / 3;
        int y1 = this.textBox.posY + this.textBox.getHeight() + widgetH / 2 + 2;
        this.dimension.setPosAndSize(2, y1, this.width - widgetH - 4 - 4, widgetH);
        this.dropDownButton.setPosAndSize(this.width - widgetH - 4, y1, widgetH + 1, widgetH);
        int xyzHeight = this.dimension.posY + this.dimension.getHeight() + widgetH / 2 + 2;
        this.x.setPosAndSize(2, xyzHeight, w - 2, widgetH);
        this.y.setPosAndSize(2 + w, xyzHeight, w - 2, widgetH);
        this.z.setPosAndSize(2 + w * 2, xyzHeight, w - 2, widgetH);
        int buttonW = w + w / 2;
        int buttonHeight = this.x.posY + this.x.getHeight() + 5;
        this.buttonAccept.setPosAndSize(this.width - buttonW * 2 - 2, buttonHeight, buttonW, 20);
        this.buttonCancel.setPosAndSize(this.width - buttonW, buttonHeight, buttonW - 3, 20);
        this.height += 72;
    }

    public void drawBackground(class_332 graphics, Theme theme, int x, int y, int w, int h) {
        super.drawBackground(graphics, theme, x, y, w, h);
    }

    public static List<ContextMenuItem> createDimContextItems(Consumer<class_5321<class_1937>> onSelected) {
        ArrayList<ContextMenuItem> contextMenuItems = new ArrayList<ContextMenuItem>();
        MapManager manager = MapManager.getInstance().orElseThrow();
        manager.getDimensions().forEach((key, value) -> contextMenuItems.add(new ContextMenuItem(TextComponentUtils.translatedDimension((class_5321)key), (Icon)Icon.empty(), button -> onSelected.accept((class_5321<class_1937>)key))));
        return contextMenuItems;
    }

    public static class GlobalPosConfig
    extends ConfigFromString<class_4208> {
        public boolean parse(@Nullable Consumer<class_4208> callback, String string) {
            return false;
        }
    }

    private class ColorButton
    extends SimpleButton {
        public ColorButton(AddWaypointOverlay addWaypointOverlay, Icon icon, SimpleButton.Callback c) {
            super((Panel)addWaypointOverlay, (class_2561)class_2561.method_43473(), icon, c);
        }

        Color4I getIcon() {
            Color4I c;
            Icon icon = this.icon;
            return icon instanceof Color4I ? (c = (Color4I)icon) : Color4I.empty();
        }

        public void draw(class_332 graphics, Theme theme, int x, int y, int w, int h) {
            this.icon.draw(graphics, x, y, w, h);
            Color4I shade = this.getIcon().addBrightness(-0.15f);
            GuiHelper.drawHollowRect((class_332)graphics, (int)x, (int)y, (int)w, (int)h, (Color4I)shade, (boolean)false);
        }
    }

    public class AddWaypointIntBox
    extends IntTextBox {
        public AddWaypointIntBox(Panel panel) {
            super(panel);
        }

        public void onTextChanged() {
            super.onTextChanged();
            AddWaypointOverlay.this.updatePos();
        }
    }
}

