/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client.minimap.components;

import dev.ftb.mods.ftbchunks.api.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.api.client.minimap.MinimapContext;
import dev.ftb.mods.ftbchunks.api.client.minimap.MinimapInfoComponent;
import dev.ftb.mods.ftbchunks.api.client.minimap.TranslatedOption;
import dev.ftb.mods.ftbchunks.client.minimap.components.RealTimeComponent;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;

public class GameTimeComponent
implements MinimapInfoComponent {
    public static final class_2960 ID = FTBChunksAPI.rl("game_time");
    private static final Icon CLOCK_ICON = ItemIcon.getItemIcon((class_1792)class_1802.field_8557);

    @Override
    public class_2960 id() {
        return ID;
    }

    @Override
    public void render(MinimapContext context, class_332 graphics, class_327 font) {
        String setting = context.getSetting(this);
        if (setting.equals(ClockedTimeMode.CLOCK.name())) {
            CLOCK_ICON.draw(graphics, -8, 0, 16, 16);
            return;
        }
        class_310 minecraft = context.minecraft();
        long time = minecraft.field_1687.method_8532() % 24000L;
        int hours = (int)(time / 1000L);
        int minutes = (int)(time % 1000L * 60L / 1000L);
        int hourTime = hours + 6;
        if (hourTime >= 24) {
            hourTime -= 24;
        }
        this.drawCenteredText(minecraft.field_1772, graphics, (class_2561)class_2561.method_43470((String)RealTimeComponent.createTimeString(hourTime, minutes, setting.equals(ClockedTimeMode.TWENTY_FOUR.name()))), 0);
    }

    @Override
    public int height(MinimapContext context) {
        String setting = context.getSetting(this);
        return !setting.equals(ClockedTimeMode.CLOCK.name()) ? MinimapInfoComponent.super.height(context) : 10;
    }

    @Override
    public Set<TranslatedOption> getConfigComponents() {
        return Arrays.stream(ClockedTimeMode.values()).map(value -> new TranslatedOption(value.name(), "ftbchunks.time_mode." + ClockedTimeMode.NAME_MAP.getName((Object)value))).collect(Collectors.toSet());
    }

    public static enum ClockedTimeMode {
        TWENTY_FOUR,
        TWELVE,
        CLOCK;

        public static final NameMap<ClockedTimeMode> NAME_MAP;

        static {
            NAME_MAP = NameMap.of((Object)((Object)TWENTY_FOUR), (Object[])ClockedTimeMode.values()).baseNameKey("ftbchunks.time_mode").create();
        }
    }
}

