/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.data;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.FTBChunksExpected;
import dev.ftb.mods.ftbchunks.api.ClaimedChunk;
import dev.ftb.mods.ftbchunks.api.event.ClaimedChunkEvent;
import dev.ftb.mods.ftbchunks.data.ChunkSyncInfo;
import dev.ftb.mods.ftbchunks.data.ChunkTeamDataImpl;
import dev.ftb.mods.ftbchunks.net.SendChunkPacket;
import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_8710;
import org.jetbrains.annotations.NotNull;

public class ClaimedChunkImpl
implements ClaimedChunk {
    private ChunkTeamDataImpl teamData;
    private final ChunkDimPos pos;
    private long time;
    private long forceLoaded;
    private long forceLoadExpiryTime;

    public ClaimedChunkImpl(ChunkTeamDataImpl teamData, ChunkDimPos pos) {
        this.teamData = teamData;
        this.pos = pos;
        this.time = System.currentTimeMillis();
        this.forceLoaded = 0L;
        this.forceLoadExpiryTime = 0L;
    }

    @Override
    public ChunkTeamDataImpl getTeamData() {
        return this.teamData;
    }

    public void setTeamData(@NotNull ChunkTeamDataImpl teamData) {
        teamData.clearClaimCaches();
        this.teamData.clearClaimCaches();
        this.teamData = teamData;
    }

    @Override
    public ChunkDimPos getPos() {
        return this.pos;
    }

    @Override
    public long getTimeClaimed() {
        return this.time;
    }

    @Override
    public String getResultId() {
        return "ok";
    }

    @Override
    public boolean isSuccess() {
        return true;
    }

    @Override
    public class_5250 getMessage() {
        return class_2561.method_43470((String)"OK");
    }

    public void setClaimedTime(long t) {
        this.time = t;
        this.teamData.getManager().clearForceLoadedCache();
        this.teamData.clearClaimCaches();
        this.sendUpdateToAll();
    }

    @Override
    public long getForceLoadedTime() {
        return this.forceLoaded;
    }

    @Override
    public boolean isForceLoaded() {
        return this.forceLoaded > 0L;
    }

    @Override
    public boolean isActuallyForceLoaded() {
        return this.isForceLoaded() && this.teamData.canDoOfflineForceLoading();
    }

    public void setForceLoadedTime(long time) {
        if (this.forceLoaded == time) {
            return;
        }
        this.forceLoaded = time;
        this.teamData.getManager().clearForceLoadedCache();
        this.teamData.clearClaimCaches();
        this.sendUpdateToAll();
        class_3218 level = this.teamData.getManager().getMinecraftServer().method_3847(this.pos.dimension());
        if (level != null) {
            if (this.forceLoaded > 0L) {
                level.method_8497(this.pos.x(), this.pos.z());
            }
            class_3215 cache = level.method_14178();
            class_1923 chunkPos = this.pos.chunkPos();
            if (cache != null) {
                FTBChunksExpected.addChunkToForceLoaded(level, "ftbchunks", this.teamData.getTeamId(), chunkPos.field_9181, chunkPos.field_9180, this.forceLoaded > 0L);
                cache.method_17298(false);
            } else {
                FTBChunks.LOGGER.warn("Failed to force-load chunk " + this.pos.x() + ", " + this.pos.z() + " @ " + String.valueOf(this.pos.dimension().method_29177()) + "!");
            }
        }
    }

    public boolean canEntitySpawn(class_1297 entity) {
        return true;
    }

    public boolean allowExplosions() {
        return this.teamData.canExplosionsDamageTerrain();
    }

    public boolean allowMobGriefing() {
        return this.teamData.allowMobGriefing();
    }

    public void sendUpdateToAll() {
        new SendChunkPacket((class_5321<class_1937>)this.pos.dimension(), this.teamData.getTeamId(), ChunkSyncInfo.create(System.currentTimeMillis(), this.pos.x(), this.pos.z(), this)).sendToAll(this.teamData.getManager().getMinecraftServer(), this.teamData);
    }

    @Override
    public void unload(class_2168 source) {
        if (this.isForceLoaded()) {
            this.setForceLoadedTime(0L);
            ((ClaimedChunkEvent.After)ClaimedChunkEvent.AFTER_UNLOAD.invoker()).after(source, this);
            this.teamData.clearClaimCaches();
            this.teamData.markDirty();
            this.forceLoadExpiryTime = 0L;
        }
    }

    @Override
    public void unclaim(class_2168 source, boolean sync) {
        this.unload(source);
        this.teamData.getManager().unregisterClaim(this.pos);
        ((ClaimedChunkEvent.After)ClaimedChunkEvent.AFTER_UNCLAIM.invoker()).after(source, this);
        this.teamData.clearClaimCaches();
        this.teamData.markDirty();
        if (sync) {
            SendChunkPacket packet = new SendChunkPacket((class_5321<class_1937>)this.pos.dimension(), class_156.field_25140, ChunkSyncInfo.create(System.currentTimeMillis(), this.pos.x(), this.pos.z(), null));
            NetworkManager.sendToPlayers((Iterable)source.method_9211().method_3760().method_14571(), (class_8710)packet);
        }
    }

    @Override
    public long getForceLoadExpiryTime() {
        return this.forceLoadExpiryTime;
    }

    @Override
    public void setForceLoadExpiryTime(long forceLoadExpiryTime) {
        this.forceLoadExpiryTime = forceLoadExpiryTime;
        this.teamData.markDirty();
    }

    @Override
    public boolean hasForceLoadExpired(long now) {
        return this.forceLoadExpiryTime > 0L && this.forceLoadExpiryTime < now;
    }

    public String toString() {
        return "[ " + this.pos.toString() + " - " + String.valueOf(this.teamData) + " ]";
    }

    public class_2487 serializeNBT() {
        SNBTCompoundTag o = new SNBTCompoundTag();
        o.singleLine();
        o.method_10569("x", this.getPos().x());
        o.method_10569("z", this.getPos().z());
        o.method_10544("time", this.getTimeClaimed());
        if (this.isForceLoaded()) {
            o.method_10544("force_loaded", this.getForceLoadedTime());
        }
        if (this.getForceLoadExpiryTime() > 0L) {
            o.method_10544("expiry_time", this.getForceLoadExpiryTime());
        }
        return o;
    }

    public static ClaimedChunkImpl deserializeNBT(ChunkTeamDataImpl data, class_5321<class_1937> dimKey, class_2487 tag) {
        ClaimedChunkImpl chunk = new ClaimedChunkImpl(data, new ChunkDimPos(dimKey, tag.method_10550("x"), tag.method_10550("z")));
        chunk.time = tag.method_10537("time");
        chunk.forceLoaded = tag.method_10537("force_loaded");
        chunk.forceLoadExpiryTime = tag.method_10537("expiry_time");
        return chunk;
    }
}

