/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.net;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftbchunks.FTBChunksWorldConfig;
import dev.ftb.mods.ftbchunks.api.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.api.FTBChunksProperties;
import dev.ftb.mods.ftbchunks.client.VisibleClientPlayers;
import dev.ftb.mods.ftbchunks.data.ChunkTeamDataImpl;
import dev.ftb.mods.ftbchunks.data.ClaimedChunkManagerImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4844;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record PlayerVisibilityPacket(List<UUID> uuids) implements class_8710
{
    public static final class_8710.class_9154<PlayerVisibilityPacket> TYPE = new class_8710.class_9154(FTBChunksAPI.rl("player_visibility_packet"));
    public static final class_9139<class_2540, PlayerVisibilityPacket> STREAM_CODEC = class_9139.method_56434((class_9139)class_4844.field_48453.method_56433(class_9135.method_56363()), PlayerVisibilityPacket::uuids, PlayerVisibilityPacket::new);

    public class_8710.class_9154<PlayerVisibilityPacket> method_56479() {
        return TYPE;
    }

    public static void handle(PlayerVisibilityPacket message, NetworkManager.PacketContext context) {
        context.queue(() -> VisibleClientPlayers.updatePlayerList(message.uuids));
    }

    public static void syncToLevel(class_1937 level) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            PlayerVisibilityPacket.syncToPlayers(serverLevel.method_18766(p -> true));
        }
    }

    public static void syncToAll() {
        PlayerVisibilityPacket.syncToPlayers(ClaimedChunkManagerImpl.getInstance().getMinecraftServer().method_3760().method_14571());
    }

    public static void syncToPlayers(List<class_3222> players) {
        if (players == null) {
            players = ClaimedChunkManagerImpl.getInstance().getMinecraftServer().method_3760().method_14571();
        }
        List<VisiblePlayerItem> playerList = players.stream().map(player -> new VisiblePlayerItem((class_3222)player, ClaimedChunkManagerImpl.getInstance().getOrCreateData((class_3222)player))).toList();
        boolean override = (Boolean)FTBChunksWorldConfig.LOCATION_MODE_OVERRIDE.get();
        for (VisiblePlayerItem recipient : playerList) {
            ArrayList<UUID> playerIds = new ArrayList<UUID>();
            for (VisiblePlayerItem other : playerList) {
                if (!override && !recipient.player.method_5687(2) && !other.data.canPlayerUse(recipient.player, FTBChunksProperties.LOCATION_MODE)) continue;
                playerIds.add(other.player.method_5667());
            }
            NetworkManager.sendToPlayer((class_3222)recipient.player, (class_8710)new PlayerVisibilityPacket(playerIds));
        }
    }

    private record VisiblePlayerItem(class_3222 player, ChunkTeamDataImpl data) {
    }
}

