/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import io.wispforest.endec.impl.ReflectiveEndecBuilder;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.block.blocks.pipes.energy.EnergyPipeBlock;
import rearth.oritech.block.blocks.pipes.energy.SuperConductorBlock;
import rearth.oritech.block.blocks.pipes.fluid.FluidPipeBlock;
import rearth.oritech.block.blocks.pipes.item.ItemPipeBlock;
import rearth.oritech.block.entity.accelerator.AcceleratorParticleLogic;
import rearth.oritech.block.entity.addons.AddonBlockEntity;
import rearth.oritech.block.entity.augmenter.PlayerAugments;
import rearth.oritech.block.entity.augmenter.api.Augment;
import rearth.oritech.block.entity.pipes.GenericPipeInterfaceEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.ComponentContent;
import rearth.oritech.init.EntitiesContent;
import rearth.oritech.init.FluidContent;
import rearth.oritech.init.ItemContent;
import rearth.oritech.init.ItemGroups;
import rearth.oritech.init.LootContent;
import rearth.oritech.init.OritechConfig;
import rearth.oritech.init.SoundContent;
import rearth.oritech.init.ToolsContent;
import rearth.oritech.init.recipes.RecipeContent;
import rearth.oritech.init.world.FeatureContent;
import rearth.oritech.item.tools.ElectricMaceItem;
import rearth.oritech.util.registry.ArchitecturyBlockRegistryContainer;
import rearth.oritech.util.registry.ArchitecturyRecipeRegistryContainer;
import rearth.oritech.util.registry.ArchitecturyRegistryContainer;

public final class Oritech {
    public static final String MOD_ID = "oritech";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"oritech");
    public static final OritechConfig CONFIG = OritechConfig.createAndLoad();
    public static final Multimap<class_2960, Runnable> EVENT_MAP = Oritech.initEventMap();

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    public static void initialize() {
        LOGGER.info("Begin Oritech initialization");
        NetworkManager.init();
        NetworkManager.registerDefaultCodecs();
        ParticleContent.registerParticles();
        FeatureContent.initialize();
        LifecycleEvent.SERVER_STARTED.register(Oritech::onServerStarted);
        LifecycleEvent.SERVER_STARTED.register(server -> PlayerAugments.loadAllAugments(server.method_3772()));
        TickEvent.SERVER_POST.register(elem -> AcceleratorParticleLogic.onTickEnd());
        TickEvent.SERVER_POST.register(elem -> AddonBlockEntity.completeInits());
        TickEvent.SERVER_POST.register(elem -> ElectricMaceItem.processLightningEvents((class_1937)elem.method_30002()));
        PlayerEvent.PLAYER_JOIN.register(PlayerAugments::refreshPlayerAugments);
        PlayerEvent.PLAYER_RESPAWN.register((player, inEnd, removalReason) -> PlayerAugments.refreshPlayerAugments((class_1657)player));
        PlayerEvent.CHANGE_DIMENSION.register((player, oldLevel, newLevel) -> PlayerAugments.refreshPlayerAugments((class_1657)player));
        TickEvent.SERVER_PRE.register(event -> event.method_3738().forEach(world -> world.method_18456().forEach(PlayerAugments::serverTickAugments)));
        LOGGER.info("Oritech initialization complete");
    }

    public static void runAllRegistries() {
        LOGGER.info("Running Oritech registrations...");
        LOGGER.debug("Registering fluids");
        EVENT_MAP.get((Object)class_7924.field_41270.method_29177()).forEach(Runnable::run);
        for (class_2960 type : EVENT_MAP.keySet()) {
            if (type.equals((Object)class_7924.field_41270.method_29177()) || type.equals((Object)class_7924.field_44688.method_29177())) continue;
            EVENT_MAP.get((Object)type).forEach(Runnable::run);
        }
        LOGGER.debug("Registering item groups");
        EVENT_MAP.get((Object)class_7924.field_44688.method_29177()).forEach(Runnable::run);
        LOGGER.info("Oritech registrations complete");
    }

    public static Multimap<class_2960, Runnable> initEventMap() {
        ArrayListMultimap res = ArrayListMultimap.create();
        res.put((Object)class_7924.field_41270.method_29177(), FluidContent::registerFluids);
        res.put((Object)class_7924.field_41254.method_29177(), FluidContent::registerBlocks);
        res.put((Object)class_7924.field_41197.method_29177(), FluidContent::registerItems);
        res.put((Object)class_7924.field_41197.method_29177(), () -> ArchitecturyRegistryContainer.register(ItemContent.class, MOD_ID, false));
        res.put((Object)class_7924.field_41254.method_29177(), () -> ArchitecturyRegistryContainer.register(BlockContent.class, MOD_ID, false));
        res.put((Object)class_7924.field_41197.method_29177(), ArchitecturyBlockRegistryContainer::finishItemRegister);
        res.put((Object)class_7924.field_41255.method_29177(), () -> ArchitecturyRegistryContainer.register(BlockEntitiesContent.class, MOD_ID, false));
        res.put((Object)class_7924.field_41225.method_29177(), () -> ArchitecturyRegistryContainer.register(SoundContent.class, MOD_ID, false));
        res.put((Object)class_7924.field_41197.method_29177(), () -> ArchitecturyRegistryContainer.register(ToolsContent.class, MOD_ID, false));
        res.put((Object)class_7924.field_49659.method_29177(), ComponentContent::registerComponents);
        res.put((Object)class_7924.field_41267.method_29177(), () -> ArchitecturyRegistryContainer.register(FeatureContent.class, MOD_ID, false));
        res.put((Object)class_7924.field_41199.method_29177(), () -> ArchitecturyRegistryContainer.register(LootContent.class, MOD_ID, false));
        res.put((Object)class_7924.field_41266.method_29177(), () -> ArchitecturyRegistryContainer.register(EntitiesContent.class, MOD_ID, false));
        res.put((Object)class_7924.field_41197.method_29177(), ToolsContent::registerEventHandlers);
        res.put((Object)class_7924.field_41207.method_29177(), () -> ArchitecturyRegistryContainer.register(ModScreens.class, MOD_ID, false));
        res.put((Object)class_7924.field_41217.method_29177(), () -> ArchitecturyRegistryContainer.register(RecipeContent.class, MOD_ID, false));
        res.put((Object)class_7924.field_44688.method_29177(), () -> ArchitecturyRegistryContainer.register(ItemGroups.class, MOD_ID, false));
        res.put((Object)class_7924.field_41216.method_29177(), ArchitecturyRecipeRegistryContainer::finishSerializerRegister);
        res.put((Object)class_7924.field_41199.method_29177(), FluidContent::registerItemsToGroups);
        res.put((Object)class_2960.method_60655((String)"neoforge", (String)"attachment_types"), Augment::registerAttachmentTypes);
        return res;
    }

    private static void onServerStarted(MinecraftServer minecraftServer) {
        minecraftServer.method_3738().forEach(world -> {
            if (world.field_9236) {
                return;
            }
            class_2960 regKey = world.method_27983().method_29177();
            String dataId = "energy_" + regKey.method_12836() + "_" + regKey.method_12832();
            GenericPipeInterfaceEntity.PipeNetworkData result = (GenericPipeInterfaceEntity.PipeNetworkData)world.method_17983().method_17924(GenericPipeInterfaceEntity.PipeNetworkData.TYPE, dataId);
            EnergyPipeBlock.ENERGY_PIPE_DATA.put(regKey, result);
            String fluidDataId = "fluid_" + regKey.method_12836() + "_" + regKey.method_12832();
            GenericPipeInterfaceEntity.PipeNetworkData fluidResult = (GenericPipeInterfaceEntity.PipeNetworkData)world.method_17983().method_17924(GenericPipeInterfaceEntity.PipeNetworkData.TYPE, fluidDataId);
            FluidPipeBlock.FLUID_PIPE_DATA.put(regKey, fluidResult);
            String itemDataId = "item_" + regKey.method_12836() + "_" + regKey.method_12832();
            GenericPipeInterfaceEntity.PipeNetworkData itemResult = (GenericPipeInterfaceEntity.PipeNetworkData)world.method_17983().method_17924(GenericPipeInterfaceEntity.PipeNetworkData.TYPE, itemDataId);
            ItemPipeBlock.ITEM_PIPE_DATA.put(regKey, itemResult);
            String superConductorDataId = "superconductor_" + regKey.method_12836() + "_" + regKey.method_12832();
            GenericPipeInterfaceEntity.PipeNetworkData superConductorResult = (GenericPipeInterfaceEntity.PipeNetworkData)world.method_17983().method_17924(GenericPipeInterfaceEntity.PipeNetworkData.TYPE, superConductorDataId);
            SuperConductorBlock.SUPERCONDUCTOR_DATA.put(regKey, superConductorResult);
        });
    }

    static {
        ReflectiveEndecBuilder.SHARED_INSTANCE.register(MinecraftEndecs.IDENTIFIER, class_2960.class);
    }
}

