/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.api.attachment.fabric;

import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.attachment.v1.AttachmentRegistry;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import rearth.oritech.Oritech;
import rearth.oritech.api.attachment.Attachment;

public class AttachmentApiImpl {
    private static final Map<class_2960, AttachmentType<?>> registeredTypes = new HashMap();

    public static <T> void register(Attachment<T> attachment) {
        AttachmentType created = AttachmentRegistry.builder().copyOnDeath().initializer(attachment.initializer()).persistent(attachment.persistenceCodec()).buildAndRegister(attachment.identifier());
        registeredTypes.put(attachment.identifier(), created);
    }

    public static <T> boolean hasAttachment(class_1309 entity, Attachment<T> attachment) {
        AttachmentType<?> type = registeredTypes.get(attachment.identifier());
        if (type == null) {
            Oritech.LOGGER.warn("Querying attachment that has not been registered: {}", (Object)attachment.identifier());
            return false;
        }
        return entity.hasAttached(type);
    }

    public static <T> T getAttachmentValue(class_1309 entity, Attachment<T> attachment) {
        AttachmentType<?> type = registeredTypes.get(attachment.identifier());
        if (type == null) {
            Oritech.LOGGER.warn("Getting attachment that has not been registered: {}", (Object)attachment.identifier());
            return null;
        }
        return (T)entity.getAttachedOrCreate(type);
    }

    public static <T> void setAttachment(class_1309 entity, Attachment<T> attachment, T value) {
        AttachmentType<?> type = registeredTypes.get(attachment.identifier());
        if (type == null) {
            Oritech.LOGGER.warn("Setting attachment that has not been registered: {}", (Object)attachment.identifier());
            return;
        }
        entity.setAttached(type, value);
    }

    public static <T> void removeAttachment(class_1309 entity, Attachment<T> attachment) {
        AttachmentType<?> type = registeredTypes.get(attachment.identifier());
        if (type == null) {
            Oritech.LOGGER.warn("Removing attachment that has not been registered: {}", (Object)attachment.identifier());
            return;
        }
        entity.removeAttached(type);
    }
}

