/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.api.fluid.containers;

import com.mojang.serialization.DynamicOps;
import dev.architectury.fluid.FluidStack;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_3545;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.api.networking.UpdatableField;

public class SimpleInOutFluidStorage
extends FluidApi.MultiSlotStorage
implements UpdatableField<Void, class_3545<FluidStack, FluidStack>> {
    private FluidStack contentIn;
    private FluidStack contentOut;
    private final Long capacity;
    private final Runnable onUpdate;
    private final FluidApi.SingleSlotStorage inputContainer;
    private final FluidApi.SingleSlotStorage outputContainer;

    public SimpleInOutFluidStorage(final Long capacity, final Runnable onUpdate) {
        this.capacity = capacity;
        this.onUpdate = onUpdate;
        this.contentIn = FluidStack.empty();
        this.contentOut = FluidStack.empty();
        this.inputContainer = new FluidApi.SingleSlotStorage(this){
            final /* synthetic */ SimpleInOutFluidStorage this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void setStack(FluidStack stack) {
                this.this$0.contentIn = stack;
            }

            @Override
            public FluidStack getStack() {
                return this.this$0.contentIn;
            }

            @Override
            public long getCapacity() {
                return capacity;
            }

            @Override
            public long insert(FluidStack toInsert, boolean simulate) {
                return SimpleInOutFluidStorage.insertTo(toInsert, simulate, capacity, this.this$0.contentIn, this::setStack);
            }

            @Override
            public long extract(FluidStack toExtract, boolean simulate) {
                return SimpleInOutFluidStorage.extractFrom(toExtract, simulate, this.this$0.contentIn);
            }

            @Override
            public List<FluidStack> getContent() {
                return List.of(this.this$0.contentIn);
            }

            @Override
            public void update() {
                onUpdate.run();
            }
        };
        this.outputContainer = new FluidApi.SingleSlotStorage(this){
            final /* synthetic */ SimpleInOutFluidStorage this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void setStack(FluidStack stack) {
                this.this$0.contentOut = stack;
            }

            @Override
            public FluidStack getStack() {
                return this.this$0.contentOut;
            }

            @Override
            public long getCapacity() {
                return capacity;
            }

            @Override
            public long insert(FluidStack toInsert, boolean simulate) {
                return SimpleInOutFluidStorage.insertTo(toInsert, simulate, capacity, this.this$0.contentOut, this::setStack);
            }

            @Override
            public long extract(FluidStack toExtract, boolean simulate) {
                return SimpleInOutFluidStorage.extractFrom(toExtract, simulate, this.this$0.contentOut);
            }

            @Override
            public List<FluidStack> getContent() {
                return List.of(this.this$0.contentOut);
            }

            @Override
            public void update() {
                onUpdate.run();
            }
        };
    }

    @Override
    public long getCapacity() {
        return this.capacity;
    }

    @Override
    public long insert(FluidStack toInsert, boolean simulate) {
        return SimpleInOutFluidStorage.insertTo(toInsert, simulate, this.capacity, this.contentIn, stack -> this.setStack(0, (FluidStack)stack));
    }

    @Override
    public long extract(FluidStack toExtract, boolean simulate) {
        return SimpleInOutFluidStorage.extractFrom(toExtract, simulate, this.contentOut);
    }

    @Override
    public List<FluidStack> getContent() {
        return List.of(this.contentIn, this.contentOut);
    }

    @Override
    public void update() {
        this.onUpdate.run();
    }

    public FluidApi.SingleSlotStorage getInputContainer() {
        return this.inputContainer;
    }

    public FluidApi.SingleSlotStorage getOutputContainer() {
        return this.outputContainer;
    }

    @Override
    public FluidApi.FluidStorage getStorageForDirection(@Nullable class_2350 direction) {
        if (direction == null) {
            return this;
        }
        if (direction.equals((Object)class_2350.field_11036)) {
            return this.inputContainer;
        }
        if (direction.equals((Object)class_2350.field_11033)) {
            return this.outputContainer;
        }
        return this;
    }

    @Override
    public void setStack(int slot, FluidStack stack) {
        if (slot == 0) {
            this.contentIn = stack;
        } else {
            this.contentOut = stack;
        }
    }

    @Override
    public FluidStack getStack(int slot) {
        if (slot == 0) {
            return this.contentIn;
        }
        return this.contentOut;
    }

    @Override
    public int getSlotCount() {
        return 2;
    }

    public void writeNbt(class_2487 nbt, String suffix) {
        FluidStack.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.contentIn).result().ifPresent(tag -> nbt.method_10566("fluidin" + suffix, tag));
        FluidStack.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.contentOut).result().ifPresent(tag -> nbt.method_10566("fluidout" + suffix, tag));
    }

    public void readNbt(class_2487 nbt, String suffix) {
        this.contentIn = FluidStack.CODEC.parse((DynamicOps)class_2509.field_11560, (Object)nbt.method_10580("fluidin" + suffix)).result().orElse(FluidStack.empty());
        this.contentOut = FluidStack.CODEC.parse((DynamicOps)class_2509.field_11560, (Object)nbt.method_10580("fluidout" + suffix)).result().orElse(FluidStack.empty());
    }

    public static Long insertTo(FluidStack toInsert, boolean simulate, long capacity, FluidStack content, Consumer<FluidStack> setFunction) {
        if (toInsert.isEmpty()) {
            return 0L;
        }
        if (content.isEmpty()) {
            long inserted = Math.min(toInsert.getAmount(), capacity);
            if (!simulate) {
                setFunction.accept(toInsert.copyWithAmount(inserted));
            }
            return inserted;
        }
        if (content.isFluidEqual(toInsert) && content.isComponentEqual(toInsert)) {
            long inserted = Math.min(toInsert.getAmount(), capacity - content.getAmount());
            if (!simulate) {
                content.grow(inserted);
            }
            return inserted;
        }
        return 0L;
    }

    public static Long extractFrom(FluidStack toExtract, boolean simulate, FluidStack content) {
        if (content.isEmpty()) {
            return 0L;
        }
        if (content.isFluidEqual(toExtract) && content.isComponentEqual(toExtract)) {
            long extracted = Math.min(toExtract.getAmount(), content.getAmount());
            if (!simulate) {
                content.shrink(extracted);
            }
            return extracted;
        }
        return 0L;
    }

    public FluidStack getInStack() {
        return this.contentIn;
    }

    public FluidStack getOutStack() {
        return this.contentOut;
    }

    @Override
    public FluidApi.FluidStorage getStorageForSlot(int slot) {
        return slot == 0 ? this.inputContainer : this.outputContainer;
    }

    @Override
    public class_3545<FluidStack, FluidStack> getDeltaData() {
        return new class_3545((Object)this.contentIn, (Object)this.contentOut);
    }

    @Override
    public Void getFullData() {
        return null;
    }

    @Override
    public class_9139<? extends ByteBuf, class_3545<FluidStack, FluidStack>> getDeltaCodec() {
        return new class_9139<ByteBuf, class_3545<FluidStack, FluidStack>>(this){

            public class_3545<FluidStack, FluidStack> decode(ByteBuf buf) {
                if (buf instanceof class_9129) {
                    class_9129 registryByteBuf = (class_9129)buf;
                    FluidStack left = (FluidStack)NetworkManager.FLUID_STACK_STREAM_CODEC.decode((Object)registryByteBuf);
                    FluidStack right = (FluidStack)NetworkManager.FLUID_STACK_STREAM_CODEC.decode((Object)registryByteBuf);
                    return new class_3545((Object)left, (Object)right);
                }
                Oritech.LOGGER.error("Trying to decode storage data to non-registry buf! {}", (Object)buf);
                return new class_3545((Object)FluidStack.empty(), (Object)FluidStack.empty());
            }

            public void encode(ByteBuf buf, class_3545<FluidStack, FluidStack> value) {
                if (buf instanceof class_9129) {
                    class_9129 registryByteBuf = (class_9129)buf;
                    NetworkManager.FLUID_STACK_STREAM_CODEC.encode((Object)registryByteBuf, (Object)((FluidStack)value.method_15442()));
                    NetworkManager.FLUID_STACK_STREAM_CODEC.encode((Object)registryByteBuf, (Object)((FluidStack)value.method_15441()));
                } else {
                    Oritech.LOGGER.error("Trying to encode storage data to non-registry buf! {} in {}", (Object)buf, value);
                }
            }
        };
    }

    @Override
    public class_9139<? extends ByteBuf, Void> getFullCodec() {
        return null;
    }

    @Override
    public boolean useDeltaOnly(SyncType type) {
        return true;
    }

    @Override
    public void handleFullUpdate(Void updatedData) {
    }

    @Override
    public void handleDeltaUpdate(class_3545<FluidStack, FluidStack> updatedData) {
        this.contentIn = (FluidStack)updatedData.method_15442();
        this.contentOut = (FluidStack)updatedData.method_15441();
    }
}

