/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.base.block;

import com.mojang.serialization.MapCodec;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2383;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_9062;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.fluid.ItemFluidApi;
import rearth.oritech.block.base.entity.MachineBlockEntity;
import rearth.oritech.block.entity.processing.PulverizerBlockEntity;
import rearth.oritech.util.TooltipHelper;

public abstract class MachineBlock
extends class_2383
implements class_2343 {
    public MachineBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11043));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{class_2741.field_12481});
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)Objects.requireNonNull(super.method_9605(ctx)).method_11657((class_2769)class_2741.field_12481, (Comparable)ctx.method_8042().method_10153());
    }

    protected MapCodec<? extends class_2383> method_53969() {
        return null;
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11456;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        try {
            return this.getBlockEntityType().getDeclaredConstructor(class_2338.class, class_2680.class).newInstance(pos, state);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            Oritech.LOGGER.error("Unable to create blockEntity for " + this.getBlockEntityType().getSimpleName() + " at " + String.valueOf((Object)this));
            return new PulverizerBlockEntity(pos, state);
        }
    }

    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        MachineBlock.onBlockRemoved(world, pos);
        return super.method_9576(world, pos, state, player);
    }

    protected void method_55124(class_2680 state, class_1937 world, class_2338 pos, class_1927 explosion, BiConsumer<class_1799, class_2338> stackMerger) {
        MachineBlock.onBlockRemoved(world, pos);
        super.method_55124(state, world, pos, explosion, stackMerger);
    }

    private static void onBlockRemoved(class_1937 world, class_2338 pos) {
        if (!world.field_9236) {
            MachineBlockEntity entity = (MachineBlockEntity)world.method_8321(pos);
            class_2371 stacks = entity.inventory.heldStacks;
            for (class_1799 stack : stacks) {
                if (stack.method_7960()) continue;
                class_1542 itemEntity = new class_1542(world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), stack);
                world.method_8649((class_1297)itemEntity);
            }
            entity.inventory.heldStacks.clear();
            entity.inventory.method_5431();
        }
    }

    @NotNull
    public abstract Class<? extends class_2586> getBlockEntityType();

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return (world1, pos, state1, blockEntity) -> {
            if (blockEntity instanceof class_5558) {
                class_5558 ticker = (class_5558)blockEntity;
                ticker.tick(world1, pos, state1, blockEntity);
            }
        };
    }

    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (!world.field_9236) {
            ExtendedMenuProvider handler = (ExtendedMenuProvider)world.method_8321(pos);
            MenuRegistry.openExtendedMenu((class_3222)((class_3222)player), (ExtendedMenuProvider)handler);
        }
        return class_1269.field_5812;
    }

    public class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (ItemFluidApi.tryFluidBlockItemInteraction(stack, world, pos, player, hand)) {
            return class_9062.method_55644((boolean)true);
        }
        return super.method_55765(stack, state, world, pos, player, hand, hit);
    }

    public void method_9568(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 options) {
        TooltipHelper.addMachineTooltip(tooltip, (class_2248)this, this);
    }
}

