/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.base.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.api.energy.containers.DynamicEnergyStorage;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.base.entity.MachineBlockEntity;
import rearth.oritech.client.ui.UpgradableMachineScreenHandler;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.util.MachineAddonController;
import rearth.oritech.util.ScreenProvider;

public abstract class UpgradableMachineBlockEntity
extends MachineBlockEntity
implements MachineAddonController {
    @SyncField(value={SyncType.GUI_OPEN})
    private final List<class_2338> connectedAddons = new ArrayList<class_2338>();
    @SyncField(value={SyncType.GUI_OPEN})
    private final List<class_2338> openSlots = new ArrayList<class_2338>();
    @SyncField(value={SyncType.GUI_OPEN})
    private MachineAddonController.BaseAddonData addonData = MachineAddonController.DEFAULT_ADDON_DATA;

    public UpgradableMachineBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state, int energyPerTick) {
        super(type, pos, state, energyPerTick);
    }

    @Override
    protected void craftItem(OritechRecipe activeRecipe, List<class_1799> outputInventory, List<class_1799> inputInventory) {
        super.craftItem(activeRecipe, outputInventory, inputInventory);
        if (this.supportExtraChambersAuto()) {
            Optional<class_8786<OritechRecipe>> newRecipe;
            int chamberCount = this.addonData.extraChambers();
            for (int i = 0; i < chamberCount && !(newRecipe = this.getRecipe()).isEmpty() && ((OritechRecipe)newRecipe.get().comp_1933()).equals(this.currentRecipe) && this.canOutputRecipe(activeRecipe) && this.canProceed(activeRecipe); ++i) {
                super.craftItem(activeRecipe, outputInventory, inputInventory);
            }
        }
    }

    public boolean supportExtraChambersAuto() {
        return true;
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        this.writeAddonToNbt(nbt);
    }

    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.loadAddonNbtData(nbt);
        this.updateEnergyContainer();
    }

    @Override
    public List<class_2338> getConnectedAddons() {
        return this.connectedAddons;
    }

    @Override
    public List<class_2338> getOpenAddonSlots() {
        return this.openSlots;
    }

    @Override
    public class_2350 getFacingForAddon() {
        return super.getFacing();
    }

    @Override
    public DynamicEnergyStorage getStorageForAddon() {
        return super.getEnergyStorage();
    }

    @Override
    public MachineAddonController.BaseAddonData getBaseAddonData() {
        return this.addonData;
    }

    @Override
    public class_2338 getPosForAddon() {
        return this.method_11016();
    }

    @Override
    public class_1937 getWorldForAddon() {
        return this.method_10997();
    }

    @Override
    public void setBaseAddonData(MachineAddonController.BaseAddonData data) {
        this.addonData = data;
        this.method_5431();
    }

    @Override
    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new UpgradableMachineScreenHandler(syncId, playerInventory, this);
    }

    @Override
    public ItemApi.InventoryStorage getInventoryForAddon() {
        return this.inventory;
    }

    @Override
    public ScreenProvider getScreenProvider() {
        return this;
    }

    @Override
    public float getSpeedMultiplier() {
        return this.getBaseAddonData().speed();
    }

    @Override
    public float getEfficiencyMultiplier() {
        return this.getBaseAddonData().efficiency();
    }

    @Override
    public int receivedRedstoneSignal() {
        if (this.disabledViaRedstone) {
            return 15;
        }
        return 0;
    }

    @Override
    public String currentRedstoneEffect() {
        if (this.disabledViaRedstone) {
            return "tooltip.oritech.redstone_disabled";
        }
        return "tooltip.oritech.redstone_enabled";
    }
}

