/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.blocks.pipes;

import java.util.HashSet;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import rearth.oritech.block.blocks.pipes.GenericPipeConnectionBlock;
import rearth.oritech.block.entity.pipes.ExtractablePipeInterfaceEntity;
import rearth.oritech.block.entity.pipes.GenericPipeInterfaceEntity;
import rearth.oritech.init.ItemContent;

public abstract class ExtractablePipeConnectionBlock
extends GenericPipeConnectionBlock {
    public static final int EXTRACT = 2;
    public static final class_2758 NORTH = class_2758.method_11867((String)"north", (int)0, (int)2);
    public static final class_2758 EAST = class_2758.method_11867((String)"east", (int)0, (int)2);
    public static final class_2758 SOUTH = class_2758.method_11867((String)"south", (int)0, (int)2);
    public static final class_2758 WEST = class_2758.method_11867((String)"west", (int)0, (int)2);
    public static final class_2758 UP = class_2758.method_11867((String)"up", (int)0, (int)2);
    public static final class_2758 DOWN = class_2758.method_11867((String)"down", (int)0, (int)2);

    public ExtractablePipeConnectionBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        class_2758 property;
        if (player.method_24518(ItemContent.WRENCH)) {
            return class_1269.field_5811;
        }
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        class_2350 interactDir = this.getInteractDirection(state, pos, player);
        if (!this.hasMachineInDirection(interactDir, world, pos, this.apiValidationFunction())) {
            return class_1269.field_5811;
        }
        Integer connection = (Integer)state.method_11654((class_2769)(property = this.directionToProperty(interactDir)));
        world.method_30092(pos, (class_2680)state.method_11657((class_2769)property, (Comparable)Integer.valueOf(connection != 2 ? 2 : CONNECTION)), 16, 0);
        world.method_8396(null, pos, class_3417.field_40067, class_3419.field_15245, 0.9f, 1.2f);
        this.invalidateTargetCache(world, pos);
        return class_1269.field_5812;
    }

    public boolean hasExtractingSide(class_2680 state) {
        for (class_2350 direction : field_23157) {
            class_2758 property = this.directionToProperty(direction);
            if ((Integer)state.method_11654((class_2769)property) != 2) continue;
            return true;
        }
        return false;
    }

    protected void invalidateTargetCache(class_1937 world, class_2338 pos) {
        GenericPipeInterfaceEntity.PipeNetworkData data = this.getNetworkData(world);
        Integer network = data.pipeNetworkLinks.getOrDefault(pos, null);
        if (network != null) {
            HashSet<class_2338> checked = new HashSet<class_2338>();
            for (class_3545<class_2338, class_2350> pipeInterface : data.pipeNetworkInterfaces.get(network)) {
                class_2338 pipePos = ((class_2338)pipeInterface.method_15442()).method_10093((class_2350)pipeInterface.method_15441());
                if (checked.contains(pipePos)) continue;
                checked.add(pipePos);
                class_2586 pipeEntity = world.method_8321(pipePos);
                if (!(pipeEntity instanceof ExtractablePipeInterfaceEntity)) continue;
                ((ExtractablePipeInterfaceEntity)pipeEntity).invalidateTargetCache();
            }
        }
    }

    @Override
    public class_2680 addConnectionStates(class_2680 state, class_1937 world, class_2338 pos, boolean createConnection) {
        for (class_2350 direction : class_2350.values()) {
            class_2758 property = this.directionToProperty(direction);
            boolean connection = this.shouldConnect(state, direction, pos, world, createConnection);
            if (connection && (Integer)state.method_11654((class_2769)property) == 2) continue;
            state = (class_2680)state.method_11657((class_2769)property, (Comparable)Integer.valueOf(connection ? CONNECTION : NO_CONNECTION));
        }
        return this.addStraightState(state);
    }

    @Override
    public class_2680 addConnectionStates(class_2680 state, class_1937 world, class_2338 pos, class_2350 createDirection) {
        for (class_2350 direction : class_2350.values()) {
            class_2758 property = this.directionToProperty(direction);
            boolean connection = this.shouldConnect(state, direction, pos, world, direction.equals((Object)createDirection));
            int newValue = connection ? (this.isSideExtractable(state, direction) ? 2 : CONNECTION) : NO_CONNECTION;
            state = (class_2680)state.method_11657((class_2769)property, (Comparable)Integer.valueOf(newValue));
        }
        return this.addStraightState(state);
    }

    public boolean isExtractable(class_2680 state) {
        for (class_2350 side : class_2350.values()) {
            if (!this.isSideExtractable(state, side)) continue;
            return true;
        }
        return false;
    }

    public boolean isSideExtractable(class_2680 state, class_2350 side) {
        return this.directionToPropertyValue(state, side) == 2;
    }

    @Override
    public class_2758 getNorthProperty() {
        return NORTH;
    }

    @Override
    public class_2758 getEastProperty() {
        return EAST;
    }

    @Override
    public class_2758 getSouthProperty() {
        return SOUTH;
    }

    @Override
    public class_2758 getWestProperty() {
        return WEST;
    }

    @Override
    public class_2758 getUpProperty() {
        return UP;
    }

    @Override
    public class_2758 getDownProperty() {
        return DOWN;
    }
}

