/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.blocks.storage;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_8567;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.block.base.entity.ExpandableEnergyStorageBlockEntity;
import rearth.oritech.block.entity.storage.SmallStorageBlockEntity;
import rearth.oritech.init.BlockContent;
import rearth.oritech.util.ComparatorOutputProvider;
import rearth.oritech.util.MachineAddonController;
import rearth.oritech.util.TooltipHelper;

public class SmallStorageBlock
extends class_2248
implements class_2343 {
    public static final class_2753 TARGET_DIR = class_2753.method_35305((String)"target_dir");

    public SmallStorageBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)TARGET_DIR, (Comparable)class_2350.field_11043));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{TARGET_DIR});
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)Objects.requireNonNull(super.method_9605(ctx)).method_11657((class_2769)TARGET_DIR, (Comparable)ctx.method_7715().method_10153());
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new SmallStorageBlockEntity(pos, state);
    }

    protected boolean method_9498(class_2680 state) {
        return true;
    }

    protected int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        return ((ComparatorOutputProvider)world.method_8321(pos)).getComparatorOutput();
    }

    public boolean method_9506(class_2680 state) {
        return true;
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        super.method_9612(state, world, pos, sourceBlock, sourcePos, notify);
        if (world.field_9236) {
            return;
        }
        boolean isPowered = world.method_49803(pos);
        ExpandableEnergyStorageBlockEntity storageEntity = (ExpandableEnergyStorageBlockEntity)world.method_8321(pos);
        storageEntity.setRedstonePowered(isPowered);
    }

    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (!world.field_9236) {
            class_2586 entity = world.method_8321(pos);
            if (!(entity instanceof MachineAddonController)) {
                return class_1269.field_5812;
            }
            MachineAddonController machineEntity = (MachineAddonController)entity;
            machineEntity.initAddons();
            ExtendedMenuProvider handler = (ExtendedMenuProvider)world.method_8321(pos);
            MenuRegistry.openExtendedMenu((class_3222)((class_3222)player), (ExtendedMenuProvider)handler);
        }
        return class_1269.field_5812;
    }

    protected List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        List droppedStacks = super.method_9560(state, builder);
        class_2586 blockEntity = (class_2586)builder.method_51876(class_181.field_1228);
        if (blockEntity instanceof SmallStorageBlockEntity) {
            SmallStorageBlockEntity storageEntity = (SmallStorageBlockEntity)blockEntity;
            droppedStacks.addAll(storageEntity.inventory.getHeldStacks());
        }
        return droppedStacks;
    }

    public class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state) {
        return SmallStorageBlock.getStackWithData(world, pos);
    }

    @NotNull
    private static class_1799 getStackWithData(class_4538 world, class_2338 pos) {
        class_1799 stack = new class_1799((class_1935)BlockContent.SMALL_STORAGE_BLOCK.method_8389());
        SmallStorageBlockEntity storageEntity = (SmallStorageBlockEntity)world.method_8321(pos);
        if (storageEntity.getEnergyStorage(null).getAmount() > 0L) {
            stack.method_57379(EnergyApi.ITEM.getEnergyComponent(), (Object)storageEntity.getEnergyStorage(null).getAmount());
        }
        return stack;
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        super.method_9567(world, pos, state, placer, itemStack);
        Long storedEnergyInStack = (Long)itemStack.method_57825(EnergyApi.ITEM.getEnergyComponent(), (Object)0L);
        if (storedEnergyInStack > 0L) {
            ExpandableEnergyStorageBlockEntity storageEntity = (ExpandableEnergyStorageBlockEntity)world.method_8321(pos);
            storageEntity.energyStorage.setAmount(storedEnergyInStack);
        }
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return (world1, pos, state1, blockEntity) -> {
            if (blockEntity instanceof class_5558) {
                class_5558 ticker = (class_5558)blockEntity;
                ticker.tick(world1, pos, state1, blockEntity);
            }
        };
    }

    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        class_2586 entity;
        if (!world.field_9236 && (entity = world.method_8321(pos)) instanceof MachineAddonController) {
            MachineAddonController machineEntity = (MachineAddonController)entity;
            machineEntity.resetAddons();
        }
        return super.method_9576(world, pos, state, player);
    }

    public void method_9568(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 options) {
        super.method_9568(stack, context, tooltip, options);
        TooltipHelper.addMachineTooltip(tooltip, this, this);
    }
}

