/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.accelerator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1309;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3545;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.block.blocks.accelerator.AcceleratorPassthroughBlock;
import rearth.oritech.block.blocks.accelerator.AcceleratorRingBlock;
import rearth.oritech.block.entity.accelerator.AcceleratorControllerBlockEntity;
import rearth.oritech.block.entity.accelerator.AcceleratorSensorBlockEntity;
import rearth.oritech.init.BlockContent;
import rearth.oritech.util.Geometry;

public class AcceleratorParticleLogic {
    private final class_2338 pos;
    private final class_3218 world;
    private final AcceleratorControllerBlockEntity entity;
    private static final Map<CompPair<class_2338, class_2382>, class_2338> cachedGates = new HashMap<CompPair<class_2338, class_2382>, class_2338>();
    private static final Map<class_2338, class_2338> activeParticles = new HashMap<class_2338, class_2338>();

    public AcceleratorParticleLogic(class_2338 pos, class_3218 world, AcceleratorControllerBlockEntity entity) {
        this.pos = pos;
        this.world = world;
        this.entity = entity;
    }

    public void update(ActiveParticle particle) {
        float timePassed = 0.05f;
        ArrayList<class_243> renderedTrail = new ArrayList<class_243>();
        renderedTrail.add(particle.position);
        HashSet<class_2338> checkedPositions = new HashSet<class_2338>();
        float availableDistance = particle.velocity * timePassed;
        while ((double)availableDistance > 0.001) {
            class_2586 class_25862;
            class_2248 gateBlock;
            boolean wasBend;
            class_2338 usedGateForCollision;
            if (particle.nextGate == null) {
                this.exitParticle(particle, new class_243(0.0, 0.0, 0.0), AcceleratorControllerBlockEntity.ParticleEvent.ERROR);
                return;
            }
            class_243 path = particle.nextGate.method_46558().method_1020(particle.position);
            double pathLength = path.method_1033();
            double moveDist = Math.min(pathLength, (double)availableDistance);
            availableDistance = (float)((double)availableDistance - moveDist);
            class_243 movedBy = path.method_1029().method_1021(moveDist);
            boolean abTest = movedBy.field_1352 > 0.0 || movedBy.field_1351 > 0.0;
            class_2338 validLastGate = particle.lastGate == null ? particle.nextGate : particle.lastGate;
            class_2338 class_23382 = usedGateForCollision = abTest ? validLastGate : particle.nextGate;
            if (this.updateParticleCollision(class_243.method_24954((class_2382)usedGateForCollision), particle)) {
                return;
            }
            particle.position = particle.position.method_1019(movedBy);
            renderedTrail.add(particle.position);
            particle.lastBendDistance = (float)((double)particle.lastBendDistance + moveDist);
            this.checkParticleEntityCollision(particle.position, particle, checkedPositions);
            if (!(moveDist >= pathLength - (double)0.1f)) continue;
            class_2338 reachedGate = particle.nextGate;
            class_2382 nextDirection = this.getGateExitDirection(particle.lastGate, particle.nextGate);
            class_2338 nextGate = this.findNextGateCached(reachedGate, nextDirection, particle.velocity);
            if (nextGate == null) {
                this.exitParticle(particle, class_243.method_24954((class_2382)nextDirection), AcceleratorControllerBlockEntity.ParticleEvent.EXITED_NO_GATE);
                return;
            }
            class_2338 gateOffset = particle.nextGate.method_10059((class_2382)particle.lastGate);
            class_2382 lastDirection = new class_2382(Math.clamp((long)gateOffset.method_10263(), -1, 1), 0, Math.clamp((long)gateOffset.method_10260(), -1, 1));
            boolean bl = wasBend = !lastDirection.equals((Object)nextDirection);
            if (wasBend) {
                float requiredDist;
                float combinedDist = AcceleratorParticleLogic.getParticleBendDist(particle.lastBendDistance, particle.lastBendDistance2);
                if (combinedDist <= (requiredDist = AcceleratorParticleLogic.getRequiredBendDist(particle.velocity))) {
                    this.exitParticle(particle, class_243.method_24954((class_2382)particle.nextGate.method_10059((class_2382)particle.lastGate)), AcceleratorControllerBlockEntity.ParticleEvent.EXITED_FAST);
                    return;
                }
                particle.lastBendDistance2 = particle.lastBendDistance;
                particle.lastBendDistance = 0.0f;
            }
            if ((gateBlock = this.world.method_8320(reachedGate).method_26204()).equals(BlockContent.ACCELERATOR_MOTOR)) {
                this.entity.handleParticleMotorInteraction(reachedGate);
            } else if (gateBlock.equals(BlockContent.ACCELERATOR_SENSOR) && (class_25862 = this.world.method_8321(reachedGate)) instanceof AcceleratorSensorBlockEntity) {
                AcceleratorSensorBlockEntity sensorEntity = (AcceleratorSensorBlockEntity)class_25862;
                sensorEntity.measureParticle(particle);
            }
            particle.nextGate = nextGate;
            particle.lastGate = reachedGate;
        }
        this.entity.onParticleMoved(renderedTrail);
    }

    private void checkParticleEntityCollision(class_243 position, ActiveParticle particle, Set<class_2338> alreadyChecked) {
        class_2338 blockPos = class_2338.method_49638((class_2374)position);
        if (alreadyChecked.contains(blockPos)) {
            return;
        }
        alreadyChecked.add(blockPos);
        List targets = this.world.method_8390(class_1309.class, new class_238(blockPos), elem -> elem.method_5805() && elem.method_5732() && !elem.method_7325());
        float remainingMomentum = particle.velocity;
        for (class_1309 mob : targets) {
            float usedMomentum;
            if (!((remainingMomentum -= (usedMomentum = this.entity.handleParticleEntityCollision(blockPos, particle, remainingMomentum, mob))) <= 0.1f)) continue;
            return;
        }
        particle.velocity = remainingMomentum;
    }

    private void exitParticle(ActiveParticle particle, class_243 direction, AcceleratorControllerBlockEntity.ParticleEvent reason) {
        class_243 exitFrom = particle.position;
        double distance = Math.max(Math.sqrt(particle.velocity), 0.4) * 0.9;
        class_243 exitTo = exitFrom.method_1019(direction.method_1029().method_1021(distance));
        this.entity.onParticleExited(exitFrom, exitTo, particle.lastGate, direction, reason);
        int searchDist = (int)distance;
        class_2382 searchDirection = new class_2382((int)Math.round(direction.field_1352), 0, (int)Math.round(direction.field_1350));
        class_2338 searchStart = particle.nextGate;
        if (searchStart == null) {
            searchStart = particle.lastGate;
        }
        float remainingMomentum = particle.velocity;
        for (int i = 1; i <= searchDist; ++i) {
            boolean targetableBlock;
            float usedMomentum;
            class_2338 checkPos = searchStart.method_10081(searchDirection.method_35862(i));
            List targets = this.world.method_8390(class_1309.class, new class_238(checkPos), elem -> elem.method_5805() && elem.method_5732() && !elem.method_7325());
            for (class_1309 mob : targets) {
                if (!((remainingMomentum -= (usedMomentum = this.entity.handleParticleEntityCollision(checkPos, particle, remainingMomentum, mob))) <= 0.1f)) continue;
                return;
            }
            class_2680 block = this.world.method_8320(checkPos);
            boolean bl = targetableBlock = !block.method_26215() && !(block.method_26204() instanceof AcceleratorPassthroughBlock);
            if (!targetableBlock || !((remainingMomentum -= (usedMomentum = this.entity.handleParticleBlockCollision(checkPos, particle, remainingMomentum, block))) <= 0.1f)) continue;
            return;
        }
    }

    private boolean updateParticleCollision(class_243 position, ActiveParticle particle) {
        class_2338 blockPos = new class_2338((int)position.field_1352, (int)position.field_1351, (int)position.field_1350);
        if (activeParticles.containsKey(blockPos) && !activeParticles.get(blockPos).equals((Object)this.pos)) {
            AcceleratorControllerBlockEntity secondAccelerator;
            class_2338 secondControllerPos = activeParticles.get(blockPos);
            class_2586 class_25862 = this.world.method_8321(secondControllerPos);
            if (!(class_25862 instanceof AcceleratorControllerBlockEntity) || (secondAccelerator = (AcceleratorControllerBlockEntity)class_25862).getParticle() == null) {
                return false;
            }
            ActiveParticle secondParticle = secondAccelerator.getParticle();
            float impactSpeed = particle.velocity + secondParticle.velocity;
            this.entity.onParticleCollided(impactSpeed, particle.position, secondControllerPos, secondAccelerator);
            return true;
        }
        activeParticles.put(blockPos, this.pos);
        return false;
    }

    private class_2382 getGateExitDirection(class_2338 lastGate, class_2338 nextGate) {
        class_2338 incomingPath = nextGate.method_10059((class_2382)lastGate);
        boolean incomingStraight = incomingPath.method_10263() == 0 || incomingPath.method_10260() == 0;
        class_2382 incomingDir = new class_2382(Math.clamp((long)incomingPath.method_10263(), -1, 1), 0, Math.clamp((long)incomingPath.method_10260(), -1, 1));
        class_2680 targetState = this.world.method_8320(nextGate);
        class_2248 targetBlock = targetState.method_26204();
        if (targetBlock.equals(BlockContent.ACCELERATOR_MOTOR) || targetBlock.equals(BlockContent.ACCELERATOR_SENSOR)) {
            return incomingDir;
        }
        if (!targetBlock.equals(BlockContent.ACCELERATOR_RING)) {
            return incomingDir;
        }
        class_2350 targetFacing = (class_2350)targetState.method_11654((class_2769)class_2741.field_12481);
        Integer targetBent = (Integer)targetState.method_11654((class_2769)AcceleratorRingBlock.BENT);
        Integer targetRedstone = (Integer)targetState.method_11654((class_2769)AcceleratorRingBlock.REDSTONE_STATE);
        if (targetRedstone == 0 && incomingStraight && Geometry.getBackward(targetFacing).equals((Object)incomingDir)) {
            return Geometry.getBackward(targetFacing);
        }
        if (!incomingStraight) {
            return Geometry.getBackward(targetFacing);
        }
        if (targetBent == 0) {
            return incomingDir;
        }
        if (targetBent == 1) {
            return Geometry.getForward(targetFacing).method_35853(Geometry.getLeft(targetFacing));
        }
        return Geometry.getForward(targetFacing).method_35853(Geometry.getRight(targetFacing));
    }

    public static float getMaxGateDist(float speed) {
        return (float)Math.clamp(Math.sqrt(speed) / 2.0, 2.0, (double)Oritech.CONFIG.maxGateDist());
    }

    public static float getRequiredBendDist(float speed) {
        return (float)(Math.sqrt(speed) / (double)Oritech.CONFIG.bendFactor());
    }

    public static float getParticleBendDist(float distA, float distB) {
        return distA + distB;
    }

    @Nullable
    private class_2338 findNextGateCached(class_2338 from, class_2382 direction, float speed) {
        class_2338 result;
        int dist;
        float maxDist = AcceleratorParticleLogic.getMaxGateDist(speed);
        CompPair<class_2338, class_2382> key = new CompPair<class_2338, class_2382>(from, direction);
        if (cachedGates.containsKey(key) && (float)(dist = (int)(result = cachedGates.get(key)).method_46558().method_1022(from.method_46558())) <= maxDist) {
            return result;
        }
        class_2338 candidate = this.findNextGate(from, direction, speed);
        if (candidate != null) {
            cachedGates.put(key, candidate);
        }
        return candidate;
    }

    @Nullable
    public class_2338 findNextGate(class_2338 from, class_2382 direction, float speed) {
        float maxDist = AcceleratorParticleLogic.getMaxGateDist(speed);
        int i = 1;
        while ((float)i <= maxDist) {
            class_2338 candidatePos = from.method_10081(direction.method_35862(i));
            class_2680 candidateState = this.world.method_8320(candidatePos);
            if (!candidateState.method_26215()) {
                boolean isValid;
                if (candidateState.method_26204().equals(BlockContent.ACCELERATOR_MOTOR) || candidateState.method_26204().equals(BlockContent.ACCELERATOR_SENSOR)) {
                    return candidatePos;
                }
                if (!candidateState.method_26204().equals(BlockContent.ACCELERATOR_RING)) {
                    return null;
                }
                Integer candidateBent = (Integer)candidateState.method_11654((class_2769)AcceleratorRingBlock.BENT);
                class_2350 candidateFacing = (class_2350)candidateState.method_11654((class_2769)class_2741.field_12481);
                Integer candidateRedstone = (Integer)candidateState.method_11654((class_2769)AcceleratorRingBlock.REDSTONE_STATE);
                class_2338 candidateBack = candidatePos.method_10081(Geometry.getBackward(candidateFacing).method_35862(i));
                class_2338 candidateFront = candidatePos.method_10081(Geometry.getForward(candidateFacing).method_35862(i));
                if (candidateBent == 1) {
                    candidateFront = candidateFront.method_10081(Geometry.getLeft(candidateFacing).method_35862(i));
                }
                if (candidateBent == 2) {
                    candidateFront = candidateFront.method_10081(Geometry.getRight(candidateFacing).method_35862(i));
                }
                boolean bl = isValid = candidateBack.equals((Object)from) || candidateFront.equals((Object)from);
                if (!isValid && candidateRedstone != 3) {
                    candidateFront = candidatePos.method_10081(Geometry.getForward(candidateFacing).method_35862(i));
                    if (candidateRedstone == 1) {
                        candidateFront = candidateFront.method_10081(Geometry.getLeft(candidateFacing).method_35862(i));
                    } else if (candidateRedstone == 2) {
                        candidateFront = candidateFront.method_10081(Geometry.getRight(candidateFacing).method_35862(i));
                    }
                    isValid = candidateFront.equals((Object)from);
                }
                if (isValid) {
                    return candidatePos;
                }
            }
            ++i;
        }
        return null;
    }

    public static void onTickEnd() {
        activeParticles.clear();
    }

    public static void resetCachedGate(class_2338 pos) {
        List<CompPair> toRemove = cachedGates.entrySet().stream().filter(elem -> ((class_2338)((CompPair)((Object)((Object)elem.getKey()))).method_15442()).equals((Object)pos) || ((class_2338)elem.getValue()).equals((Object)pos)).map(Map.Entry::getKey).toList();
        toRemove.forEach(cachedGates::remove);
    }

    public static void resetNearbyCache(class_2338 pos) {
        List<CompPair> toRemove = cachedGates.keySet().stream().filter(blockPos -> ((class_2338)blockPos.method_15442()).method_19455((class_2382)pos) < Oritech.CONFIG.maxGateDist() + 1).toList();
        toRemove.forEach(cachedGates::remove);
    }

    public static final class ActiveParticle {
        public class_243 position;
        public float velocity;
        public class_2338 nextGate;
        public class_2338 lastGate;
        public float lastBendDistance = 15000.0f;
        public float lastBendDistance2 = 15000.0f;

        public ActiveParticle(class_243 position, float velocity, class_2338 nextGate, class_2338 lastGate) {
            this.position = position;
            this.velocity = velocity;
            this.nextGate = nextGate;
            this.lastGate = lastGate;
        }
    }

    public static final class CompPair<A, B>
    extends class_3545<A, B> {
        public CompPair(A left, B right) {
            super(left, right);
        }

        public int hashCode() {
            return (this.method_15442() == null ? 0 : this.method_15442().hashCode()) ^ (this.method_15441() == null ? 0 : this.method_15441().hashCode());
        }

        public boolean equals(Object o) {
            if (!(o instanceof CompPair)) {
                return false;
            }
            CompPair p = (CompPair)((Object)o);
            return Objects.equals(p.method_15442(), this.method_15442()) && Objects.equals(p.method_15441(), this.method_15441());
        }
    }
}

