/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.addons;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_5455;
import net.minecraft.class_5558;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.block.blocks.addons.MachineAddonBlock;
import rearth.oritech.block.entity.addons.AddonBlockEntity;
import rearth.oritech.client.ui.RedstoneAddonScreenHandler;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.util.ComparatorOutputProvider;

public class RedstoneAddonBlockEntity
extends AddonBlockEntity
implements class_5558<RedstoneAddonBlockEntity>,
ExtendedMenuProvider,
ComparatorOutputProvider {
    private RedstoneControllable cachedController;
    public RedstoneMode activeMode = RedstoneMode.INPUT_CONTROL;
    public int monitoredSlot = 0;
    public int currentOutput;

    public RedstoneAddonBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.REDSTONE_ADDON_ENTITY, pos, state);
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, RedstoneAddonBlockEntity blockEntity) {
        if (world.field_9236 || !this.isConnected() || this.activeMode == RedstoneMode.INPUT_CONTROL) {
            return;
        }
        int lastOutput = this.currentOutput;
        switch (this.activeMode.ordinal()) {
            case 0: {
                this.currentOutput = this.cachedController.getComparatorEnergyAmount();
                break;
            }
            case 1: {
                this.currentOutput = this.cachedController.getComparatorSlotAmount(this.monitoredSlot);
                break;
            }
            case 2: {
                this.currentOutput = this.cachedController.getComparatorProgress();
                break;
            }
            case 3: {
                this.currentOutput = this.cachedController.getComparatorActiveState();
                break;
            }
            case 4: {
                this.currentOutput = 0;
            }
        }
        if (this.currentOutput != lastOutput) {
            this.method_5431();
        }
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10569("slot", this.monitoredSlot);
        nbt.method_10569("mode", this.activeMode.ordinal());
    }

    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.monitoredSlot = nbt.method_10550("slot");
        this.activeMode = RedstoneMode.values()[nbt.method_10550("mode")];
    }

    public void sendDataToClient() {
        NetworkManager.sendBlockHandle(this, new RedstoneAddonClientUpdate(this.field_11867, this.getControllerPos(), this.monitoredSlot, this.activeMode.ordinal(), this.currentOutput));
    }

    public void sendDataToServer() {
        NetworkManager.sendToServer(new RedstoneAddonServerUpdate(this.field_11867, this.getControllerPos(), this.monitoredSlot, this.activeMode.ordinal(), this.currentOutput));
    }

    private boolean isConnected() {
        Boolean isUsed = (Boolean)this.method_11010().method_11654((class_2769)MachineAddonBlock.ADDON_USED);
        return isUsed != false && this.getCachedController() != null;
    }

    public RedstoneControllable getCachedController() {
        if (this.cachedController != null) {
            return this.cachedController;
        }
        class_2586 class_25862 = this.field_11863.method_8321(this.getControllerPos());
        if (class_25862 instanceof RedstoneControllable) {
            RedstoneControllable redstoneControllable;
            this.cachedController = redstoneControllable = (RedstoneControllable)class_25862;
        }
        return this.cachedController;
    }

    public void setRedstonePowered(boolean isPowered) {
        this.method_5431();
        if (this.activeMode != RedstoneMode.INPUT_CONTROL) {
            return;
        }
        if (this.getCachedController() != null) {
            this.cachedController.onRedstoneEvent(isPowered);
        }
    }

    @Override
    public int getComparatorOutput() {
        return this.currentOutput;
    }

    public void saveExtraData(class_2540 buf) {
        this.sendDataToClient();
        buf.method_10807(this.field_11867);
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new RedstoneAddonScreenHandler(syncId, playerInventory, this);
    }

    public class_2561 method_5476() {
        return class_2561.method_43470((String)"");
    }

    public static void receiveOnServer(RedstoneAddonServerUpdate message, class_1657 player, class_5455 dynamicRegistryManager) {
        class_2586 class_25862 = player.method_37908().method_8321(message.position);
        if (class_25862 instanceof RedstoneAddonBlockEntity) {
            RedstoneAddonBlockEntity addonEntity = (RedstoneAddonBlockEntity)class_25862;
            addonEntity.activeMode = RedstoneMode.values()[message.targetMode()];
            addonEntity.monitoredSlot = message.targetSlot();
        }
    }

    public static void receiveOnClient(RedstoneAddonClientUpdate message, class_1937 world, class_5455 dynamicRegistryManager) {
        class_2586 class_25862 = world.method_8321(message.position);
        if (class_25862 instanceof RedstoneAddonBlockEntity) {
            RedstoneAddonBlockEntity addonEntity = (RedstoneAddonBlockEntity)class_25862;
            addonEntity.currentOutput = message.currentOutput();
            addonEntity.activeMode = RedstoneMode.values()[message.targetMode()];
            addonEntity.monitoredSlot = message.targetSlot();
            addonEntity.setControllerPos(message.controllerPos());
        }
    }

    public static enum RedstoneMode {
        OUTPUT_POWER,
        OUTPUT_SLOT,
        OUTPUT_PROGRESS,
        OUTPUT_ACTIVE,
        INPUT_CONTROL;

    }

    public static interface RedstoneControllable
    extends ComparatorOutputProvider {
        public int getComparatorEnergyAmount();

        public int getComparatorSlotAmount(int var1);

        public int getComparatorProgress();

        public int getComparatorActiveState();

        public void onRedstoneEvent(boolean var1);

        @Override
        default public int getComparatorOutput() {
            return 0;
        }
    }

    public record RedstoneAddonClientUpdate(class_2338 position, class_2338 controllerPos, int targetSlot, int targetMode, int currentOutput) implements class_8710
    {
        public static final class_8710.class_9154<RedstoneAddonClientUpdate> PACKET_ID = new class_8710.class_9154(Oritech.id("redstoneaddonclient"));

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return PACKET_ID;
        }
    }

    public record RedstoneAddonServerUpdate(class_2338 position, class_2338 controllerPos, int targetSlot, int targetMode, int currentOutput) implements class_8710
    {
        public static final class_8710.class_9154<RedstoneAddonServerUpdate> PACKET_ID = new class_8710.class_9154(Oritech.id("redstoneaddonserver"));

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return PACKET_ID;
        }
    }
}

