/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.augmenter.api;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import rearth.oritech.Oritech;
import rearth.oritech.api.attachment.Attachment;
import rearth.oritech.api.attachment.AttachmentApi;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.block.entity.augmenter.PlayerAugments;
import rearth.oritech.block.entity.augmenter.api.CustomAugmentsCollection;

public abstract class Augment {
    public static final Attachment<Map<class_2960, AugmentState>> ACTIVE_AUGMENTS_DATA = new Attachment<Map<class_2960, AugmentState>>(){

        @Override
        public class_2960 identifier() {
            return Oritech.id("playeraugments");
        }

        @Override
        public Codec<Map<class_2960, AugmentState>> persistenceCodec() {
            return Codec.unboundedMap((Codec)class_2960.field_25139, AugmentState.CODEC);
        }

        @Override
        public Supplier<Map<class_2960, AugmentState>> initializer() {
            return HashMap::new;
        }
    };
    public final class_2960 id;
    public final boolean toggleable;

    public static void registerAttachmentTypes() {
        AttachmentApi.register(ACTIVE_AUGMENTS_DATA);
        AttachmentApi.register(CustomAugmentsCollection.PORTAL_TARGET_TYPE);
    }

    protected Augment(class_2960 id, boolean toggleable) {
        this.id = id;
        this.toggleable = toggleable;
    }

    public boolean isInstalled(class_1657 player) {
        Map<class_2960, AugmentState> data = AttachmentApi.getAttachmentValue((class_1309)player, ACTIVE_AUGMENTS_DATA);
        AugmentState state = data.getOrDefault(this.id, AugmentState.NOT_INSTALLED);
        return !state.equals((Object)AugmentState.NOT_INSTALLED);
    }

    public void installToPlayer(class_1657 player) {
        HashMap<class_2960, AugmentState> data = new HashMap<class_2960, AugmentState>(AttachmentApi.getAttachmentValue((class_1309)player, ACTIVE_AUGMENTS_DATA));
        data.put(this.id, AugmentState.ENABLED);
        AttachmentApi.setAttachment((class_1309)player, ACTIVE_AUGMENTS_DATA, data);
        this.syncToClient(player, data);
        this.activate(player);
    }

    public void removeFromPlayer(class_1657 player) {
        HashMap<class_2960, AugmentState> data = new HashMap<class_2960, AugmentState>(AttachmentApi.getAttachmentValue((class_1309)player, ACTIVE_AUGMENTS_DATA));
        data.put(this.id, AugmentState.NOT_INSTALLED);
        AttachmentApi.setAttachment((class_1309)player, ACTIVE_AUGMENTS_DATA, data);
        this.syncToClient(player, data);
        this.deactivate(player);
    }

    public boolean isEnabled(class_1657 player) {
        Map<class_2960, AugmentState> data = AttachmentApi.getAttachmentValue((class_1309)player, ACTIVE_AUGMENTS_DATA);
        AugmentState state = data.getOrDefault(this.id, AugmentState.NOT_INSTALLED);
        return state.equals((Object)AugmentState.ENABLED);
    }

    public void toggle(class_1657 player) {
        HashMap<class_2960, AugmentState> data = new HashMap<class_2960, AugmentState>(AttachmentApi.getAttachmentValue((class_1309)player, ACTIVE_AUGMENTS_DATA));
        AugmentState state = data.getOrDefault(this.id, AugmentState.NOT_INSTALLED);
        if (state.equals((Object)AugmentState.ENABLED)) {
            state = AugmentState.DISABLED;
            this.deactivate(player);
        } else if (state.equals((Object)AugmentState.DISABLED)) {
            state = AugmentState.ENABLED;
            this.activate(player);
        }
        data.put(this.id, state);
        AttachmentApi.setAttachment((class_1309)player, ACTIVE_AUGMENTS_DATA, data);
        this.syncToClient(player, data);
    }

    public abstract void activate(class_1657 var1);

    public abstract void deactivate(class_1657 var1);

    public abstract void refreshServer(class_1657 var1);

    public void refreshClient(class_1657 player) {
    }

    public void syncToClient(class_1657 player, Map<class_2960, AugmentState> data) {
        NetworkManager.sendPlayerHandle(new PlayerAugments.AugmentPlayerStatePacket(data), (class_3222)player);
    }

    public abstract int refreshInterval();

    public static enum AugmentState {
        ENABLED,
        DISABLED,
        NOT_INSTALLED;

        public static final Codec<AugmentState> CODEC;

        static {
            CODEC = Codec.INT.flatXmap(id -> DataResult.success((Object)((Object)AugmentState.values()[id])), augmentState -> DataResult.success((Object)augmentState.ordinal()));
        }
    }
}

