/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.generators;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3545;
import net.minecraft.class_7225;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.block.base.block.MultiblockMachine;
import rearth.oritech.block.base.entity.MachineBlockEntity;
import rearth.oritech.block.base.entity.PassiveGeneratorBlockEntity;
import rearth.oritech.block.blocks.generators.BigSolarPanelBlock;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.util.MultiblockMachineController;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BigSolarPanelEntity
extends PassiveGeneratorBlockEntity
implements MultiblockMachineController,
GeoBlockEntity {
    public static final RawAnimation FOLD = RawAnimation.begin().thenPlayAndHold("fold");
    public static final RawAnimation UNFOLD = RawAnimation.begin().thenPlayAndHold("unfold");
    protected final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final AnimationController<BigSolarPanelEntity> animationController = this.getAnimationController();
    private final ArrayList<class_2338> coreBlocksConnected = new ArrayList();
    private float coreQuality = 1.0f;
    private boolean isFolded;

    public BigSolarPanelEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.BIG_SOLAR_ENTITY, pos, state);
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        this.addMultiblockToNbt(nbt);
        nbt.method_10556("folded", this.isFolded);
    }

    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.loadMultiblockNbtData(nbt);
        this.isFolded = nbt.method_10577("folded");
    }

    @Override
    public int getProductionRate() {
        int baseRate = ((BigSolarPanelBlock)this.method_11010().method_26204()).productionRate;
        int skyLightLevel = this.field_11863.method_8314(class_1944.field_9284, this.method_11016());
        this.isFolded = this.field_11863.method_23886() && skyLightLevel < 12;
        return (int)(this.coreQuality * (float)baseRate);
    }

    @Override
    public boolean isProducing() {
        int skyLightLevel = this.field_11863.method_8314(class_1944.field_9284, this.method_11016());
        return !this.field_11863.method_23886() && skyLightLevel >= 12 && this.isActive(this.method_11010());
    }

    public void sendInfoMessageToPlayer(class_1657 player) {
        player.method_43496((class_2561)class_2561.method_43469((String)"message.oritech.generator.production_rate", (Object[])new Object[]{this.getProductionRate(), Float.valueOf(this.getCoreQuality())}));
    }

    @Override
    protected Set<class_3545<class_2338, class_2350>> getOutputTargets(class_2338 pos, class_1937 world) {
        HashSet<class_3545<class_2338, class_2350>> res = new HashSet<class_3545<class_2338, class_2350>>();
        res.add(new class_3545((Object)pos.method_10074(), (Object)class_2350.field_11033));
        res.add(new class_3545((Object)pos.method_10072(), (Object)class_2350.field_11043));
        res.add(new class_3545((Object)pos.method_10095(), (Object)class_2350.field_11035));
        return res;
    }

    @Override
    public ArrayList<class_2338> getConnectedCores() {
        return this.coreBlocksConnected;
    }

    @Override
    public class_2350 getFacingForMultiblock() {
        return class_2350.field_11043;
    }

    @Override
    public float getCoreQuality() {
        return this.coreQuality;
    }

    @Override
    public void setCoreQuality(float quality) {
        this.coreQuality = quality;
    }

    @Override
    public ItemApi.InventoryStorage getInventoryForMultiblock() {
        return null;
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorageForMultiblock(class_2350 direction) {
        return null;
    }

    @Override
    public List<class_2382> getCorePositions() {
        return List.of(new class_2382(1, 1, 1), new class_2382(0, 1, 1), new class_2382(-1, 1, 1), new class_2382(1, 1, 0), new class_2382(0, 1, 0), new class_2382(-1, 1, 0), new class_2382(1, 1, -1), new class_2382(0, 1, -1), new class_2382(-1, 1, -1), new class_2382(1, 0, 1), new class_2382(0, 0, 1), new class_2382(-1, 0, 1), new class_2382(1, 0, -1), new class_2382(0, 0, -1), new class_2382(-1, 0, -1));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(this.animationController);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    private AnimationController<BigSolarPanelEntity> getAnimationController() {
        return new AnimationController((GeoAnimatable)this, state -> {
            if (!this.isActive(this.method_11010())) {
                return state.setAndContinue(MachineBlockEntity.PACKAGED);
            }
            if (state.isCurrentAnimation(MachineBlockEntity.SETUP)) {
                if (state.getController().hasAnimationFinished()) {
                    return state.setAndContinue(MachineBlockEntity.IDLE);
                }
                return state.setAndContinue(MachineBlockEntity.SETUP);
            }
            long timeOfDay = this.getAdjustedTimeOfDay();
            int skyLightLevel = this.field_11863.method_8314(class_1944.field_9284, this.method_11016());
            boolean isDay = timeOfDay > 0L && timeOfDay < 12500L;
            boolean bl = this.isFolded = !isDay || skyLightLevel < 12;
            if (this.isFolded) {
                return state.setAndContinue(FOLD);
            }
            if (state.isCurrentAnimation(MachineBlockEntity.IDLE)) {
                return state.setAndContinue(MachineBlockEntity.IDLE);
            }
            return state.setAndContinue(UNFOLD);
        });
    }

    @Override
    public class_2338 getPosForMultiblock() {
        return this.method_11016();
    }

    @Override
    public class_1937 getWorldForMultiblock() {
        return this.method_10997();
    }

    public long getAdjustedTimeOfDay() {
        return (this.field_11863.method_8532() + (long)this.getTimeOffset()) % 24000L;
    }

    public int getTimeOffset() {
        int base = this.field_11867.method_10263() + this.field_11867.method_10260();
        return (int)(Math.sin((double)base / 60.0) * 100.0);
    }

    public boolean isActive(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)MultiblockMachine.ASSEMBLED);
    }

    @Override
    public void triggerSetupAnimation() {
    }
}

