/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.generators;

import dev.architectury.fluid.FluidStack;
import dev.architectury.platform.Platform;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3917;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.base.entity.FluidMultiblockGeneratorBlockEntity;
import rearth.oritech.block.base.entity.MultiblockGeneratorBlockEntity;
import rearth.oritech.block.entity.MachineCoreEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.init.recipes.OritechRecipeType;
import rearth.oritech.init.recipes.RecipeContent;
import rearth.oritech.util.Geometry;
import rearth.oritech.util.InventorySlotAssignment;
import rearth.oritech.util.ScreenProvider;

public class SteamEngineEntity
extends MultiblockGeneratorBlockEntity
implements FluidApi.BlockProvider {
    private static final int MAX_SPEED = 10;
    private static final int MAX_CHAIN_SIZE = 20;
    private static final float WATER_RATIO = 0.9f;
    public static float STEAM_AMOUNT_MULTIPLIER = Platform.isNeoForge() ? 0.05f : 4.0f;
    private static class_3611 USED_STEAM_FLUID;
    public long masterHeartbeat;
    public SteamEngineEntity master;
    private final Set<SteamEngineEntity> slaves = new HashSet<SteamEngineEntity>();
    @SyncField(value={SyncType.GUI_TICK, SyncType.GUI_OPEN})
    public SteamEngineSyncPacket clientStats;

    public SteamEngineEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.STEAM_ENGINE_ENTITY, pos, state, Oritech.CONFIG.generators.steamEngineData.steamToRfRatio());
        this.clientStats = new SteamEngineSyncPacket(pos, 1.0f, 1.0f, 0L, 0L, 0);
    }

    @Override
    public void serverTick(class_1937 world, class_2338 pos, class_2680 state, NetworkedBlockEntity blockEntity) {
        boolean hasInput;
        if (world.field_9236 || !this.isActive(state)) {
            return;
        }
        boolean slaved = this.inSlaveMode();
        boolean bl = hasInput = !this.boilerStorage.getInStack().isEmpty();
        if (world.method_8510() % 80L == 0L && !slaved && hasInput) {
            this.setupMaster();
        }
        if (!slaved && hasInput) {
            this.tickMaster();
        }
        if (slaved) {
            this.tickSlave();
        }
        this.outputEnergy();
    }

    private void tickMaster() {
        FluidApi.SingleSlotStorage steamTank = this.boilerStorage.getInputContainer();
        FluidApi.SingleSlotStorage waterTank = this.boilerStorage.getOutputContainer();
        if (this.energyStorage.getAmount() >= this.energyStorage.getCapacity() && Oritech.CONFIG.generators.steamEngineData.stopOnEnergyFull()) {
            return;
        }
        if (waterTank.getStack().getAmount() >= waterTank.getCapacity() && Oritech.CONFIG.generators.steamEngineData.stopOnWaterFull()) {
            return;
        }
        if (this.currentRecipe == OritechRecipe.DUMMY || !this.currentRecipe.getFluidInput().matchesFluid(steamTank.getStack())) {
            Optional<class_8786<OritechRecipe>> candidate = FluidMultiblockGeneratorBlockEntity.getRecipe(steamTank, this.field_11863, this.getOwnRecipeType());
            candidate.ifPresent(recipe -> {
                this.currentRecipe = (OritechRecipe)recipe.comp_1933();
            });
            if (candidate.isEmpty()) {
                return;
            }
            this.currentRecipe = (OritechRecipe)candidate.get().comp_1933();
        }
        float speed = this.getSteamProcessingSpeed(steamTank);
        int workerCount = this.slaves.size() + 1;
        float consumedCount = (float)this.currentRecipe.getFluidInput().amount() * speed * (float)workerCount * STEAM_AMOUNT_MULTIPLIER;
        float producedCount = consumedCount * 0.9f;
        steamTank.extract(steamTank.getStack().copyWithAmount((long)consumedCount), false);
        waterTank.insert(FluidStack.create((class_3611)class_3612.field_15910, (long)((long)producedCount)), false);
        float energyEfficiency = this.getSteamEnergyEfficiency(speed);
        float energyProduced = consumedCount * energyEfficiency * (float)this.energyPerTick / STEAM_AMOUNT_MULTIPLIER;
        this.energyStorage.insertIgnoringLimit((long)energyProduced, false);
        this.spawnParticles();
        this.lastWorkedAt = this.field_11863.method_8510();
        this.progress = (int)(speed * 100.0f);
        this.clientStats = new SteamEngineSyncPacket(this.field_11867, speed, energyEfficiency, (long)energyProduced, (long)(consumedCount / STEAM_AMOUNT_MULTIPLIER), this.slaves.size());
        this.method_5431();
    }

    private void tickSlave() {
        SteamEngineSyncPacket masterStats = this.master.clientStats;
        if (masterStats == null) {
            return;
        }
        boolean wasWorking = this.master.isActivelyWorking();
        float speed = masterStats.speed();
        if (wasWorking) {
            this.spawnParticles();
            this.lastWorkedAt = this.field_11863.method_8510();
            this.method_5431();
        }
        this.progress = (int)(speed * 100.0f);
    }

    private void setupMaster() {
        this.slaves.clear();
        block0: for (int direction = -1; direction <= 1; ++direction) {
            if (direction == 0) continue;
            for (int i = 1; i <= 20; ++i) {
                Optional candidate;
                class_2338 checkPos = new class_2338(Geometry.offsetToWorldPosition(this.getFacing(), new class_2382(i * direction, 0, 0), (class_2382)this.field_11867));
                Optional coreCandidate = this.field_11863.method_35230(checkPos, BlockEntitiesContent.MACHINE_CORE_ENTITY);
                if (coreCandidate.isPresent() && ((MachineCoreEntity)coreCandidate.get()).getCachedController() != null) {
                    checkPos = ((MachineCoreEntity)coreCandidate.get()).getControllerPos();
                }
                if ((candidate = this.field_11863.method_35230(checkPos, BlockEntitiesContent.STEAM_ENGINE_ENTITY)).isEmpty() || !((SteamEngineEntity)candidate.get()).isActive(((SteamEngineEntity)candidate.get()).method_11010()) || !((SteamEngineEntity)candidate.get()).boilerStorage.getInStack().isEmpty()) continue block0;
                SteamEngineEntity slave = (SteamEngineEntity)candidate.get();
                this.slaves.add(slave);
                slave.masterHeartbeat = this.field_11863.method_8510();
                slave.master = this;
            }
        }
    }

    public boolean inSlaveMode() {
        long heartbeatAge = this.field_11863.method_8510() - this.masterHeartbeat;
        return heartbeatAge <= 100L && this.master != null && !this.master.method_11015();
    }

    @Override
    public boolean boilerAcceptsInput(class_3611 fluid) {
        return fluid.equals(SteamEngineEntity.getUsedSteamFluid());
    }

    private void spawnParticles() {
        if ((double)this.field_11863.field_9229.method_43057() > 0.5) {
            return;
        }
        class_2350 facing = this.getFacing();
        class_243 offsetLocal = Geometry.rotatePosition(new class_243(0.0, 0.0, -0.5), facing);
        class_243 emitPosition = class_243.method_24953((class_2382)this.field_11867).method_1019(offsetLocal);
        ParticleContent.STEAM_ENGINE_WORKING.spawn(this.field_11863, emitPosition, (Object)1);
    }

    private float getSteamEnergyEfficiency(float x) {
        return (float)((double)(0.5f - 0.1966667f * x) + 0.09166666865348816 * Math.pow(x, 2.0) - (double)0.0075f * Math.pow(x, 3.0)) + 0.4f;
    }

    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
    }

    private float getSteamProcessingSpeed(FluidApi.SingleSlotStorage usedTank) {
        float fillPercentage = (float)usedTank.getStack().getAmount() / (float)usedTank.getCapacity();
        return fillPercentage * 10.0f;
    }

    @Override
    protected float getAnimationSpeed() {
        if (this.progress == 0) {
            return 1.0f;
        }
        return (float)this.progress / 100.0f;
    }

    @Override
    public ScreenProvider.BarConfiguration getFluidConfiguration() {
        return new ScreenProvider.BarConfiguration(149, 10, 18, 64);
    }

    @Override
    protected OritechRecipeType getOwnRecipeType() {
        return RecipeContent.STEAM_ENGINE;
    }

    @Override
    public InventorySlotAssignment getSlotAssignments() {
        return new InventorySlotAssignment(0, 0, 0, 0);
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of();
    }

    @Override
    public class_3917<?> getScreenHandlerType() {
        return ModScreens.STEAM_ENGINE_SCREEN;
    }

    @Override
    public int getInventorySize() {
        return 0;
    }

    @Override
    public long getDefaultCapacity() {
        return Oritech.CONFIG.generators.steamEngineData.energyCapacity();
    }

    @Override
    public long getDefaultExtractionRate() {
        return Oritech.CONFIG.generators.steamEngineData.maxEnergyExtraction();
    }

    @Override
    protected Set<class_3545<class_2338, class_2350>> getOutputTargets(class_2338 pos, class_1937 world) {
        HashSet<class_3545<class_2338, class_2350>> res = new HashSet<class_3545<class_2338, class_2350>>();
        class_2350 facing = this.getFacingForAddon();
        class_2382 posA = new class_2382(0, 0, 1);
        class_2382 posB = new class_2382(-1, 0, 0);
        class_2382 posC = new class_2382(1, 0, 0);
        class_2382 posD = new class_2382(-1, 0, -1);
        class_2382 posE = new class_2382(1, 0, -1);
        class_2382 posF = new class_2382(0, 0, -2);
        class_2338 worldPosA = (class_2338)Geometry.offsetToWorldPosition(facing, posA, (class_2382)pos);
        class_2338 worldPosB = (class_2338)Geometry.offsetToWorldPosition(facing, posB, (class_2382)pos);
        class_2338 worldPosC = (class_2338)Geometry.offsetToWorldPosition(facing, posC, (class_2382)pos);
        class_2338 worldPosD = (class_2338)Geometry.offsetToWorldPosition(facing, posD, (class_2382)pos);
        class_2338 worldPosE = (class_2338)Geometry.offsetToWorldPosition(facing, posE, (class_2382)pos);
        class_2338 worldPosF = (class_2338)Geometry.offsetToWorldPosition(facing, posF, (class_2382)pos);
        res.add(new class_3545((Object)worldPosA, (Object)Geometry.fromVector(Geometry.getForward(facing))));
        res.add(new class_3545((Object)worldPosB, (Object)Geometry.fromVector(Geometry.getLeft(facing))));
        res.add(new class_3545((Object)worldPosC, (Object)Geometry.fromVector(Geometry.getRight(facing))));
        res.add(new class_3545((Object)worldPosD, (Object)Geometry.fromVector(Geometry.getLeft(facing))));
        res.add(new class_3545((Object)worldPosE, (Object)Geometry.fromVector(Geometry.getRight(facing))));
        res.add(new class_3545((Object)worldPosF, (Object)Geometry.fromVector(Geometry.getBackward(facing))));
        return res;
    }

    @Override
    public List<class_2382> getAddonSlots() {
        return List.of();
    }

    @Override
    public List<class_2382> getCorePositions() {
        return List.of(new class_2382(0, 1, 0), new class_2382(0, 0, -1), new class_2382(0, 1, -1));
    }

    @Override
    public boolean showProgress() {
        return false;
    }

    @Override
    public FluidApi.FluidStorage getFluidStorage(@Nullable class_2350 direction) {
        if (this.inSlaveMode()) {
            return this.master.boilerStorage.getStorageForDirection(direction);
        }
        return this.boilerStorage.getStorageForDirection(direction);
    }

    public static class_3611 getUsedSteamFluid() {
        if (USED_STEAM_FLUID == null) {
            USED_STEAM_FLUID = (class_3611)class_7923.field_41173.method_10223(class_2960.method_60654((String)Oritech.CONFIG.generators.steamId()));
        }
        return USED_STEAM_FLUID;
    }

    public record SteamEngineSyncPacket(class_2338 position, float speed, float efficiency, long energyProduced, long steamConsumed, int slaves) {
    }
}

