/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.interaction;

import com.mojang.serialization.DynamicOps;
import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3917;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.DynamicEnergyStorage;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.api.fluid.containers.SimpleFluidStorage;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.item.containers.SimpleInventoryStorage;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.base.block.MultiblockMachine;
import rearth.oritech.block.base.entity.MachineBlockEntity;
import rearth.oritech.block.blocks.interaction.DronePortBlock;
import rearth.oritech.block.blocks.processing.MachineCoreBlock;
import rearth.oritech.block.entity.MachineCoreEntity;
import rearth.oritech.block.entity.addons.RedstoneAddonBlockEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.ui.DroneScreenHandler;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.ComponentContent;
import rearth.oritech.item.tools.LaserTargetDesignator;
import rearth.oritech.util.AutoPlayingSoundKeyframeHandler;
import rearth.oritech.util.ComparatorOutputProvider;
import rearth.oritech.util.Geometry;
import rearth.oritech.util.InventoryInputMode;
import rearth.oritech.util.MachineAddonController;
import rearth.oritech.util.MultiblockMachineController;
import rearth.oritech.util.ScreenProvider;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DronePortEntity
extends NetworkedBlockEntity
implements ItemApi.BlockProvider,
FluidApi.BlockProvider,
EnergyApi.BlockProvider,
GeoBlockEntity,
MultiblockMachineController,
MachineAddonController,
ExtendedMenuProvider,
ScreenProvider,
RedstoneAddonBlockEntity.RedstoneControllable {
    @SyncField(value={SyncType.GUI_OPEN})
    private final List<class_2338> connectedAddons = new ArrayList<class_2338>();
    @SyncField(value={SyncType.GUI_OPEN})
    private final List<class_2338> openSlots = new ArrayList<class_2338>();
    @SyncField(value={SyncType.GUI_OPEN})
    private MachineAddonController.BaseAddonData addonData = MachineAddonController.DEFAULT_ADDON_DATA;
    @SyncField(value={SyncType.GUI_OPEN, SyncType.GUI_TICK})
    protected final DynamicEnergyStorage energyStorage = new DynamicEnergyStorage(32768L, 10000L, 0L, this::method_5431);
    public final DronePortItemInventory inventory = new DronePortItemInventory(15, this::method_5431);
    @SyncField(value={SyncType.GUI_TICK})
    public final DronePortFluidStorage fluidStorage = new DronePortFluidStorage(128L * FluidStackHooks.bucketAmount(), this::method_5431);
    protected final class_1277 cardInventory = new class_1277(2){

        public void method_5431() {
            DronePortEntity.this.method_5431();
        }

        public boolean method_27070(class_1799 stack) {
            return stack.method_7909() instanceof LaserTargetDesignator;
        }
    };
    @SyncField(value={SyncType.GUI_OPEN})
    private float coreQuality = 1.0f;
    protected final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final ArrayList<class_2338> coreBlocksConnected = new ArrayList();
    @SyncField(value={SyncType.GUI_OPEN})
    public boolean hasFluidAddon;
    @SyncField(value={SyncType.GUI_OPEN})
    public boolean disabledViaRedstone;
    private class_2338 targetPosition;
    private long lastSentAt;
    private DroneTransferData incomingPacket;
    private boolean receivingPackage;
    private final long baseEnergyUsage = 1024L;
    private final int takeOffTime = 300;
    private final int landTime = 260;
    private final int totalFlightTime = 560;
    @SyncField(value={SyncType.GUI_TICK})
    private String statusMessage = "";
    public static final RawAnimation TAKEOFF = RawAnimation.begin().thenPlay("takeoff");
    public static final RawAnimation LANDING = RawAnimation.begin().thenPlay("landing");

    public DronePortEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.DRONE_PORT_ENTITY, pos, state);
    }

    @Override
    public void serverTick(class_1937 world, class_2338 pos, class_2680 state, NetworkedBlockEntity blockEntity) {
        this.checkPositionCard();
        if (this.incomingPacket != null) {
            this.checkIncomingAnimation();
        }
        if (world.method_8510() % 20L == 0L) {
            if (this.incomingPacket != null) {
                this.tryReceivePacket();
            } else if (this.canSend()) {
                this.sendDrone();
            }
        }
    }

    private void checkPositionCard() {
        class_1799 source = (class_1799)this.cardInventory.method_54454().get(0);
        if (!(source.method_7909() instanceof LaserTargetDesignator) || !source.method_57826(ComponentContent.TARGET_POSITION.get())) {
            return;
        }
        class_2338 target = (class_2338)source.method_57824(ComponentContent.TARGET_POSITION.get());
        this.setTargetFromDesignator(target);
        this.cardInventory.method_54454().set(1, (Object)source);
        this.cardInventory.method_54454().set(0, (Object)class_1799.field_8037);
        this.cardInventory.method_5431();
        this.method_5431();
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_1262.method_5427((class_2487)nbt, this.inventory.getHeldStacks(), (boolean)false, (class_7225.class_7874)registryLookup);
        this.addMultiblockToNbt(nbt);
        this.writeAddonToNbt(nbt);
        this.fluidStorage.writeNbt(nbt, "");
        nbt.method_10556("has_fluid_addon", this.hasFluidAddon);
        nbt.method_10556("disabled_via_redstone", this.disabledViaRedstone);
        nbt.method_10544("energy_stored", this.energyStorage.amount);
        if (this.targetPosition != null) {
            nbt.method_10544("target_position", this.targetPosition.method_10063());
        }
        class_2487 cardCompound = new class_2487();
        class_1262.method_5427((class_2487)cardCompound, (class_2371)this.cardInventory.method_54454(), (boolean)false, (class_7225.class_7874)registryLookup);
        nbt.method_10566("cards", (class_2520)cardCompound);
        if (this.incomingPacket != null) {
            class_2487 compound = new class_2487();
            class_2371 list = class_2371.method_37434((int)this.incomingPacket.transferredStacks.size());
            list.addAll(this.incomingPacket.transferredStacks);
            class_1262.method_5427((class_2487)compound, (class_2371)list, (boolean)false, (class_7225.class_7874)registryLookup);
            nbt.method_10566("incoming", (class_2520)compound);
            FluidStack.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.incomingPacket.movedFluid).result().ifPresent(tag -> nbt.method_10566("fluidmoving", tag));
            nbt.method_10544("incomingTime", this.incomingPacket.arrivesAt);
        } else {
            nbt.method_10551("incoming");
        }
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        class_1262.method_5429((class_2487)nbt, this.inventory.getHeldStacks(), (class_7225.class_7874)registryLookup);
        this.loadMultiblockNbtData(nbt);
        this.loadAddonNbtData(nbt);
        this.fluidStorage.readNbt(nbt, "");
        this.hasFluidAddon = nbt.method_10577("has_fluid_addon");
        this.disabledViaRedstone = nbt.method_10577("disabled_via_redstone");
        this.energyStorage.amount = nbt.method_10537("energy_stored");
        this.targetPosition = class_2338.method_10092((long)nbt.method_10537("target_position"));
        class_1262.method_5429((class_2487)nbt.method_10562("cards"), (class_2371)this.cardInventory.method_54454(), (class_7225.class_7874)registryLookup);
        if (nbt.method_10545("incoming")) {
            class_2371 list = class_2371.method_10213((int)15, (Object)class_1799.field_8037);
            class_1262.method_5429((class_2487)nbt.method_10562("incoming"), (class_2371)list, (class_7225.class_7874)registryLookup);
            FluidStack fluid = FluidStack.CODEC.parse((DynamicOps)class_2509.field_11560, (Object)nbt.method_10580("fluidmoving")).result().orElse(FluidStack.empty());
            long arrivalTime = nbt.method_10537("incomingTime");
            this.incomingPacket = new DroneTransferData((List<class_1799>)list, fluid, arrivalTime);
        }
    }

    @Override
    public void initAddons() {
        MachineAddonController.super.initAddons();
        this.field_11863.method_8408(this.field_11867, this.method_11010().method_26204());
        for (class_2382 corePosition : this.getCorePositions()) {
            class_2338 worldPos = new class_2338(Geometry.offsetToWorldPosition(this.getFacingForMultiblock(), corePosition, (class_2382)this.getPosForAddon()));
            this.field_11863.method_8408(worldPos, this.field_11863.method_8320(worldPos).method_26204());
        }
    }

    @Override
    public void getAdditionalStatFromAddon(MachineAddonController.AddonBlock addonBlock) {
        if (addonBlock.state().method_26204().equals(BlockContent.MACHINE_FLUID_ADDON)) {
            this.hasFluidAddon = true;
        }
    }

    @Override
    public void resetAddons() {
        MachineAddonController.super.resetAddons();
        this.hasFluidAddon = false;
    }

    private void checkIncomingAnimation() {
        if (this.field_11863.method_8510() == this.incomingPacket.arrivesAt - 260L) {
            this.triggerNetworkReceiveAnimation();
        }
    }

    private void tryReceivePacket() {
        boolean hasArrived;
        boolean bl = hasArrived = this.field_11863.method_8510() - this.incomingPacket.arrivesAt > 0L;
        if (!hasArrived) {
            return;
        }
        Oritech.LOGGER.debug("receiving drone package: " + String.valueOf(this.incomingPacket));
        this.receivingPackage = true;
        long totalToInsert = this.incomingPacket.transferredStacks.stream().mapToLong(class_1799::method_7947).sum();
        long totalInserted = 0L;
        for (class_1799 stack : this.incomingPacket.transferredStacks) {
            totalInserted += (long)this.inventory.insert(stack, false);
        }
        if (totalInserted != totalToInsert) {
            Oritech.LOGGER.warn("Something weird has happened with drone port item storage. Caused at: " + String.valueOf(this.field_11867));
            return;
        }
        if (!this.incomingPacket.movedFluid.isEmpty()) {
            this.fluidStorage.insertFromDrone(this.incomingPacket.movedFluid, false);
        }
        this.receivingPackage = false;
        this.incomingPacket = null;
        this.method_5431();
    }

    private void sendDrone() {
        DronePortEntity targetPort = (DronePortEntity)this.field_11863.method_8321(this.targetPosition);
        long arriveTime = this.field_11863.method_8510() + 300L + 260L;
        DroneTransferData data = new DroneTransferData(this.inventory.getHeldStacks().stream().filter(stack -> !stack.method_7960()).toList(), this.fluidStorage.getStack(), arriveTime);
        targetPort.setIncomingPacket(data);
        this.inventory.method_5448();
        this.fluidStorage.setStack(FluidStack.empty());
        this.lastSentAt = this.field_11863.method_8510();
        this.energyStorage.amount -= this.calculateEnergyUsage();
        this.triggerNetworkSendAnimation();
        targetPort.method_5431();
        this.method_5431();
        Oritech.LOGGER.debug("sending drone package: " + String.valueOf(data));
    }

    public boolean canAcceptPayload(List<class_1799> stacks, FluidStack fluid) {
        if (!stacks.isEmpty() && !this.inventory.method_5442()) {
            return false;
        }
        return fluid.isEmpty() || this.hasFluidAddon && this.fluidStorage.insert(fluid, true) == fluid.getAmount();
    }

    public boolean isSendingDrone() {
        long diff = this.field_11863.method_8510() - this.lastSentAt;
        return diff < 300L;
    }

    private boolean canSend() {
        block5: {
            block4: {
                if (this.disabledViaRedstone || this.targetPosition == null || this.inventory.method_5442() && this.fluidStorage.getAmount() == 0L || this.energyStorage.amount < this.calculateEnergyUsage() || this.incomingPacket != null) {
                    return false;
                }
                class_2586 targetEntity = this.field_11863.method_8321(this.targetPosition);
                if (!(targetEntity instanceof DronePortEntity)) break block4;
                DronePortEntity targetPort = (DronePortEntity)targetEntity;
                if (!targetPort.disabledViaRedstone && targetPort.getIncomingPacket() == null && targetPort.canAcceptPayload((List<class_1799>)this.inventory.getHeldStacks(), this.fluidStorage.getStack())) break block5;
            }
            return false;
        }
        return !this.isSendingDrone();
    }

    private long calculateEnergyUsage() {
        if (this.targetPosition == null) {
            return 1024L;
        }
        int distance = this.field_11867.method_19455((class_2382)this.targetPosition);
        return (long)Math.sqrt(distance) * 50L + 1024L;
    }

    private void triggerNetworkSendAnimation() {
        this.triggerAnim("machine", "takeoff");
    }

    private void triggerNetworkReceiveAnimation() {
        this.triggerAnim("machine", "landing");
    }

    public boolean setTargetFromDesignator(class_2338 targetPos) {
        int distance;
        MachineCoreEntity coreEntity;
        class_2338 controllerPos;
        class_2680 targetState = Objects.requireNonNull(this.field_11863).method_8320(targetPos);
        if (targetState.method_26204() instanceof MachineCoreBlock && ((Boolean)targetState.method_11654((class_2769)MachineCoreBlock.USED)).booleanValue() && (controllerPos = Objects.requireNonNull(coreEntity = (MachineCoreEntity)this.field_11863.method_8321(targetPos)).getControllerPos()) != null) {
            targetPos = controllerPos;
        }
        if ((distance = targetPos.method_19455((class_2382)this.field_11867)) < 50) {
            this.statusMessage = "message.oritech.drone.invalid_distance";
            return false;
        }
        if (this.field_11863.method_8320(targetPos).method_26204() instanceof DronePortBlock) {
            this.targetPosition = targetPos;
            this.statusMessage = "message.oritech.drone.target_set";
            return true;
        }
        this.statusMessage = "message.oritech.drone.target_invalid";
        return false;
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorage(class_2350 direction) {
        return this.energyStorage;
    }

    @Override
    public ItemApi.InventoryStorage getInventoryStorage(class_2350 direction) {
        return this.inventory;
    }

    @Override
    public List<class_2382> getCorePositions() {
        return List.of(new class_2382(0, 0, 1), new class_2382(0, 0, -1), new class_2382(-1, 0, 1), new class_2382(-1, 0, 0), new class_2382(-1, 0, -1), new class_2382(-2, 0, 1), new class_2382(-2, 0, 0), new class_2382(-2, 0, -1), new class_2382(0, 1, 0), new class_2382(0, 1, 1), new class_2382(-1, 1, -1));
    }

    @Override
    public class_2350 getFacingForMultiblock() {
        return ((class_2350)Objects.requireNonNull(this.field_11863).method_8320(this.method_11016()).method_11654((class_2769)class_2741.field_12481)).method_10153();
    }

    @Override
    public class_2338 getPosForAddon() {
        return this.field_11867;
    }

    @Override
    public class_1937 getWorldForAddon() {
        return this.field_11863;
    }

    @Override
    public ArrayList<class_2338> getConnectedCores() {
        return this.coreBlocksConnected;
    }

    @Override
    public void setCoreQuality(float quality) {
        this.coreQuality = quality;
    }

    @Override
    public float getCoreQuality() {
        return this.coreQuality;
    }

    @Override
    public ItemApi.InventoryStorage getInventoryForMultiblock() {
        return this.inventory;
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorageForMultiblock(class_2350 direction) {
        return this.energyStorage;
    }

    @Override
    @Nullable
    public FluidApi.FluidStorage getFluidStorage(class_2350 direction) {
        return this.hasFluidAddon ? this.fluidStorage : null;
    }

    @Override
    public List<class_2382> getAddonSlots() {
        return List.of(new class_2382(3, 0, -1), new class_2382(2, 0, -2));
    }

    @Override
    public long getDefaultCapacity() {
        return 32768L;
    }

    @Override
    public long getDefaultInsertRate() {
        return 512L;
    }

    @Override
    public ItemApi.InventoryStorage getInventoryForAddon() {
        return this.inventory;
    }

    @Override
    public ScreenProvider getScreenProvider() {
        return this;
    }

    public DynamicEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    @Override
    public List<class_2338> getConnectedAddons() {
        return this.connectedAddons;
    }

    @Override
    public List<class_2338> getOpenAddonSlots() {
        return this.openSlots;
    }

    @Override
    public class_2350 getFacingForAddon() {
        return (class_2350)Objects.requireNonNull(this.field_11863).method_8320(this.method_11016()).method_11654((class_2769)class_2741.field_12481);
    }

    @Override
    public DynamicEnergyStorage getStorageForAddon() {
        return this.getEnergyStorage();
    }

    @Override
    public MachineAddonController.BaseAddonData getBaseAddonData() {
        return this.addonData;
    }

    @Override
    public void setBaseAddonData(MachineAddonController.BaseAddonData data) {
        this.addonData = data;
        this.method_5431();
    }

    public DroneTransferData getIncomingPacket() {
        return this.incomingPacket;
    }

    public void setIncomingPacket(DroneTransferData incomingPacket) {
        this.incomingPacket = incomingPacket;
    }

    public boolean isActive(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)MultiblockMachine.ASSEMBLED);
    }

    @Override
    public void triggerSetupAnimation() {
        this.triggerAnim("machine", "deploy");
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "machine", 0, state -> {
            if (state.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
                RawAnimation targetAnim = this.isActive(this.method_11010()) ? MachineBlockEntity.IDLE : MachineBlockEntity.PACKAGED;
                state.resetCurrentAnimation();
                return state.setAndContinue(targetAnim);
            }
            return PlayState.CONTINUE;
        }).triggerableAnim("takeoff", TAKEOFF).triggerableAnim("landing", LANDING).triggerableAnim("deploy", MachineBlockEntity.SETUP).setSoundKeyframeHandler(new AutoPlayingSoundKeyframeHandler()));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    @Override
    public int getComparatorEnergyAmount() {
        return (int)((float)this.energyStorage.amount / (float)this.energyStorage.capacity * 15.0f);
    }

    @Override
    public int getComparatorSlotAmount(int slot) {
        if (this.inventory.getHeldStacks().size() <= slot) {
            return this.hasFluidAddon ? ComparatorOutputProvider.getFluidStorageComparatorOutput(this.fluidStorage) : 0;
        }
        class_1799 stack = this.inventory.method_5438(slot);
        if (stack.method_7960()) {
            return this.hasFluidAddon ? ComparatorOutputProvider.getFluidStorageComparatorOutput(this.fluidStorage) : 0;
        }
        return this.hasFluidAddon ? Math.max(ComparatorOutputProvider.getItemStackComparatorOutput(stack), ComparatorOutputProvider.getFluidStorageComparatorOutput(this.fluidStorage)) : ComparatorOutputProvider.getItemStackComparatorOutput(stack);
    }

    @Override
    public int getComparatorProgress() {
        if (this.isSendingDrone()) {
            return (int)((float)(this.field_11863.method_8510() - this.lastSentAt) / 300.0f * 15.0f);
        }
        if (this.incomingPacket != null) {
            return (int)((float)(560L + (this.field_11863.method_8510() - this.incomingPacket.arrivesAt)) / 560.0f * 15.0f);
        }
        return 0;
    }

    @Override
    public int getComparatorActiveState() {
        return this.isSendingDrone() || this.incomingPacket != null ? 15 : 0;
    }

    @Override
    public void onRedstoneEvent(boolean isPowered) {
        this.disabledViaRedstone = isPowered;
    }

    @Override
    public int receivedRedstoneSignal() {
        if (this.disabledViaRedstone) {
            return 15;
        }
        return 0;
    }

    @Override
    public String currentRedstoneEffect() {
        if (this.disabledViaRedstone) {
            return "tooltip.oritech.redstone_disabled";
        }
        return "tooltip.oritech.redstone_enabled";
    }

    @Override
    public boolean hasRedstoneControlAvailable() {
        return true;
    }

    public void saveExtraData(class_2540 buf) {
        this.sendUpdate(SyncType.GUI_OPEN);
        buf.method_10807(this.field_11867);
    }

    public class_2561 method_5476() {
        return class_2561.method_30163((String)"");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new DroneScreenHandler(syncId, playerInventory, this);
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        int startX = 30;
        int startY = 26;
        int distance = 18;
        ArrayList<ScreenProvider.GuiSlot> list = new ArrayList<ScreenProvider.GuiSlot>();
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 5; ++x) {
                int index = y * 5 + x;
                list.add(new ScreenProvider.GuiSlot(index, startX + x * distance, startY + y * distance));
            }
        }
        return list;
    }

    @Override
    public float getDisplayedEnergyUsage() {
        return this.calculateEnergyUsage();
    }

    @Override
    public float getDisplayedEnergyTransfer() {
        return this.energyStorage.maxInsert;
    }

    @Override
    public float getProgress() {
        return 0.0f;
    }

    @Override
    public InventoryInputMode getInventoryInputMode() {
        return InventoryInputMode.FILL_LEFT_TO_RIGHT;
    }

    @Override
    public class_1263 getDisplayedInventory() {
        return this.inventory;
    }

    @Override
    public class_3917<?> getScreenHandlerType() {
        return ModScreens.DRONE_SCREEN;
    }

    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }

    @Override
    public boolean showProgress() {
        return false;
    }

    public class_1277 getCardInventory() {
        return this.cardInventory;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    @Override
    public class_2338 getPosForMultiblock() {
        return this.field_11867;
    }

    @Override
    public class_1937 getWorldForMultiblock() {
        return this.field_11863;
    }

    public class DronePortItemInventory
    extends SimpleInventoryStorage {
        public DronePortItemInventory(int size, Runnable onUpdate) {
            super(size, onUpdate);
        }

        @Override
        public int insertToSlot(class_1799 addedStack, int slot, boolean simulate) {
            if (DronePortEntity.this.incomingPacket != null && !DronePortEntity.this.receivingPackage) {
                return 0;
            }
            return super.insertToSlot(addedStack, slot, simulate);
        }
    }

    public class DronePortFluidStorage
    extends SimpleFluidStorage {
        public DronePortFluidStorage(Long capacity, Runnable onUpdate) {
            super(capacity, onUpdate);
        }

        @Override
        public long insert(FluidStack toInsert, boolean simulate) {
            if (DronePortEntity.this.incomingPacket != null) {
                return 0L;
            }
            return super.insert(toInsert, simulate);
        }

        public long insertFromDrone(FluidStack toInsert, boolean simulate) {
            return super.insert(toInsert, simulate);
        }
    }

    public record DroneTransferData(List<class_1799> transferredStacks, FluidStack movedFluid, long arrivesAt) {
    }
}

