/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.interaction;

import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_5558;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.DynamicEnergyStorage;
import rearth.oritech.block.entity.pipes.GenericPipeInterfaceEntity;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.util.AutoPlayingSoundKeyframeHandler;
import rearth.oritech.util.Geometry;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PipeBoosterBlockEntity
extends class_2586
implements class_5558<PipeBoosterBlockEntity>,
GeoBlockEntity,
EnergyApi.BlockProvider {
    protected final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected final DynamicEnergyStorage energyStorage = new DynamicEnergyStorage(50000L, 4000L, 0L, () -> ((PipeBoosterBlockEntity)this).method_5431());
    public static final RawAnimation EXPAND = RawAnimation.begin().thenPlayAndHold("expand");
    public static final RawAnimation RETRACT = RawAnimation.begin().thenPlayAndHold("retract");
    public static final RawAnimation EXTENDED = RawAnimation.begin().thenPlay("extended");
    public static final RawAnimation RETRACTED = RawAnimation.begin().thenPlay("retracted");
    public static final RawAnimation WORK = RawAnimation.begin().thenPlay("work");
    private static final int BOOST_ENERGY_COST = 32;
    private boolean setPipe;

    public PipeBoosterBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.PIPE_BOOSTER_BLOCK_ENTITY, pos, state);
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, PipeBoosterBlockEntity blockEntity) {
        class_2338 targetPos;
        class_2586 candidate;
        if (world.field_9236) {
            return;
        }
        if (!this.setPipe && (world.method_8510() & 0x19L) == 0L && (candidate = world.method_8321(targetPos = pos.method_10081(Geometry.getBackward((class_2350)state.method_11654((class_2769)class_2741.field_12481))))) instanceof GenericPipeInterfaceEntity) {
            GenericPipeInterfaceEntity pipe = (GenericPipeInterfaceEntity)candidate;
            pipe.connectedBooster = pos;
            this.setPipe = true;
            this.triggerAnim("machine", "expand");
        }
        if (world.method_8510() % 42L == 0L) {
            if (this.setPipe) {
                this.triggerAnim("machine", "extended");
            } else {
                this.triggerAnim("machine", "retracted");
            }
        }
    }

    public boolean canUseBoost() {
        return this.energyStorage.amount >= 32L;
    }

    public void useBoost() {
        if (!this.canUseBoost()) {
            return;
        }
        this.energyStorage.amount -= 32L;
        this.method_5431();
        this.triggerAnim("machine", "work");
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10544("energy_stored", this.energyStorage.amount);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.energyStorage.amount = nbt.method_10537("energy_stored");
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "machine", 5, state -> PlayState.CONTINUE).triggerableAnim("work", WORK).triggerableAnim("extended", EXTENDED).triggerableAnim("retracted", RETRACTED).triggerableAnim("expand", EXPAND).triggerableAnim("retract", RETRACT).setSoundKeyframeHandler(new AutoPlayingSoundKeyframeHandler()));
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorage(@Nullable class_2350 direction) {
        return this.energyStorage;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }
}

