/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.pipes;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_7225;
import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.SimpleEnergyStorage;
import rearth.oritech.block.blocks.pipes.energy.EnergyPipeBlock;
import rearth.oritech.block.blocks.pipes.energy.SuperConductorBlock;
import rearth.oritech.block.entity.pipes.GenericPipeInterfaceEntity;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.BlockEntitiesContent;

public class EnergyPipeInterfaceEntity
extends GenericPipeInterfaceEntity
implements EnergyApi.BlockProvider {
    private final SimpleEnergyStorage energyStorage;
    private final boolean isSuperConductor;
    private List<EnergyApi.EnergyStorage> cachedTargets = List.of();
    private int cacheHash;

    public EnergyPipeInterfaceEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.ENERGY_PIPE_ENTITY, pos, state);
        this.isSuperConductor = state.method_26204().equals(BlockContent.SUPERCONDUCTOR_CONNECTION) || state.method_26204().equals(BlockContent.FRAMED_SUPERCONDUCTOR_CONNECTION);
        this.energyStorage = this.isSuperConductor ? new SimpleEnergyStorage(Oritech.CONFIG.superConductorTransferRate(), Oritech.CONFIG.superConductorTransferRate(), Oritech.CONFIG.superConductorTransferRate()) : new SimpleEnergyStorage(Oritech.CONFIG.energyPipeTransferRate(), Oritech.CONFIG.energyPipeTransferRate(), Oritech.CONFIG.energyPipeTransferRate());
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10544("energy", this.energyStorage.getAmount());
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.energyStorage.setAmount(nbt.method_10537("energy"));
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorage(class_2350 direction) {
        return this.energyStorage;
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, GenericPipeInterfaceEntity blockEntity) {
        List<EnergyApi.EnergyStorage> energyStorages;
        if (world.field_9236 || this.energyStorage.getAmount() <= 0L) {
            return;
        }
        HashMap<class_2960, GenericPipeInterfaceEntity.PipeNetworkData> dataSource = this.isSuperConductor ? SuperConductorBlock.SUPERCONDUCTOR_DATA : EnergyPipeBlock.ENERGY_PIPE_DATA;
        GenericPipeInterfaceEntity.PipeNetworkData data = dataSource.getOrDefault(world.method_27983().method_29177(), new GenericPipeInterfaceEntity.PipeNetworkData());
        Set<class_3545<class_2338, class_2350>> targets = EnergyPipeInterfaceEntity.findNetworkTargets(pos, data);
        if (targets == null) {
            return;
        }
        int targetHash = targets.hashCode();
        if (this.cacheHash == targetHash) {
            energyStorages = this.cachedTargets;
        } else {
            this.cachedTargets = energyStorages = targets.stream().map(target -> EnergyApi.BLOCK.find(world, (class_2338)target.method_15442(), (class_2350)target.method_15441())).filter(obj -> Objects.nonNull(obj) && obj.supportsInsertion()).collect(Collectors.toList());
            this.cacheHash = targetHash;
        }
        Collections.shuffle(energyStorages);
        for (EnergyApi.EnergyStorage targetStorage : energyStorages) {
            if (this.energyStorage.getAmount() <= 0L) break;
            EnergyApi.transfer(this.energyStorage, targetStorage, Long.MAX_VALUE, false);
        }
    }

    public void method_5431() {
        if (this.field_11863 != null) {
            this.field_11863.method_8524(this.field_11867);
        }
    }
}

