/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.pipes;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2503;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3545;
import net.minecraft.class_5558;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.block.blocks.pipes.AbstractPipeBlock;
import rearth.oritech.block.blocks.pipes.GenericPipeBlock;
import rearth.oritech.block.entity.interaction.PipeBoosterBlockEntity;

public abstract class GenericPipeInterfaceEntity
extends class_2586
implements class_5558<GenericPipeInterfaceEntity> {
    public static final int MAX_SEARCH_COUNT = 2048;
    public class_2338 connectedBooster = class_2338.field_10980;
    private PipeBoosterBlockEntity cachedBooster;

    public GenericPipeInterfaceEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public boolean isBoostAvailable() {
        PipeBoosterBlockEntity booster = this.tryGetCachedBooster();
        return booster != null && booster.canUseBoost();
    }

    public void onBoostUsed() {
        PipeBoosterBlockEntity booster = this.tryGetCachedBooster();
        if (booster != null) {
            booster.useBoost();
        }
    }

    @Nullable
    private PipeBoosterBlockEntity tryGetCachedBooster() {
        if (this.cachedBooster != null && this.cachedBooster.method_11015()) {
            this.cachedBooster = null;
            this.connectedBooster = class_2338.field_10980;
            return null;
        }
        if (this.connectedBooster == class_2338.field_10980) {
            if (this.cachedBooster != null) {
                this.cachedBooster = null;
            }
            return null;
        }
        if (this.cachedBooster == null) {
            class_2586 candidate = Objects.requireNonNull(this.field_11863).method_8321(this.connectedBooster);
            if (candidate instanceof PipeBoosterBlockEntity) {
                PipeBoosterBlockEntity booster;
                this.cachedBooster = booster = (PipeBoosterBlockEntity)candidate;
                return this.cachedBooster;
            }
            this.connectedBooster = class_2338.field_10980;
            return null;
        }
        return this.cachedBooster;
    }

    public static void addNode(class_1937 world, class_2338 pos, boolean isInterface, class_2680 newState, PipeNetworkData data) {
        Oritech.LOGGER.debug("registering/updating node: " + String.valueOf(pos));
        data.pipes.add(pos);
        HashSet<class_2338> connectedMachines = new HashSet<class_2338>(6);
        AbstractPipeBlock block = (AbstractPipeBlock)newState.method_26204();
        for (class_2350 neighbor : class_2350.values()) {
            class_2338 neighborPos = pos.method_10093(neighbor);
            Set neighborMap = data.machinePipeNeighbors.getOrDefault(neighborPos, new HashSet());
            if (block.hasMachineInDirection(neighbor, world, pos, block.apiValidationFunction())) {
                if (block.isConnectingInDirection(newState, neighbor, pos, world, false)) {
                    connectedMachines.add(pos.method_10093(neighbor));
                }
                neighborMap.add(neighbor.method_10153());
            } else {
                neighborMap.remove(neighbor.method_10153());
            }
            if (!neighborMap.isEmpty()) {
                data.machinePipeNeighbors.put(neighborPos, neighborMap);
                continue;
            }
            data.machinePipeNeighbors.remove(neighborPos);
        }
        if (isInterface) {
            data.machineInterfaces.put(pos, connectedMachines);
        } else {
            data.machineInterfaces.remove(pos);
        }
        GenericPipeInterfaceEntity.updateFromNode(world, pos, data);
    }

    public static void removeNode(class_1937 world, class_2338 pos, boolean wasInterface, class_2680 oldState, PipeNetworkData data) {
        Oritech.LOGGER.debug("removing node: " + String.valueOf(pos) + " | " + wasInterface);
        Integer oldNetwork = data.pipeNetworkLinks.getOrDefault(pos, -1);
        data.pipes.remove(pos);
        if (wasInterface) {
            data.machineInterfaces.remove(pos);
        }
        GenericPipeInterfaceEntity.removeStaleMachinePipeNeighbors(pos, data);
        data.pipeNetworks.remove(oldNetwork);
        data.pipeNetworkInterfaces.remove(oldNetwork);
        data.pipeNetworkLinks.remove(pos);
        if (oldNetwork != -1) {
            class_2248 block = oldState.method_26204();
            for (class_2350 direction : class_2350.values()) {
                GenericPipeBlock pipeBlock;
                if (block instanceof GenericPipeBlock && (Integer)oldState.method_11654((class_2769)(pipeBlock = (GenericPipeBlock)block).directionToProperty(direction)) == GenericPipeBlock.NO_CONNECTION) continue;
                GenericPipeInterfaceEntity.updateFromNode(world, pos.method_10093(direction), data);
            }
        }
        data.method_80();
    }

    private static void updateFromNode(class_1937 world, class_2338 pos, PipeNetworkData data) {
        FloodFillSearch searchInstance = new FloodFillSearch(pos, data.pipes, world);
        HashSet<class_2338> foundNetwork = new HashSet<class_2338>(searchInstance.complete());
        Set<class_3545<class_2338, class_2350>> foundMachines = GenericPipeInterfaceEntity.findConnectedMachines(foundNetwork, data);
        Oritech.LOGGER.debug("Nodes:    " + foundNetwork.size() + " | " + String.valueOf(foundNetwork));
        Oritech.LOGGER.debug("Machines: " + foundMachines.size() + " | " + String.valueOf(foundMachines.stream().map(elem -> String.valueOf(elem.method_15442()) + ":" + String.valueOf(elem.method_15441())).toList()));
        int netID = foundNetwork.hashCode();
        data.pipeNetworks.put(netID, foundNetwork);
        data.pipeNetworkInterfaces.put(netID, foundMachines);
        HashSet<Integer> networksToRemove = new HashSet<Integer>();
        for (class_2338 node : foundNetwork) {
            networksToRemove.add(data.pipeNetworkLinks.getOrDefault(node, -1));
            data.pipeNetworkLinks.put(node, netID);
        }
        networksToRemove.stream().filter(i -> i != -1 && i != netID).forEach(i -> {
            data.pipeNetworks.remove(i);
            data.pipeNetworkInterfaces.remove(i);
        });
        data.method_80();
    }

    private static Set<class_3545<class_2338, class_2350>> findConnectedMachines(Set<class_2338> network, PipeNetworkData data) {
        HashSet<class_3545<class_2338, class_2350>> res = new HashSet<class_3545<class_2338, class_2350>>();
        for (class_2338 node : network) {
            if (!data.machineInterfaces.containsKey(node)) continue;
            for (class_2338 machinePos : data.machineInterfaces.get(node)) {
                class_2338 offset = machinePos.method_10059((class_2382)node);
                class_2350 direction = class_2350.method_50026((int)offset.method_10263(), (int)offset.method_10264(), (int)offset.method_10260()).method_10153();
                res.add((class_3545<class_2338, class_2350>)new class_3545((Object)machinePos, (Object)direction));
            }
        }
        return res;
    }

    public static Set<class_3545<class_2338, class_2350>> findNetworkTargets(class_2338 from, PipeNetworkData data) {
        Integer connectedNetwork = data.pipeNetworkLinks.getOrDefault(from, -1);
        if (connectedNetwork == -1) {
            return new HashSet<class_3545<class_2338, class_2350>>();
        }
        return data.pipeNetworkInterfaces.get(connectedNetwork);
    }

    public static void removeStaleMachinePipeNeighbors(class_2338 pos, PipeNetworkData data) {
        for (class_2350 neighbor : class_2350.values()) {
            class_2338 machine = pos.method_10093(neighbor);
            Set<class_2350> machineNeighbors = data.machinePipeNeighbors.get(machine);
            if (machineNeighbors == null) continue;
            machineNeighbors.remove(class_2350.method_58251((class_243)class_243.method_24954((class_2382)pos.method_10059((class_2382)machine))));
            if (machineNeighbors.isEmpty()) {
                data.machinePipeNeighbors.remove(machine);
                continue;
            }
            data.machinePipeNeighbors.put(machine, machineNeighbors);
        }
    }

    public static final class PipeNetworkData
    extends class_18 {
        public final HashMap<class_2338, Integer> pipeNetworkLinks = new HashMap();
        public final HashSet<class_2338> pipes = new HashSet();
        public final HashMap<class_2338, Set<class_2338>> machineInterfaces = new HashMap();
        public final HashMap<Integer, Set<class_2338>> pipeNetworks = new HashMap();
        public final HashMap<Integer, Set<class_3545<class_2338, class_2350>>> pipeNetworkInterfaces = new HashMap();
        public final HashMap<class_2338, Set<class_2350>> machinePipeNeighbors = new HashMap();
        public static class_18.class_8645<PipeNetworkData> TYPE = new class_18.class_8645(PipeNetworkData::new, PipeNetworkData::fromNbt, null);

        public int hashCode() {
            int result = this.pipeNetworkLinks.hashCode();
            result = 31 * result + this.pipes.hashCode();
            result = 31 * result + this.machineInterfaces.hashCode();
            result = 31 * result + this.pipeNetworks.hashCode();
            result = 31 * result + this.pipeNetworkInterfaces.hashCode();
            return result;
        }

        public static PipeNetworkData fromNbt(class_2487 nbt, class_7225.class_7874 registryLookup) {
            PipeNetworkData result = new PipeNetworkData();
            if (nbt.method_10573("pipeNetworkLinks", 9)) {
                class_2499 pipeNetworkLinksList = nbt.method_10554("pipeNetworkLinks", 10);
                for (class_2520 element2 : pipeNetworkLinksList) {
                    class_2487 entry = (class_2487)element2;
                    class_2338 pos = class_2338.method_10092((long)entry.method_10537("pos"));
                    int id = entry.method_10550("id");
                    result.pipeNetworkLinks.put(pos, id);
                }
            }
            if (nbt.method_10573("pipes", 9)) {
                class_2499 pipesList = nbt.method_10554("pipes", 4);
                pipesList.stream().map(element -> class_2338.method_10092((long)((class_2503)element).method_10699())).forEach(result.pipes::add);
            }
            if (nbt.method_10573("machineInterfaces", 10)) {
                class_2487 machineInterfacesNbt = nbt.method_10562("machineInterfaces");
                for (String key : machineInterfacesNbt.method_10541()) {
                    class_2338 interfacePos = class_2338.method_10092((long)Long.parseLong(key));
                    long[] machinesArray = machineInterfacesNbt.method_10565(key);
                    Set machines = Arrays.stream(machinesArray).mapToObj(class_2338::method_10092).collect(Collectors.toSet());
                    result.machineInterfaces.put(interfacePos, machines);
                }
            }
            if (nbt.method_10573("pipeNetworks", 10)) {
                class_2487 pipeNetworksNbt = nbt.method_10562("pipeNetworks");
                for (String key : pipeNetworksNbt.method_10541()) {
                    int id = Integer.parseInt(key);
                    long[] networkArray = pipeNetworksNbt.method_10565(key);
                    Set network = Arrays.stream(networkArray).mapToObj(class_2338::method_10092).collect(Collectors.toSet());
                    result.pipeNetworks.put(id, network);
                }
            }
            if (nbt.method_10573("pipeNetworkInterfaces", 10)) {
                class_2487 pipeNetworkInterfacesNbt = nbt.method_10562("pipeNetworkInterfaces");
                for (String key : pipeNetworkInterfacesNbt.method_10541()) {
                    int id = Integer.parseInt(key);
                    class_2499 interfacesList = pipeNetworkInterfacesNbt.method_10554(key, 10);
                    HashSet<class_3545> interfaces = new HashSet<class_3545>();
                    for (class_2520 interfaceElement : interfacesList) {
                        class_2487 pairNbt = (class_2487)interfaceElement;
                        class_2338 pos = class_2338.method_10092((long)pairNbt.method_10537("pos"));
                        class_2350 direction = class_2350.method_10168((String)pairNbt.method_10558("direction"));
                        interfaces.add(new class_3545((Object)pos, (Object)direction));
                    }
                    result.pipeNetworkInterfaces.put(id, interfaces);
                }
            }
            if (nbt.method_10573("machinePipeNeighbors", 10)) {
                class_2487 connectionPipeNeighborsNbt = nbt.method_10562("machinePipeNeighbors");
                for (String key : connectionPipeNeighborsNbt.method_10541()) {
                    class_2338 pos = class_2338.method_10092((long)Long.parseLong(key));
                    class_2499 neighborsList = connectionPipeNeighborsNbt.method_10554(key, 8);
                    HashSet<class_2350> neighbors = new HashSet<class_2350>();
                    for (class_2520 neighborElement : neighborsList) {
                        class_2350 direction = class_2350.method_10168((String)neighborElement.method_10714());
                        neighbors.add(direction);
                    }
                    result.machinePipeNeighbors.put(pos, neighbors);
                }
            }
            result.method_80();
            return result;
        }

        public class_2487 method_75(class_2487 nbt, class_7225.class_7874 registryLookup) {
            class_2499 pipeNetworkLinksList = new class_2499();
            this.pipeNetworkLinks.forEach((pos, id) -> {
                class_2487 entry = new class_2487();
                entry.method_10544("pos", pos.method_10063());
                entry.method_10569("id", id.intValue());
                pipeNetworkLinksList.add((Object)entry);
            });
            nbt.method_10566("pipeNetworkLinks", (class_2520)pipeNetworkLinksList);
            class_2499 pipesList = new class_2499();
            this.pipes.forEach(pos -> pipesList.add((Object)class_2503.method_23251((long)pos.method_10063())));
            nbt.method_10566("pipes", (class_2520)pipesList);
            class_2487 machineInterfacesNbt = new class_2487();
            this.machineInterfaces.forEach((interfacePos, machines) -> machineInterfacesNbt.method_10538(Long.toString(interfacePos.method_10063()), machines.stream().map(class_2338::method_10063).collect(Collectors.toList())));
            nbt.method_10566("machineInterfaces", (class_2520)machineInterfacesNbt);
            class_2487 pipeNetworksNbt = new class_2487();
            this.pipeNetworks.forEach((id, network) -> pipeNetworksNbt.method_10538(id.toString(), network.stream().map(class_2338::method_10063).collect(Collectors.toList())));
            nbt.method_10566("pipeNetworks", (class_2520)pipeNetworksNbt);
            class_2487 pipeNetworkInterfacesNbt = new class_2487();
            this.pipeNetworkInterfaces.forEach((id, interfaces) -> {
                class_2499 interfacesList = new class_2499();
                interfaces.forEach(pair -> {
                    class_2487 pairNbt = new class_2487();
                    pairNbt.method_10544("pos", ((class_2338)pair.method_15442()).method_10063());
                    pairNbt.method_10582("direction", ((class_2350)pair.method_15441()).method_10151());
                    interfacesList.add((Object)pairNbt);
                });
                pipeNetworkInterfacesNbt.method_10566(id.toString(), (class_2520)interfacesList);
            });
            nbt.method_10566("pipeNetworkInterfaces", (class_2520)pipeNetworkInterfacesNbt);
            class_2487 connectionPipeNeighborsNbt = new class_2487();
            this.machinePipeNeighbors.forEach((pos, neighbors) -> {
                class_2499 neighborsList = new class_2499();
                neighbors.forEach(direction -> {
                    class_2519 nbtElement = class_2519.method_23256((String)direction.method_10151());
                    neighborsList.add((Object)nbtElement);
                });
                connectionPipeNeighborsNbt.method_10566(Long.toString(pos.method_10063()), (class_2520)neighborsList);
            });
            nbt.method_10566("machinePipeNeighbors", (class_2520)connectionPipeNeighborsNbt);
            return nbt;
        }
    }

    private static class FloodFillSearch {
        final HashSet<class_2338> checkedPositions = new HashSet();
        final HashSet<class_2338> nextTargets = new HashSet();
        final Deque<class_2338> foundTargets = new ArrayDeque<class_2338>();
        final HashSet<class_2338> pipes;
        final class_1937 world;

        public FloodFillSearch(class_2338 startPosition, HashSet<class_2338> pipes, class_1937 world) {
            this.pipes = pipes;
            this.world = world;
            this.nextTargets.add(startPosition);
        }

        public Deque<class_2338> complete() {
            boolean active = true;
            while (active) {
                active = !this.nextGeneration();
            }
            return this.foundTargets;
        }

        public boolean nextGeneration() {
            HashSet currentGeneration = (HashSet)this.nextTargets.clone();
            for (class_2338 target : currentGeneration) {
                if (this.isValidTarget(target)) {
                    this.foundTargets.addLast(target);
                    this.addNeighborsToQueue(target);
                }
                this.checkedPositions.add(target);
                this.nextTargets.remove(target);
            }
            if (this.cutoffSearch()) {
                this.nextTargets.clear();
            }
            return this.nextTargets.isEmpty();
        }

        private boolean cutoffSearch() {
            return this.foundTargets.size() >= 2048;
        }

        private boolean isValidTarget(class_2338 target) {
            return this.pipes.contains(target);
        }

        private void addNeighborsToQueue(class_2338 self) {
            class_2680 targetState = this.world.method_8320(self);
            class_2350[] class_2350Array = targetState.method_26204();
            if (!(class_2350Array instanceof AbstractPipeBlock)) {
                return;
            }
            AbstractPipeBlock targetBlock = (AbstractPipeBlock)class_2350Array;
            for (class_2350 direction : class_2350.values()) {
                class_2338 neighbor = self.method_10093(direction);
                if (this.checkedPositions.contains(neighbor)) continue;
                if (!this.isValidTarget(neighbor)) {
                    this.checkedPositions.add(neighbor);
                    continue;
                }
                if (!targetBlock.isConnectingInDirection(targetState, direction, self, this.world, false)) continue;
                this.nextTargets.add(neighbor);
            }
        }
    }
}

